/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionResultDescriptor;
import org.apache.ignite.internal.jdbc.thin.QualifiedSQLQuery;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;

public final class AffinityCache {
    private final AffinityTopologyVersion ver;
    private final GridBoundedLinkedHashMap<Integer, UUID[]> cachePartitionsDistribution;
    private final GridBoundedLinkedHashMap<QualifiedSQLQuery, JdbcThinPartitionResultDescriptor> sqlCache;

    public AffinityCache(AffinityTopologyVersion ver, int partitionAwarenessPartDistributionsCacheSize, int partitionAwarenessSQLCacheSize) {
        this.ver = ver;
        this.cachePartitionsDistribution = new GridBoundedLinkedHashMap(partitionAwarenessPartDistributionsCacheSize);
        this.sqlCache = new GridBoundedLinkedHashMap(partitionAwarenessSQLCacheSize);
    }

    public AffinityTopologyVersion version() {
        return this.ver;
    }

    void addCacheDistribution(Integer cacheId, UUID[] distribution) {
        for (Map.Entry entry : this.cachePartitionsDistribution.entrySet()) {
            if (!Arrays.equals((Object[])entry.getValue(), distribution)) continue;
            this.cachePartitionsDistribution.put(cacheId, (UUID[])entry.getValue());
            return;
        }
        this.cachePartitionsDistribution.put(cacheId, distribution);
    }

    void addSqlQuery(QualifiedSQLQuery sql, JdbcThinPartitionResultDescriptor partRes) {
        this.sqlCache.put(sql, partRes == null ? JdbcThinPartitionResultDescriptor.EMPTY_DESCRIPTOR : partRes);
    }

    public JdbcThinPartitionResultDescriptor partitionResult(QualifiedSQLQuery sqlQry) {
        return (JdbcThinPartitionResultDescriptor)this.sqlCache.get(sqlQry);
    }

    public UUID[] cacheDistribution(int cacheId) {
        return (UUID[])this.cachePartitionsDistribution.get(cacheId);
    }
}

