/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.dto;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.apache.ignite.internal.util.io.GridByteArrayInputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.ObjectInputStreamWrapper;
import org.apache.ignite.marshaller.jdk.JdkMarshallerObjectInputStream;
import org.jetbrains.annotations.NotNull;

public class IgniteDataTransferObjectInput
implements ObjectInput {
    private final ObjectInputStream ois;

    public IgniteDataTransferObjectInput(ObjectInput in, MarshallerContext ctx) throws IOException {
        byte[] buf = U.readByteArray(in);
        GridByteArrayInputStream bis = new GridByteArrayInputStream(buf);
        this.ois = new JdkMarshallerObjectInputStream(bis, this.getClass().getClassLoader(), ctx.classNameFilter());
    }

    public IgniteDataTransferObjectInput(ObjectInput in) throws IOException {
        byte[] buf = U.readByteArray(in);
        GridByteArrayInputStream bis = new GridByteArrayInputStream(buf);
        this.ois = in instanceof ObjectInputStreamWrapper ? ((ObjectInputStreamWrapper)((Object)in)).wrap(bis) : new ObjectInputStream(bis);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.ois.readObject();
    }

    @Override
    public int read() throws IOException {
        return this.ois.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.ois.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.ois.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.ois.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.ois.available();
    }

    @Override
    public void close() throws IOException {
        this.ois.close();
    }

    @Override
    public void readFully(@NotNull byte[] b) throws IOException {
        this.ois.readFully(b);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        this.ois.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.ois.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.ois.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.ois.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.ois.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.ois.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.ois.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.ois.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.ois.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.ois.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.ois.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.ois.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.ois.readLine();
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        return this.ois.readUTF();
    }
}

