/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;

public class BinaryWriterSchemaHolder {
    private static final int MAX_OFFSET_1 = 256;
    private static final int MAX_OFFSET_2 = 65536;
    private static final int GROW_STEP = 64;
    private int[] data = new int[64];
    private int idx;

    public void push(int id, int off) {
        if (this.idx == this.data.length) {
            int[] data0 = new int[this.data.length + 64];
            System.arraycopy(this.data, 0, data0, 0, this.data.length);
            this.data = data0;
        }
        this.data[this.idx] = id;
        this.data[this.idx + 1] = off;
        this.idx += 2;
    }

    public void build(BinarySchema.Builder builder, int fieldCnt) {
        for (int curIdx = this.idx - fieldCnt * 2; curIdx < this.idx; curIdx += 2) {
            builder.addField(this.data[curIdx]);
        }
    }

    public int write(BinaryOutputStream out, int fieldCnt, boolean compactFooter) {
        int res;
        int startIdx = this.idx - fieldCnt * 2;
        assert (startIdx >= 0);
        out.unsafeEnsure(fieldCnt << 3);
        int lastOffset = this.data[this.idx - 1];
        if (compactFooter) {
            if (lastOffset < 256) {
                for (int curIdx = startIdx + 1; curIdx < this.idx; curIdx += 2) {
                    out.unsafeWriteByte((byte)this.data[curIdx]);
                }
                res = 1;
            } else if (lastOffset < 65536) {
                for (int curIdx = startIdx + 1; curIdx < this.idx; curIdx += 2) {
                    out.unsafeWriteShort((short)this.data[curIdx]);
                }
                res = 2;
            } else {
                for (int curIdx = startIdx + 1; curIdx < this.idx; curIdx += 2) {
                    out.unsafeWriteInt(this.data[curIdx]);
                }
                res = 4;
            }
        } else if (lastOffset < 256) {
            int curIdx = startIdx;
            while (curIdx < this.idx) {
                out.unsafeWriteInt(this.data[curIdx++]);
                out.unsafeWriteByte((byte)this.data[curIdx++]);
            }
            res = 1;
        } else if (lastOffset < 65536) {
            int curIdx = startIdx;
            while (curIdx < this.idx) {
                out.unsafeWriteInt(this.data[curIdx++]);
                out.unsafeWriteShort((short)this.data[curIdx++]);
            }
            res = 2;
        } else {
            int curIdx = startIdx;
            while (curIdx < this.idx) {
                out.unsafeWriteInt(this.data[curIdx++]);
                out.unsafeWriteInt(this.data[curIdx++]);
            }
            res = 4;
        }
        return res;
    }

    public void pop(int fieldCnt) {
        this.idx -= fieldCnt * 2;
    }
}

