/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8.meta;

import com.gridgain.cdc.gg9togg8.meta.Gg8FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg8TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9FieldMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9TableMetadata;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.table.QualifiedName;

public class MetadataUtils {
    public static Gg9TableMetadata getGg9TableMetadata(QualifiedName tableName, List<Column> columns) {
        ArrayList<Gg9FieldMetadata> keyMeta = new ArrayList<Gg9FieldMetadata>();
        ArrayList<Gg9FieldMetadata> valMeta = new ArrayList<Gg9FieldMetadata>();
        for (Column column : columns) {
            Gg9FieldMetadata meta = new Gg9FieldMetadata(column.name(), column.nullable(), column.type().spec());
            if (column.positionInKey() >= 0) {
                keyMeta.add(meta);
                continue;
            }
            valMeta.add(meta);
        }
        return new Gg9TableMetadata(tableName.schemaName(), tableName.objectName(), (List<Gg9FieldMetadata>)keyMeta, (List<Gg9FieldMetadata>)valMeta);
    }

    public static Gg8TableMetadata getGg8TableMetadata(IgniteClient cl, Connection conn, QualifiedName tableName) {
        List qryRes = cl.query(new SqlFieldsQuery("select key_type_name, value_type_name, cache_name from sys.tables t where t.schema_name = ? and t.table_name = ?").setArgs(new Object[]{tableName.schemaName(), tableName.objectName()})).getAll();
        if (qryRes.size() != 1) {
            throw new IllegalArgumentException("Incorrect or missing metadata for table " + tableName.toCanonicalForm());
        }
        String keyTypeName = (String)((List)qryRes.get(0)).get(0);
        String valTypeName = (String)((List)qryRes.get(0)).get(1);
        String cacheName = (String)((List)qryRes.get(0)).get(2);
        List<Gg8FieldMetadata> fields = MetadataUtils.getGg8FieldMetadata(cl, tableName);
        ArrayList<Gg8FieldMetadata> keyFields = new ArrayList<Gg8FieldMetadata>();
        ArrayList<Gg8FieldMetadata> valFields = new ArrayList<Gg8FieldMetadata>();
        Set<String> pks = MetadataUtils.getGg8PrimaryKeys(conn, tableName);
        for (Gg8FieldMetadata meta : fields) {
            if (pks.contains(meta.name())) {
                keyFields.add(meta);
                continue;
            }
            valFields.add(meta);
        }
        return new Gg8TableMetadata(tableName.schemaName(), tableName.objectName(), cacheName, keyTypeName, valTypeName, keyFields, valFields);
    }

    private static List<Gg8FieldMetadata> getGg8FieldMetadata(IgniteClient cl, QualifiedName tableName) {
        String sql = "SELECT column_name, type, nullable FROM sys.table_columns tc WHERE tc.schema_name = ? and tc.table_name = ? and tc.column_name not in ('_KEY', '_VAL')";
        List qryRes = cl.query(new SqlFieldsQuery(sql).setArgs(new Object[]{tableName.schemaName(), tableName.objectName()})).getAll();
        ArrayList<Gg8FieldMetadata> res = new ArrayList<Gg8FieldMetadata>();
        for (List row : qryRes) {
            String fieldName = (String)row.get(0);
            String type = (String)row.get(1);
            boolean nullable = (Boolean)row.get(2);
            res.add(new Gg8FieldMetadata(fieldName, nullable, type));
        }
        return res;
    }

    private static Set<String> getGg8PrimaryKeys(Connection conn, QualifiedName tableName) {
        try {
            ResultSet pkRes = conn.getMetaData().getPrimaryKeys(null, tableName.schemaName(), tableName.objectName());
            HashSet<String> pks = new HashSet<String>();
            while (pkRes.next()) {
                pks.add(pkRes.getString("COLUMN_NAME").toUpperCase());
            }
            return pks;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

