/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class JavaLoggerFormatter
extends Formatter {
    static final String ANONYMOUS_LOGGER_NAME = "UNKNOWN";
    static final DateTimeFormatter DATE_FMT = IgniteUtils.ISO_DATE_FMT;

    @Override
    public String format(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String logName = record.getLoggerName();
        if (logName == null || logName.isEmpty()) {
            logName = ANONYMOUS_LOGGER_NAME;
        } else if (logName.contains(".")) {
            logName = logName.substring(logName.lastIndexOf(46) + 1);
        }
        return "[" + DATE_FMT.format(Instant.ofEpochMilli(record.getMillis())) + "][" + record.getLevel() + "][" + threadName + "][" + logName + "] " + this.formatMessage(record) + (record.getThrown() == null ? Character.valueOf('\n') : JavaLoggerFormatter.formatStackTrace(record.getThrown()));
    }

    private static String formatStackTrace(@NotNull Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            pw.println();
            t.printStackTrace(new PrintWriter(sw));
        }
        return sw.toString();
    }

    public String toString() {
        return S.toString(JavaLoggerFormatter.class, this);
    }
}

