/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.query.VisorQueryField;
import org.apache.ignite.internal.visor.query.VisorQueryHolder;
import org.apache.ignite.internal.visor.query.VisorQueryScanRegexFilter;
import org.apache.ignite.internal.visor.query.VisorQueryTaskArg;
import org.apache.ignite.internal.visor.query.VisorScanQueryTaskArg;

public class VisorQueryUtils {
    public static final Integer RMV_DELAY = 300000;
    private static final String SQL_QRY_RESULTS_EXPIRED_ERR = "SQL query results are expired.";
    private static final String SCAN_QRY_RESULTS_EXPIRED_ERR = "Scan query results are expired.";
    public static final List<VisorQueryField> SCAN_COL_NAMES = Arrays.asList(new VisorQueryField(null, null, "Key Class", ""), new VisorQueryField(null, null, "Key", ""), new VisorQueryField(null, null, "Value Class", ""), new VisorQueryField(null, null, "Value", ""));

    private static String typeOf(Object o) {
        if (o != null) {
            Class<?> clazz = o.getClass();
            return clazz.isArray() ? IgniteUtils.compact(clazz.getComponentType().getName()) + "[]" : IgniteUtils.compact(o.getClass().getName());
        }
        return "n/a";
    }

    private static String valueOf(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof byte[]) {
            return "size=" + ((byte[])o).length;
        }
        if (o instanceof Byte[]) {
            return "size=" + ((Byte[])o).length;
        }
        if (o instanceof Object[]) {
            return "size=" + ((Object[])o).length + ", values=[" + S.joinToString(Arrays.asList((Object[])o), ", ", "...", 120, 0) + "]";
        }
        if (o instanceof BinaryObject) {
            return VisorQueryUtils.binaryToString((BinaryObject)o);
        }
        return o.toString();
    }

    public static List<Object[]> fetchScanQueryRows(Iterator itr, int pageSize) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Iterator scanItr = itr;
        for (int cnt = 0; scanItr.hasNext() && cnt < pageSize; ++cnt) {
            Cache.Entry next = (Cache.Entry)scanItr.next();
            Object k = next.getKey();
            Object v = next.getValue();
            rows.add(new Object[]{VisorQueryUtils.typeOf(k), VisorQueryUtils.valueOf(k), VisorQueryUtils.typeOf(v), VisorQueryUtils.valueOf(v)});
        }
        return rows;
    }

    private static boolean isKnownType(Object obj) {
        return obj instanceof String || obj instanceof Boolean || obj instanceof Byte || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof Date || obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal || obj instanceof URL;
    }

    public static String binaryToString(BinaryObject obj) {
        int hash = obj.hashCode();
        if (obj instanceof BinaryObjectEx) {
            BinaryType meta;
            BinaryObjectEx objEx = (BinaryObjectEx)obj;
            try {
                meta = ((BinaryObjectEx)obj).rawType();
            }
            catch (BinaryObjectException ignore) {
                meta = null;
            }
            if (meta != null) {
                if (meta.isEnum()) {
                    try {
                        return obj.deserialize().toString();
                    }
                    catch (BinaryObjectException ignore) {
                        // empty catch block
                    }
                }
                SB buf = new SB(meta.typeName());
                if (meta.fieldNames() != null) {
                    buf.a(" [hash=").a(hash);
                    for (String name : meta.fieldNames()) {
                        Object val = objEx.field(name);
                        buf.a(", ").a(name).a('=').a(val);
                    }
                    buf.a(']');
                    return buf.toString();
                }
            }
        }
        return S.toString(obj.getClass().getSimpleName(), "hash", (Object)hash, false, "typeId", (Object)obj.type().typeId(), true);
    }

    public static Object convertValue(Object original) {
        if (original == null) {
            return null;
        }
        if (VisorQueryUtils.isKnownType(original)) {
            return original;
        }
        if (original instanceof BinaryObject) {
            return VisorQueryUtils.binaryToString((BinaryObject)original);
        }
        return original.getClass().isArray() ? "binary" : original.toString();
    }

    public static List<Object[]> fetchSqlQueryRows(Iterator itr, int pageSize) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Iterator sqlItr = itr;
        for (int cnt = 0; sqlItr.hasNext() && cnt < pageSize; ++cnt) {
            List next = (List)sqlItr.next();
            int sz = next.size();
            Object[] row = new Object[sz];
            for (int i = 0; i < sz; ++i) {
                row[i] = VisorQueryUtils.convertValue(next.get(i));
            }
            rows.add(row);
        }
        return rows;
    }

    public static VisorQueryHolder getQueryHolder(IgniteEx ignite, String qryId) throws IgniteException {
        ConcurrentMap storage = ignite.cluster().nodeLocalMap();
        VisorQueryHolder holder = (VisorQueryHolder)storage.get(qryId);
        if (holder == null) {
            throw new IgniteException(VisorQueryHolder.isSqlQuery(qryId) ? SQL_QRY_RESULTS_EXPIRED_ERR : SCAN_QRY_RESULTS_EXPIRED_ERR);
        }
        return holder;
    }

    public static void removeQueryHolder(IgniteEx ignite, String qryId) {
        ConcurrentMap storage = ignite.cluster().nodeLocalMap();
        VisorQueryHolder holder = (VisorQueryHolder)storage.remove(qryId);
        if (holder != null) {
            holder.close();
        }
    }

    public static List<Object[]> fetchQueryRows(Iterator itr, String qryId, int pageSize) {
        return itr.hasNext() ? (VisorQueryHolder.isSqlQuery(qryId) ? VisorQueryUtils.fetchSqlQueryRows(itr, pageSize) : VisorQueryUtils.fetchScanQueryRows(itr, pageSize)) : Collections.emptyList();
    }

    public static void scheduleQueryStart(IgniteEx ignite, VisorQueryHolder holder, VisorQueryTaskArg arg, GridQueryCancel cancel) {
        IgniteSecurity security = ignite.context().security();
        SecurityContext initCtx = security.securityContext();
        ignite.context().closure().runLocalSafe(() -> {
            IgniteLogger log = ignite.log();
            try (OperationSecurityContext ignored = security.withContext(initCtx);){
                if (log.isDebugEnabled() && security.enabled()) {
                    log.debug("Operation started with subject: " + security.securityContext().subject());
                }
                SqlFieldsQuery qry = new SqlFieldsQuery(arg.getQueryText());
                qry.setPageSize(arg.getPageSize());
                qry.setLocal(arg.isLocal());
                qry.setDistributedJoins(arg.isDistributedJoins());
                qry.setCollocated(arg.isCollocated());
                qry.setEnforceJoinOrder(arg.isEnforceJoinOrder());
                qry.setReplicatedOnly(arg.isReplicatedOnly());
                qry.setLazy(arg.getLazy());
                String cacheName = arg.getCacheName();
                GridCacheContext cctx = null;
                if (!F.isEmpty(cacheName)) {
                    qry.setSchema(cacheName);
                    IgniteInternalCache cache = ignite.cachex(cacheName);
                    if (cache == null) {
                        throw new IgniteException("Failed to find a cache with the specified name to use as the default schema.");
                    }
                    cctx = cache.context();
                }
                long start = System.currentTimeMillis();
                List<FieldsQueryCursor<List<?>>> qryCursors = ignite.context().query().querySqlFields(cctx, qry, null, true, false, cancel);
                for (int i = 0; i < qryCursors.size() - 1; ++i) {
                    U.closeQuiet(qryCursors.get(i));
                }
                FieldsQueryCursor<List<?>> cur = F.last(qryCursors);
                try {
                    VisorQueryHolder actualHolder = VisorQueryUtils.getQueryHolder(ignite, holder.getQueryID());
                    List<GridQueryFieldMetadata> meta = ((QueryCursorEx)((Object)cur)).fieldsMeta();
                    if (meta == null) {
                        actualHolder.setError(new SQLException("Fail to execute query. No metadata available."));
                    } else {
                        ArrayList<VisorQueryField> cols = new ArrayList<VisorQueryField>(meta.size());
                        for (GridQueryFieldMetadata col : meta) {
                            cols.add(new VisorQueryField(col.schemaName(), col.typeName(), col.fieldName(), col.fieldTypeName()));
                        }
                        actualHolder.complete(cur, System.currentTimeMillis() - start, cols);
                    }
                    VisorQueryUtils.scheduleQueryHolderRemoval(ignite, actualHolder.getQueryID());
                }
                catch (Throwable e) {
                    U.closeQuiet(cur);
                    throw e;
                }
            }
            catch (Throwable e) {
                log.warning("Fail to execute query.", e);
                holder.setError(e);
            }
        }, (byte)3);
    }

    public static void scheduleScanStart(IgniteEx ignite, VisorQueryHolder holder, VisorScanQueryTaskArg arg) {
        ignite.context().closure().runLocalSafe(() -> {
            try {
                QueryCursor<Object> cur;
                IgniteCache c = ignite.cache(arg.getCacheName());
                String filterText = arg.getFilter();
                VisorQueryScanRegexFilter filter = null;
                if (!F.isEmpty(filterText)) {
                    filter = new VisorQueryScanRegexFilter(arg.isCaseSensitive(), arg.isRegEx(), filterText);
                }
                long start = System.currentTimeMillis();
                if (arg.isNear()) {
                    cur = new VisorNearCacheCursor(c.localEntries(CachePeekMode.NEAR).iterator());
                } else {
                    ScanQuery<Object, Object> qry = new ScanQuery<Object, Object>(filter);
                    qry.setPageSize(arg.getPageSize());
                    qry.setLocal(arg.isLocal());
                    cur = c.withKeepBinary().query(qry);
                }
                try {
                    VisorQueryHolder actualHolder = VisorQueryUtils.getQueryHolder(ignite, holder.getQueryID());
                    actualHolder.complete(cur, System.currentTimeMillis() - start, SCAN_COL_NAMES);
                    VisorQueryUtils.scheduleQueryHolderRemoval(ignite, actualHolder.getQueryID());
                }
                catch (Throwable e) {
                    U.closeQuiet(cur);
                    throw e;
                }
            }
            catch (Throwable e) {
                holder.setError(e);
            }
        }, (byte)3);
    }

    public static void scheduleQueryHolderRemoval(final IgniteEx ignite, final String qryId) {
        ignite.context().timeout().addTimeoutObject(new GridTimeoutObjectAdapter(RMV_DELAY.intValue()){

            @Override
            public void onTimeout() {
                ConcurrentMap storage = ignite.cluster().nodeLocalMap();
                VisorQueryHolder holder = (VisorQueryHolder)storage.get(qryId);
                if (holder != null) {
                    if (holder.isAccessed()) {
                        holder.setAccessed(false);
                        VisorQueryUtils.scheduleQueryHolderRemoval(ignite, qryId);
                    } else {
                        VisorQueryUtils.removeQueryHolder(ignite, qryId);
                    }
                }
            }
        });
    }

    private static class VisorNearCacheCursor<T>
    implements QueryCursor<T> {
        private final Iterator<T> it;

        private VisorNearCacheCursor(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public List<T> getAll() {
            ArrayList<T> all = new ArrayList<T>();
            while (this.it.hasNext()) {
                all.add(this.it.next());
            }
            return all;
        }

        @Override
        public void close() {
        }

        @Override
        public Iterator<T> iterator() {
            return this.it;
        }
    }
}

