/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorMetricsConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long expTime;
    private int histSize;
    private long logFreq;

    public VisorMetricsConfiguration() {
    }

    public VisorMetricsConfiguration(IgniteConfiguration c) {
        this.expTime = c.getMetricsExpireTime();
        this.histSize = c.getMetricsHistorySize();
        this.logFreq = c.getMetricsLogFrequency();
    }

    public long getExpireTime() {
        return this.expTime;
    }

    public int getHistorySize() {
        return this.histSize;
    }

    public long getLoggerFrequency() {
        return this.logFreq;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.expTime);
        out.writeInt(this.histSize);
        out.writeLong(this.logFreq);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.expTime = in.readLong();
        this.histSize = in.readInt();
        this.logFreq = in.readLong();
    }

    public String toString() {
        return S.toString(VisorMetricsConfiguration.class, this);
    }
}

