/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.GridSerializableMap;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.gridfunc.IsAllPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredicateSetView<K, V>
extends GridSerializableMap<K, V> {
    private static final long serialVersionUID = 0L;
    private final Set<K> set;
    private final IgniteClosure<? super K, V> clo;
    private final IgnitePredicate<? super K>[] preds;
    private IgnitePredicate<K> entryPred;

    public PredicateSetView(Set<K> set, IgniteClosure<? super K, V> clo, IgnitePredicate<? super K> ... preds) {
        this.set = set;
        this.clo = clo;
        this.preds = preds;
        this.entryPred = new IsAllPredicate<K>(preds);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new GridSerializableSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private Iterator<K> it;
                    {
                        this.it = GridFunc.iterator0(PredicateSetView.this.set, true, PredicateSetView.this.entryPred);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Object e = this.it.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return e;
                            }

                            @Override
                            public V getValue() {
                                return PredicateSetView.this.clo.apply(e);
                            }

                            @Override
                            public V setValue(V val) {
                                throw new UnsupportedOperationException("Put is not supported for readonly collection view.");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not support for readonly collection view.");
                    }
                };
            }

            @Override
            public int size() {
                return F.size(PredicateSetView.this.set, PredicateSetView.this.preds);
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Remove is not support for readonly collection view.");
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (this.containsKey(key)) {
            return this.clo.apply(key);
        }
        return null;
    }

    @Override
    @Nullable
    public V put(K key, V val) {
        throw new UnsupportedOperationException("Put is not supported for readonly collection view.");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Remove is not supported for readonly collection view.");
    }

    @Override
    public boolean containsKey(Object key) {
        return GridFunc.isAll(key, this.preds) && this.set.contains(key);
    }
}

