/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.updatelog;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.Factory;
import org.apache.ignite.internal.processors.cache.tree.updatelog.PartitionLogTree;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLog;
import org.apache.ignite.internal.processors.cache.tree.updatelog.UpdateLogRow;
import org.apache.ignite.internal.util.lang.GridCursor;

public class UpdateLogImpl
implements UpdateLog {
    private final Factory<PartitionLogTree> factory;
    private volatile PartitionLogTree logTree;

    public UpdateLogImpl(PartitionLogTree logTree) {
        this.logTree = logTree;
        this.factory = null;
    }

    public UpdateLogImpl(Factory<PartitionLogTree> factory) {
        this.factory = factory;
    }

    @Override
    public void destroy() throws IgniteCheckedException {
        if (this.hasTree()) {
            this.logTree.destroy();
        }
    }

    @Override
    public void put(UpdateLogRow row) throws IgniteCheckedException {
        this.init();
        this.logTree.putx(row);
    }

    @Override
    public PartitionLogTree tree() throws IgniteCheckedException {
        this.init();
        return this.logTree;
    }

    @Override
    public boolean hasTree() {
        return this.logTree != null;
    }

    @Override
    public GridCursor<UpdateLogRow> find(UpdateLogRow lower, UpdateLogRow upper) throws IgniteCheckedException {
        if (this.hasTree()) {
            return this.logTree.find(lower, upper);
        }
        return GridCursor.EMPTY_CURSOR;
    }

    @Override
    public void remove(UpdateLogRow row) throws IgniteCheckedException {
        if (this.hasTree()) {
            this.logTree.removex(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IgniteCheckedException {
        if (this.hasTree()) {
            return;
        }
        UpdateLogImpl updateLogImpl = this;
        synchronized (updateLogImpl) {
            if (!this.hasTree()) {
                assert (this.factory != null);
                this.logTree = this.factory.create();
            }
        }
    }
}

