/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousQueryBatch;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

class CacheContinuousQueryAcknowledgeBuffer {
    private int size;
    @GridToStringInclude
    private Map<Integer, Long> updateCntrs = new HashMap<Integer, Long>();

    CacheContinuousQueryAcknowledgeBuffer() {
    }

    @Nullable
    synchronized Map<Integer, Long> onAcknowledged(GridContinuousBatch batch) {
        assert (batch instanceof GridContinuousQueryBatch);
        this.size += ((GridContinuousQueryBatch)batch).entriesCount();
        Collection<Object> entries = batch.collect();
        for (CacheContinuousQueryEntry cacheContinuousQueryEntry : entries) {
            this.addEntry(cacheContinuousQueryEntry);
        }
        return this.size >= CacheContinuousQueryHandler.ACK_THRESHOLD ? this.acknowledgeData() : null;
    }

    private void addEntry(CacheContinuousQueryEntry e) {
        Long cntr0 = this.updateCntrs.get(e.partition());
        if (cntr0 == null || e.updateCounter() > cntr0) {
            this.updateCntrs.put(e.partition(), e.updateCounter());
        }
    }

    private Map<Integer, Long> acknowledgeData() {
        assert (this.size > 0);
        HashMap<Integer, Long> cntrs = new HashMap<Integer, Long>(this.updateCntrs);
        this.updateCntrs.clear();
        this.size = 0;
        return cntrs;
    }

    public String toString() {
        return S.toString(CacheContinuousQueryAcknowledgeBuffer.class, this);
    }
}

