/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousQueryBatch;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

class CacheContinuousQueryAcknowledgeBackupBuffer {
    private int size;
    @GridToStringInclude
    private Map<Integer, Long> updateCntrs = new HashMap<Integer, Long>();
    @GridToStringInclude
    private Set<AffinityTopologyVersion> topVers = U.newHashSet(1);

    CacheContinuousQueryAcknowledgeBackupBuffer() {
    }

    @Nullable
    synchronized IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> onAcknowledged(GridContinuousBatch batch) {
        assert (batch instanceof GridContinuousQueryBatch);
        this.size += ((GridContinuousQueryBatch)batch).entriesCount();
        Collection<Object> entries = batch.collect();
        for (CacheContinuousQueryEntry cacheContinuousQueryEntry : entries) {
            this.addEntry(cacheContinuousQueryEntry);
        }
        return this.size >= CacheContinuousQueryHandler.BACKUP_ACK_THRESHOLD ? this.acknowledgeData() : null;
    }

    @Nullable
    synchronized IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> onAcknowledged(CacheContinuousQueryEntry e) {
        ++this.size;
        this.addEntry(e);
        return this.size >= CacheContinuousQueryHandler.BACKUP_ACK_THRESHOLD ? this.acknowledgeData() : null;
    }

    private void addEntry(CacheContinuousQueryEntry e) {
        this.topVers.add(e.topologyVersion());
        Long cntr0 = this.updateCntrs.get(e.partition());
        if (cntr0 == null || e.updateCounter() > cntr0) {
            this.updateCntrs.put(e.partition(), e.updateCounter());
        }
    }

    @Nullable
    synchronized IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> acknowledgeOnTimeout() {
        return this.size > 0 ? this.acknowledgeData() : null;
    }

    private IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> acknowledgeData() {
        assert (this.size > 0);
        HashMap<Integer, Long> cntrs = new HashMap<Integer, Long>(this.updateCntrs);
        IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> res = new IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>>(cntrs, this.topVers);
        this.topVers = U.newHashSet(1);
        this.updateCntrs.clear();
        this.size = 0;
        return res;
    }

    public String toString() {
        return S.toString(CacheContinuousQueryAcknowledgeBackupBuffer.class, this);
    }
}

