/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.typedef.F;

public class GridCacheQueryDetailMetricsKey {
    private final GridCacheQueryType qryType;
    private final String qry;
    private final int hash;

    public GridCacheQueryDetailMetricsKey(GridCacheQueryType qryType, String qry) {
        assert (qryType != null);
        assert (qryType != GridCacheQueryType.SQL_FIELDS || qry != null);
        this.qryType = qryType;
        this.qry = qry;
        this.hash = 31 * qryType.hashCode() + (qry != null ? qry.hashCode() : 0);
    }

    public GridCacheQueryType getQueryType() {
        return this.qryType;
    }

    public String getQuery() {
        return this.qry;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheQueryDetailMetricsKey other = (GridCacheQueryDetailMetricsKey)o;
        return this.qryType == other.qryType && F.eq(this.qry, other.qry);
    }
}

