/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.jetbrains.annotations.Nullable;

class CheckpointPages {
    private final Collection<FullPageId> pageIds;
    private final CheckpointProgressImpl checkpointProgress;

    CheckpointPages(Collection<FullPageId> pageIds, @Nullable CheckpointProgress checkpointProgress) {
        this.pageIds = pageIds;
        this.checkpointProgress = (CheckpointProgressImpl)checkpointProgress;
    }

    public boolean removeOnPageReplacement(FullPageId pageId) throws IgniteCheckedException {
        assert (this.checkpointProgress != null) : "No page replacement expected on binary recovery";
        this.checkpointProgress.futureFor(CheckpointState.MARKER_STORED_TO_DISK).getUninterruptibly();
        return this.pageIds.remove(pageId);
    }

    public boolean removeOnCheckpoint(FullPageId pageId) {
        return this.pageIds.remove(pageId);
    }

    public void removeOnRefreshOutdatedPage(FullPageId pageId) {
        this.pageIds.remove(pageId);
    }

    public boolean contains(FullPageId pageId) {
        return this.pageIds.contains(pageId);
    }

    public int size() {
        return this.pageIds.size();
    }

    public void blockFsyncOnPageReplacement(FullPageId pageId) {
        assert (this.checkpointProgress != null) : "No page replacement expected on binary recovery";
        this.checkpointProgress.blockFsyncOnPageReplacement(pageId);
    }

    public void unblockFsyncOnPageReplacement(FullPageId pageId, @Nullable Throwable error) {
        assert (this.checkpointProgress != null) : "No page replacement expected on binary recovery";
        this.checkpointProgress.unblockFsyncOnPageReplacement(pageId, error);
    }
}

