/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import org.apache.ignite.binary.BinaryObjectException;

final class MetadataRemoveResult {
    private final ResultType resType;
    private final BinaryObjectException error;

    private MetadataRemoveResult(ResultType resType, BinaryObjectException error) {
        this.resType = resType;
        this.error = error;
    }

    boolean rejected() {
        return this.resType == ResultType.REJECT;
    }

    BinaryObjectException error() {
        return this.error;
    }

    static MetadataRemoveResult createSuccessfulResult() {
        return new MetadataRemoveResult(ResultType.SUCCESS, null);
    }

    static MetadataRemoveResult createFailureResult(BinaryObjectException err) {
        assert (err != null);
        return new MetadataRemoveResult(ResultType.REJECT, err);
    }

    static MetadataRemoveResult createUpdateDisabledResult() {
        return new MetadataRemoveResult(ResultType.UPDATE_DISABLED, null);
    }

    private static enum ResultType {
        SUCCESS,
        REJECT,
        UPDATE_DISABLED;

    }
}

