/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.CheckCpHistTask;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;

public interface ShutdownPolicyHandler {
    public void handle();

    public void stopHandling();

    public static void cleanupOnActive(GridKernalContext ctx) {
        if (!SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE")) {
            return;
        }
        try {
            if (ShutdownPolicy.GRACEFUL == ctx.config().getShutdownPolicy()) {
                ctx.distributedMetastorage().remove("ignite.internal.graceful.shutdown");
                ctx.distributedMetastorage().remove("ignite.internal.graceful.shutdown.intention");
            }
        }
        catch (IgniteCheckedException | IgniteException exception) {
            // empty catch block
        }
    }

    public static ShutdownPolicyHandler create(ShutdownPolicy shutdownPolicy, IgniteKernal grid0, IgniteLogger log) {
        switch (shutdownPolicy) {
            case GRACEFUL: {
                return new GracefulShutdownPolicyHandler(grid0, log);
            }
            case IMMEDIATE: {
                return new ImmediateShutdownPolicyHandler();
            }
        }
        throw new IgniteException("Unknown shutdown policy [plc=" + (Object)((Object)shutdownPolicy) + ']');
    }

    public static class GracefulShutdownPolicyHandler
    implements ShutdownPolicyHandler {
        static final String GRACEFUL_SHUTDOWN_METASTORE_KEY = "ignite.internal.graceful.shutdown";
        static final String GRACEFUL_CLUSTER_SHUTDOWN_METASTORE_KEY = "ignite.internal.graceful.shutdown.intention";
        static final int WAIT_FOR_BACKUPS_CHECK_INTERVAL = 1000;
        private final IgniteKernal grid0;
        private volatile boolean delayedShutdown = true;
        private final IgniteLogger log;

        GracefulShutdownPolicyHandler(IgniteKernal grid0, IgniteLogger log) {
            this.grid0 = grid0;
            this.log = log;
        }

        @Override
        public void stopHandling() {
            this.delayedShutdown = false;
        }

        @Override
        public void handle() {
            if (this.grid0.context().clientNode() || !ClusterState.active(this.grid0.cluster().state())) {
                return;
            }
            if (!SupportFeaturesUtils.isFeatureEnabled("IGNITE_DISTRIBUTED_META_STORAGE_FEATURE")) {
                LT.warn(this.log, "Graceful shutdown policy is skipped because 'IGNITE_DISTRIBUTED_META_STORAGE_FEATURE' is disabled.");
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Ensuring that caches have sufficient backups and local rebalance completion...");
            }
            DistributedMetaStorage metaStorage = this.grid0.context().distributedMetastorage();
            block12: while (this.delayedShutdown) {
                HashSet<UUID> nodesToExclude;
                HashSet originalNodesToExclude;
                boolean safeToStop = true;
                long topVer = this.grid0.cluster().topologyVersion();
                switch (this.handleClusterShutdownIntention(metaStorage, topVer)) {
                    case RETRY: {
                        continue block12;
                    }
                    case SAFE_TO_STOP: {
                        return;
                    }
                }
                try {
                    originalNodesToExclude = (HashSet)metaStorage.read(GRACEFUL_SHUTDOWN_METASTORE_KEY);
                    nodesToExclude = originalNodesToExclude != null ? new HashSet<UUID>(originalNodesToExclude) : new HashSet();
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Unable to read 'ignite.internal.graceful.shutdown' value from metastore.", e);
                    continue;
                }
                HashMap<UUID, Map<Integer, Set<Integer>>> proposedSuppliers = new HashMap<UUID, Map<Integer, Set<Integer>>>();
                for (CacheGroupContext cacheGroupContext : this.grid0.context().cache().cacheGroups()) {
                    if (cacheGroupContext.isLocal() || cacheGroupContext.systemCache()) continue;
                    if (cacheGroupContext.config().getCacheMode() == CacheMode.PARTITIONED && cacheGroupContext.config().getBackups() == 0) {
                        LT.warn(this.log, "Ignoring potential data loss on cache without backups [name=" + cacheGroupContext.cacheOrGroupName() + ']');
                        continue;
                    }
                    if (topVer != cacheGroupContext.topology().readyTopologyVersion().topologyVersion()) {
                        safeToStop = false;
                        break;
                    }
                    GridDhtPartitionFullMap fullMap = cacheGroupContext.topology().partitionMap(false);
                    if (fullMap == null) {
                        safeToStop = false;
                        break;
                    }
                    nodesToExclude.retainAll(fullMap.keySet());
                    if (!this.haveCopyLocalPartitions(cacheGroupContext, nodesToExclude, proposedSuppliers)) {
                        safeToStop = false;
                        if (!this.log.isInfoEnabled()) break;
                        LT.info(this.log, "This node is waiting for backups of local partitions for group [id=" + cacheGroupContext.groupId() + ", name=" + cacheGroupContext.cacheOrGroupName() + ']');
                        break;
                    }
                    if (this.isRebalanceCompleted(cacheGroupContext)) continue;
                    safeToStop = false;
                    if (!this.log.isInfoEnabled()) break;
                    LT.info(this.log, "This node is waiting for completion of rebalance for group [id=" + cacheGroupContext.groupId() + ", name=" + cacheGroupContext.cacheOrGroupName() + ']');
                    break;
                }
                if (topVer != this.grid0.cluster().topologyVersion()) {
                    safeToStop = false;
                }
                if (safeToStop && !proposedSuppliers.isEmpty()) {
                    HashSet<UUID> supportedPolicyNodes = new HashSet<UUID>();
                    for (UUID nodeId : proposedSuppliers.keySet()) {
                        if (!IgniteFeatures.nodeSupports(this.grid0.context(), this.grid0.cluster().node(nodeId), IgniteFeatures.SHUTDOWN_POLICY)) continue;
                        supportedPolicyNodes.add(nodeId);
                    }
                    if (!supportedPolicyNodes.isEmpty()) {
                        try {
                            safeToStop = (Boolean)this.grid0.compute(this.grid0.cluster().forNodeIds(supportedPolicyNodes)).execute(CheckCpHistTask.class, proposedSuppliers);
                        }
                        catch (ClusterTopologyException clusterTopologyException) {
                            safeToStop = false;
                        }
                    }
                }
                if (safeToStop) {
                    try {
                        HashSet<UUID> newNodesToExclude = new HashSet<UUID>(nodesToExclude);
                        newNodesToExclude.add(this.grid0.getLocalNodeId());
                        if (metaStorage.compareAndSet(GRACEFUL_SHUTDOWN_METASTORE_KEY, originalNodesToExclude, newNodesToExclude)) {
                            break;
                        }
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Unable to write 'ignite.internal.graceful.shutdown' value to metastore.", e);
                        continue;
                    }
                }
                try {
                    IgniteUtils.sleep(1000L);
                }
                catch (IgniteInterruptedCheckedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private ShutdownIntentionResult handleClusterShutdownIntention(DistributedMetaStorage metaStorage, long topVer) {
            Set actualIds;
            HashSet<UUID> clusterShutdownIntention;
            HashSet originalClusterShutdownIntention;
            try {
                originalClusterShutdownIntention = (HashSet)metaStorage.read(GRACEFUL_CLUSTER_SHUTDOWN_METASTORE_KEY);
                clusterShutdownIntention = originalClusterShutdownIntention == null ? new HashSet<UUID>() : new HashSet(originalClusterShutdownIntention);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Unable to read 'ignite.internal.graceful.shutdown.intention' value from metastore.", e);
                return ShutdownIntentionResult.RETRY;
            }
            if (!clusterShutdownIntention.contains(this.grid0.getLocalNodeId())) {
                try {
                    clusterShutdownIntention.add(this.grid0.getLocalNodeId());
                    boolean updated = metaStorage.compareAndSet(GRACEFUL_CLUSTER_SHUTDOWN_METASTORE_KEY, originalClusterShutdownIntention, clusterShutdownIntention);
                    if (!updated) {
                        return ShutdownIntentionResult.RETRY;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Unable to write 'ignite.internal.graceful.shutdown.intention' value to metastore.", e);
                    return ShutdownIntentionResult.RETRY;
                }
            }
            if (clusterShutdownIntention.containsAll(actualIds = this.grid0.cluster().forServers().nodes().stream().map(ClusterNode::id).collect(Collectors.toSet())) && topVer == this.grid0.cluster().topologyVersion()) {
                return ShutdownIntentionResult.SAFE_TO_STOP;
            }
            return ShutdownIntentionResult.SAFE_TO_PROCEED;
        }

        private boolean haveCopyLocalPartitions(CacheGroupContext grpCtx, Set<UUID> nodesToExclude, Map<UUID, Map<Integer, Set<Integer>>> proposedSuppliers) {
            GridDhtPartitionFullMap fullMap = grpCtx.topology().partitionMap(false);
            if (fullMap == null) {
                return false;
            }
            UUID localNodeId = this.grid0.getLocalNodeId();
            GridDhtPartitionMap localPartMap = (GridDhtPartitionMap)fullMap.get(localNodeId);
            int parts = grpCtx.topology().partitions();
            List<List<ClusterNode>> idealAssignment = grpCtx.affinity().idealAssignmentRaw();
            for (int p = 0; p < parts; ++p) {
                if (localPartMap.get(p) != GridDhtPartitionState.OWNING) continue;
                boolean foundCopy = false;
                for (Map.Entry entry : fullMap.entrySet()) {
                    if (localNodeId.equals(entry.getKey()) || nodesToExclude.contains(entry.getKey()) || !idealAssignment.get(p).stream().anyMatch(node -> node.id().equals(entry.getKey())) || ((GridDhtPartitionMap)entry.getValue()).hasMovingPartitions() || ((GridDhtPartitionMap)entry.getValue()).get(p) != GridDhtPartitionState.OWNING) continue;
                    proposedSuppliers.computeIfAbsent((UUID)entry.getKey(), (Function<UUID, Map<Integer, Set<Integer>>>)((Function<UUID, Map>)nodeId -> new HashMap())).computeIfAbsent(grpCtx.groupId(), grpId -> new HashSet()).add(p);
                    foundCopy = true;
                }
                if (foundCopy) continue;
                return false;
            }
            return true;
        }

        private boolean isRebalanceCompleted(CacheGroupContext grpCtx) {
            if (!grpCtx.preloader().rebalanceFuture().isDone()) {
                return false;
            }
            grpCtx.preloader().pause();
            try {
                boolean bl = !((GridDhtPreloader)grpCtx.preloader()).supplier().isSupply();
                return bl;
            }
            finally {
                grpCtx.preloader().resume();
            }
        }

        private static enum ShutdownIntentionResult {
            RETRY,
            SAFE_TO_STOP,
            SAFE_TO_PROCEED;

        }
    }

    public static class ImmediateShutdownPolicyHandler
    implements ShutdownPolicyHandler {
        @Override
        public void handle() {
        }

        @Override
        public void stopHandling() {
        }
    }
}

