/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.lang.IgniteExperimental;
import org.jetbrains.annotations.Nullable;

public final class IgniteSystemProperties {
    @Deprecated
    @SystemProperty(value="If this system property is present Ignite will include grid name into verbose log", type=String.class)
    public static final String IGNITE_LOG_GRID_NAME = "IGNITE_LOG_GRID_NAME";
    @SystemProperty(value="If this system property is present Ignite will include instance name into verbose log", type=String.class)
    public static final String IGNITE_LOG_INSTANCE_NAME = "IGNITE_LOG_INSTANCE_NAME";
    @SystemProperty(value="Exit code to pass to loader when Ignite instance is being restarted", type=Integer.class, defaults="0")
    public static final String IGNITE_RESTART_CODE = "IGNITE_RESTART_CODE";
    @SystemProperty(value="If true Ignite will start as a daemon node. Note that this system property will override IgniteConfiguration.isDaemon() configuration")
    public static final String IGNITE_DAEMON = "IGNITE_DAEMON";
    @SystemProperty(value="Defines Ignite installation folder", type=String.class, defaults="")
    public static final String IGNITE_HOME = "IGNITE_HOME";
    @SystemProperty(value="If true then no shutdown hook will be set")
    public static final String IGNITE_NO_SHUTDOWN_HOOK = "IGNITE_NO_SHUTDOWN_HOOK";
    @SystemProperty(value="If true requirement for proper node ordering by discovery SPI will be disabled. Use with care, as proper node ordering is required for cache consistency. If set to true, then any discovery SPI can be used with distributed cache, otherwise, only discovery SPIs that have annotation @GridDiscoverySpiOrderSupport(true) will be allowed")
    public static final String IGNITE_NO_DISCO_ORDER = "IGNITE_NO_DISCO_ORDER";
    @SystemProperty(value="Reconnect delay in milliseconds for client node that was failed forcible", type=Long.class, defaults="10000 milliseconds")
    public static final String IGNITE_DISCO_FAILED_CLIENT_RECONNECT_DELAY = "IGNITE_DISCO_FAILED_CLIENT_RECONNECT_DELAY";
    @SystemProperty(value="If this system property is set to false - no checks for new versions will be performed by Ignite. By default, Ignite periodically checks for the new version and prints out the message into the log if a new version of Ignite is available for download. Update notifier enabled flag is a cluster-wide value and determined according to the local setting during the start of the first node in the cluster. The chosen value will survive the first node shutdown and will override the property value on all newly joining nodes", defaults="true")
    public static final String IGNITE_UPDATE_NOTIFIER = "IGNITE_UPDATE_NOTIFIER";
    @SystemProperty(value="Url of updates service", type=String.class, defaults="https://www.gridgain.com/notifier/update/v2")
    public static final String GRIDGAIN_UPDATE_URL = "GRIDGAIN_UPDATE_URL";
    @SystemProperty(value="Interval in milliseconds in which Ignite will check thread pool state for starvation. Zero value will disable checker", type=Long.class, defaults="30000 milliseconds")
    public static final String IGNITE_STARVATION_CHECK_INTERVAL = "IGNITE_STARVATION_CHECK_INTERVAL";
    @SystemProperty(value="If this system property is present (any value) - no ASCII logo will be printed")
    public static final String IGNITE_NO_ASCII = "IGNITE_NO_ASCII";
    @SystemProperty(value="Jetty host for REST processor", type=String.class)
    public static final String IGNITE_JETTY_HOST = "IGNITE_JETTY_HOST";
    @SystemProperty(value="Jetty local port for REST processor", type=Integer.class)
    public static final String IGNITE_JETTY_PORT = "IGNITE_JETTY_PORT";
    @SystemProperty(value="If true then disallow Ignite to override Jetty log configuration for REST processor")
    public static final String IGNITE_JETTY_LOG_NO_OVERRIDE = "IGNITE_JETTY_LOG_NO_OVERRIDE";
    @SystemProperty(value="REST session expire time in seconds", type=Long.class, defaults="30 seconds")
    public static final String IGNITE_REST_SESSION_TIMEOUT = "IGNITE_REST_SESSION_TIMEOUT";
    @SystemProperty(value="REST session security token expire time in seconds", type=Long.class, defaults="300 seconds")
    public static final String IGNITE_REST_SECURITY_TOKEN_TIMEOUT = "IGNITE_REST_SECURITY_TOKEN_TIMEOUT";
    @SystemProperty(value="Maximum count of task results stored on one node in REST processor", type=Integer.class, defaults="10240")
    public static final String IGNITE_REST_MAX_TASK_RESULTS = "IGNITE_REST_MAX_TASK_RESULTS";
    @SystemProperty(value="This property allows to override default behavior that rest processor doesn't start on client node. If set {@code true} than rest processor will be started on client node", defaults="false")
    public static final String IGNITE_REST_START_ON_CLIENT = "IGNITE_REST_START_ON_CLIENT";
    @Deprecated
    @SystemProperty(value="Changes output format of {@link GridRestCommand#CACHE_GET_ALL} from {k: v, ...} to [{\"key\": k, \"value\": v}, ...] to allow non-string keys output", defaults="false")
    public static final String IGNITE_REST_GETALL_AS_ARRAY = "IGNITE_REST_GETALL_AS_ARRAY";
    @SystemProperty(value="Defines the maximum number of attempts to remap near get to the same primary node. Remapping may be needed when topology is changed concurrently with get operation", type=Integer.class, defaults="3")
    public static final String IGNITE_NEAR_GET_MAX_REMAPS = "IGNITE_NEAR_GET_MAX_REMAPS";
    @SystemProperty(value="In quiet mode, only warning and errors are printed into the log additionally to a shortened version of standard output on the start. Note that if you use ignite.{sh|bat} scripts to start Ignite they start by default in verbose mode. You can supply -q flag to override it", defaults="false")
    public static final String IGNITE_QUIET = "IGNITE_QUIET";
    @SystemProperty(value="Enables troubleshooting logger. Troubleshooting logger makes logging more verbose without enabling debug mode to provide more detailed logs without performance penalty")
    public static final String IGNITE_TROUBLESHOOTING_LOGGER = "IGNITE_TROUBLESHOOTING_LOGGER";
    @Deprecated
    @SystemProperty(value="Enables writing sensitive information in toString() output")
    public static final String IGNITE_TO_STRING_INCLUDE_SENSITIVE = "IGNITE_TO_STRING_INCLUDE_SENSITIVE";
    @SystemProperty(value="Setting to {@code \"plain\"} enables writing sensitive information in {@code toString()} output. Setting to {@code \"hash\"} enables writing hash of sensitive information in {@code toString()} output. Setting to {@code \"none\"} disables writing sensitive information in {@code toString()} output. IGNITE_TO_STRING_INCLUDE_SENSITIVE has higher priority. If it is explicitly set, then it is converted: \"true\" -> \"plain\", \"false\" -> \"none\"", type=String.class, defaults="hash")
    public static final String IGNITE_SENSITIVE_DATA_LOGGING = "IGNITE_SENSITIVE_DATA_LOGGING";
    @SystemProperty(value="Maximum length for toString() result", type=Integer.class, defaults="10000")
    public static final String IGNITE_TO_STRING_MAX_LENGTH = "IGNITE_TO_STRING_MAX_LENGTH";
    @SystemProperty(value="Boolean flag indicating whether GridToStringBuilder should throw RuntimeException      * when building string representation of an object or should just print information about exception into the log      * and proceed", defaults="false")
    public static final String IGNITE_TO_STRING_THROW_RUNTIME_EXCEPTION = "IGNITE_TO_STRING_THROW_RUNTIME_EXCEPTION";
    @SystemProperty(value="Number of collection (map, array) elements to output", type=Integer.class, defaults="100")
    public static final String IGNITE_TO_STRING_COLLECTION_LIMIT = "IGNITE_TO_STRING_COLLECTION_LIMIT";
    @SystemProperty(value="If true (default) and Ignite is launched in verbose mode (see IGNITE_QUIET) and no console appenders can be found in configuration, then default console appender will be added. Set this property to false if no appenders should be added", defaults="true")
    public static final String IGNITE_CONSOLE_APPENDER = "IGNITE_CONSOLE_APPENDER";
    @SystemProperty(value="Maximum size for exchange history", type=Integer.class, defaults="1000")
    public static final String IGNITE_EXCHANGE_HISTORY_SIZE = "IGNITE_EXCHANGE_HISTORY_SIZE";
    @SystemProperty(value="Partition map exchange merge delay in milliseconds", type=Long.class, defaults="0")
    public static final String IGNITE_EXCHANGE_MERGE_DELAY = "IGNITE_EXCHANGE_MERGE_DELAY";
    @SystemProperty(value="Name of command line program", type=String.class, defaults="ignite.{sh|bat}")
    public static final String IGNITE_PROG_NAME = "IGNITE_PROG_NAME";
    @SystemProperty(value="Success file name. This file is used with auto-restarting functionality when Ignite is started by supplied ignite.{bat|sh} scripts", type=String.class)
    @Deprecated
    public static final String IGNITE_SUCCESS_FILE = "IGNITE_SUCCESS_FILE";
    @SystemProperty(value="Sets a system-wide local IP address or hostname to be used by Ignite networking components. Once provided, the property overrides all the default local binding settings for Ignite nodes. Note, that the address can also be changed via IgniteConfiguration.setLocalHost(String) method. However, this system property has bigger priority and overrides the settings set via IgniteConfiguration", type=String.class)
    public static final String IGNITE_LOCAL_HOST = "IGNITE_LOCAL_HOST";
    @SystemProperty(value="Sets deployment mode configuration parameter. Valid values for property are: PRIVATE, ISOLATED, SHARED or CONTINUOUS", type=DeploymentMode.class)
    public static final String IGNITE_DEP_MODE_OVERRIDE = "IGNITE_DEPLOYMENT_MODE_OVERRIDE";
    @SystemProperty(value="Size of buffer holding completed transaction versions. Buffer is used to detect duplicate transaction. In most cases this value is large enough and does not need to be changed", type=Integer.class, defaults="262144")
    public static final String IGNITE_MAX_COMPLETED_TX_COUNT = "IGNITE_MAX_COMPLETED_TX_COUNT";
    @SystemProperty(value="Transactions that take more time, than value of this property (in milliseconds), will be output to warnings. 0 disables warnings on slow transactions", type=Integer.class, defaults="0")
    public static final String IGNITE_SLOW_TX_WARN_TIMEOUT = "IGNITE_SLOW_TX_WARN_TIMEOUT";
    @Deprecated
    @SystemProperty(value="Timeout after which all uncompleted transactions originated by left node will be\n     * salvaged (i.e. invalidated and committed)")
    public static final String IGNITE_TX_SALVAGE_TIMEOUT = "IGNITE_TX_SALVAGE_TIMEOUT";
    @SystemProperty(value="Maximum number of iterations for deadlock detection procedure. If value of this property is less then or equal to zero then deadlock detection will be disabled", type=Integer.class, defaults="1000")
    public static final String IGNITE_TX_DEADLOCK_DETECTION_MAX_ITERS = "IGNITE_TX_DEADLOCK_DETECTION_MAX_ITERS";
    @SystemProperty(value="Timeout for deadlock detection procedure", type=Integer.class, defaults="60000")
    public static final String IGNITE_TX_DEADLOCK_DETECTION_TIMEOUT = "IGNITE_TX_DEADLOCK_DETECTION_TIMEOUT";
    @SystemProperty(value="Enables pending transaction tracker. Affects impact of IGNITE_DISABLE_WAL_DURING_REBALANCING property:  if this property is set, WAL anyway won't be disabled during rebalancing triggered by baseline topology change", defaults="false")
    public static final String IGNITE_PENDING_TX_TRACKER_ENABLED = "IGNITE_PENDING_TX_TRACKER_ENABLED";
    @SystemProperty(value="Overrides multicast group taken from configuration. Used for testing purposes", type=String.class)
    public static final String IGNITE_OVERRIDE_MCAST_GRP = "IGNITE_OVERRIDE_MCAST_GRP";
    @SystemProperty(value="Overrides default reflection cache size", type=Integer.class, defaults="128")
    public static final String IGNITE_REFLECTION_CACHE_SIZE = "IGNITE_REFLECTION_CACHE_SIZE";
    @SystemProperty(value="Job processor maps sizes for finished jobs and cancellation requests. ", type=Integer.class, defaults="10240")
    public static final String IGNITE_JOBS_HISTORY_SIZE = "IGNITE_JOBS_HISTORY_SIZE";
    @Deprecated
    @SystemProperty(value="Job metrics processor property defining concurrency level for structure holding job metrics snapshots", type=Integer.class, defaults="64")
    public static final String IGNITE_JOBS_METRICS_CONCURRENCY_LEVEL = "IGNITE_JOBS_METRICS_CONCURRENCY_LEVEL";
    @SystemProperty(value="Configuration URL", type=String.class)
    public static final String IGNITE_CONFIG_URL = "IGNITE_CONFIG_URL";
    @SystemProperty(value="SSH host name for visor-started nodes", type=String.class)
    public static final String IGNITE_SSH_HOST = "IGNITE_SSH_HOST";
    @SystemProperty(value="Enables experimental commands in control.sh script")
    public static final String IGNITE_ENABLE_EXPERIMENTAL_COMMAND = "IGNITE_ENABLE_EXPERIMENTAL_COMMAND";
    @SystemProperty(value="SSH user name for visor-started nodes", type=String.class)
    public static final String IGNITE_SSH_USER_NAME = "IGNITE_SSH_USER_NAME";
    @SystemProperty(value="Preload resend timeout for evicted partitions in milliseconds", type=Long.class, defaults="1500")
    public static final String IGNITE_PRELOAD_RESEND_TIMEOUT = "IGNITE_PRELOAD_RESEND_TIMEOUT";
    @SystemProperty(value="How often in milliseconds marshal buffers should be rechecked and potentially trimmed", type=Long.class, defaults="10000")
    public static final String IGNITE_MARSHAL_BUFFERS_RECHECK = "IGNITE_MARSHAL_BUFFERS_RECHECK";
    @SystemProperty(value="Per thread binary allocator chunk pool size", type=Integer.class, defaults="32")
    public static final String IGNITE_MARSHAL_BUFFERS_PER_THREAD_POOL_SIZE = "IGNITE_MARSHAL_BUFFERS_PER_THREAD_POOL_SIZE";
    @SystemProperty(value="Disables HostnameVerifier for SSL connections. Can be used for development with self-signed certificates", defaults="false")
    public static final String IGNITE_DISABLE_HOSTNAME_VERIFIER = "IGNITE_DISABLE_HOSTNAME_VERIFIER";
    @Deprecated
    @SystemProperty(value="Disables buffered communication if node sends less messages count than specified by this property", type=Integer.class, defaults="512")
    public static final String IGNITE_MIN_BUFFERED_COMMUNICATION_MSG_CNT = "IGNITE_MIN_BUFFERED_COMMUNICATION_MSG_CNT";
    @SystemProperty(value="Force Ignite to fill memory block with some recognisable pattern right before this memory block is released. This will help to recognize cases when already released memory is accessed")
    public static final String IGNITE_OFFHEAP_SAFE_RELEASE = "IGNITE_OFFHEAP_SAFE_RELEASE";
    @Deprecated
    @SystemProperty(value="Maximum size for atomic cache queue delete history", type=Integer.class, defaults="200000 per partition")
    public static final String IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE = "IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE";
    @Deprecated
    @SystemProperty(value="Ttl of removed cache entries in milliseconds", type=Long.class)
    public static final String IGNITE_CACHE_REMOVED_ENTRIES_TTL = "IGNITE_CACHE_REMOVED_ENTRIES_TTL";
    @SystemProperty(value="Comma separated list of addresses in format \"10.100.22.100:45000,10.100.22.101:45000\". Used only for org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder", type=String.class)
    public static final String IGNITE_TCP_DISCOVERY_ADDRESSES = "IGNITE_TCP_DISCOVERY_ADDRESSES";
    @SystemProperty(value="Disables performance suggestions output on start", defaults="false")
    public static final String IGNITE_PERFORMANCE_SUGGESTIONS_DISABLED = "IGNITE_PERFORMANCE_SUGGESTIONS_DISABLED";
    @SystemProperty(value="Allows atomic operations inside transactions", defaults="false")
    public static final String IGNITE_ALLOW_ATOMIC_OPS_IN_TX = "IGNITE_ALLOW_ATOMIC_OPS_IN_TX";
    @SystemProperty(value="Atomic cache deferred update response buffer size", type=Integer.class, defaults="256")
    public static final String IGNITE_ATOMIC_DEFERRED_ACK_BUFFER_SIZE = "IGNITE_ATOMIC_DEFERRED_ACK_BUFFER_SIZE";
    @SystemProperty(value="Atomic cache deferred update response buffer size", type=Integer.class, defaults="256")
    public static final String IGNITE_ATOMIC_DEFERRED_ACK_TIMEOUT = "IGNITE_ATOMIC_DEFERRED_ACK_TIMEOUT";
    @SystemProperty(value="Atomic cache deferred update timeout", type=Integer.class, defaults="500")
    public static final String IGNITE_ATOMIC_CACHE_QUEUE_RETRY_TIMEOUT = "IGNITE_ATOMIC_CACHE_QUEUE_RETRY_TIMEOUT";
    @SystemProperty(value="One phase commit deferred ack request timeout", type=Integer.class, defaults="500")
    public static final String IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_TIMEOUT = "IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_TIMEOUT";
    @SystemProperty(value="One phase commit deferred ack request buffer size", type=Integer.class, defaults="256")
    public static final String IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_BUFFER_SIZE = "IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_BUFFER_SIZE";
    @Deprecated
    @SystemProperty(value="Enables debug console for H2 indexing SPI", type=String.class)
    public static final String IGNITE_H2_DEBUG_CONSOLE = "IGNITE_H2_DEBUG_CONSOLE";
    @Deprecated
    @SystemProperty(value="User defined port which H2 indexing SPI will use to start H2 debug console on. If this property is not set or set to 0, H2 debug console will use system-provided dynamic port. This property is only relevant when IGNITE_H2_DEBUG_CONSOLE property is set", type=Integer.class)
    public static final String IGNITE_H2_DEBUG_CONSOLE_PORT = "IGNITE_H2_DEBUG_CONSOLE_PORT";
    @SystemProperty(value="Enables native debug of the shared memory space", defaults="false")
    public static final String IGNITE_IPC_SHMEM_SPACE_DEBUG = "IGNITE_IPC_SHMEM_SPACE_DEBUG";
    @SystemProperty(value="Skip configuration consistency checks", defaults="false")
    public static final String IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK = "IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK";
    @Deprecated
    @SystemProperty(value="Disables validation of keys put to cache")
    public static final String IGNITE_CACHE_KEY_VALIDATION_DISABLED = "IGNITE_CACHE_KEY_VALIDATION_DISABLED";
    @SystemProperty(value="Logging directory. Overrides configuration value", type=String.class)
    public static final String IGNITE_LOG_DIR = "IGNITE_LOG_DIR";
    @SystemProperty(value="Work directory. The property IgniteConfiguration.setWorkDirectory has higher priority", type=String.class)
    public static final String IGNITE_WORK_DIR = "IGNITE_WORK_DIR";
    @SystemProperty(value="Enables Ignite to append hash code of Ignite class as hex string and append JVM name returned by RuntimeMXBean.getName(). This may be helpful when running Ignite in some application server clusters or similar environments to avoid MBean name collisions")
    public static final String IGNITE_MBEAN_APPEND_JVM_ID = "IGNITE_MBEAN_APPEND_JVM_ID";
    @SystemProperty(value="Enables Ignite to append hash code of class loader to MXBean name", defaults="true")
    public static final String IGNITE_MBEAN_APPEND_CLASS_LOADER_ID = "IGNITE_MBEAN_APPEND_CLASS_LOADER_ID";
    @SystemProperty(value="Disable MBeans registration. This may be helpful if MBeans are not allowed e.g. for security reasons", defaults="false")
    public static final String IGNITE_MBEANS_DISABLED = "IGNITE_MBEANS_DISABLED";
    @SystemProperty(value="Enables test features", defaults="false")
    public static final String IGNITE_TEST_FEATURES_ENABLED = "IGNITE_TEST_FEATURES_ENABLED";
    @SystemProperty(value="Size of buffer holding last exception", type=Integer.class, defaults="1000")
    public static final String IGNITE_EXCEPTION_REGISTRY_MAX_SIZE = "IGNITE_EXCEPTION_REGISTRY_MAX_SIZE";
    @SystemProperty(value="Starts node in client mode. Have lower priority than configuration value", defaults="false")
    public static final String IGNITE_CACHE_CLIENT = "IGNITE_CACHE_CLIENT";
    @SystemProperty(value="Enables CacheManager to start grid with isolated IP finder when default URL is passed in. This is needed to pass TCK tests which use default URL and assume isolated cache managers for different class loaders", defaults="true")
    public static final String IGNITE_JCACHE_DEFAULT_ISOLATED = "IGNITE_CACHE_CLIENT";
    @SystemProperty(value="Maximum number of SQL result rows which can be fetched into a merge table. If there are less rows than this threshold then multiple passes throw a table will be possible, otherwise only one pass (e.g. only result streaming is possible)", type=Integer.class, defaults="10000")
    public static final String IGNITE_SQL_MERGE_TABLE_MAX_SIZE = "IGNITE_SQL_MERGE_TABLE_MAX_SIZE";
    @SystemProperty(value="Number of SQL result rows that will be fetched into a merge table at once before applying binary search for the bounds", type=Integer.class, defaults="1024")
    public static final String IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE = "IGNITE_SQL_MERGE_TABLE_PREFETCH_SIZE";
    @SystemProperty(value="Disables fallback to H2 SQL parser if the internal SQL parser fails to parse the statement", defaults="false")
    public static final String IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK = "IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK";
    @SystemProperty(value="Disables SQL system views")
    public static final String IGNITE_SQL_DISABLE_SYSTEM_VIEWS = "IGNITE_SQL_DISABLE_SYSTEM_VIEWS";
    @SystemProperty(value="SQL retry timeout in milliseconds", type=Long.class, defaults="30 seconds")
    public static final String IGNITE_SQL_RETRY_TIMEOUT = "IGNITE_SQL_RETRY_TIMEOUT";
    @SystemProperty(value="Enables backward compatible handling of UUID through DDL")
    public static final String IGNITE_SQL_UUID_DDL_BYTE_FORMAT = "IGNITE_SQL_UUID_DDL_BYTE_FORMAT";
    @Deprecated
    @SystemProperty(value="Enable memory quotas per JDBC connection")
    public static final String IGNITE_SQL_ENABLE_CONNECTION_MEMORY_QUOTA = "IGNITE_SQL_ENABLE_CONNECTION_MEMORY_QUOTA";
    @SystemProperty(value="Enables subquery rewriting optimization. If enabled, subquery will be rewritten to JOIN where possible", defaults="true")
    @IgniteExperimental
    public static final String IGNITE_ENABLE_SUBQUERY_REWRITE_OPTIMIZATION = "IGNITE_ENABLE_SUBQUERY_REWRITE_OPTIMIZATION";
    @SystemProperty(value="Maximum size for affinity assignment history", type=Integer.class, defaults="25")
    public static final String IGNITE_AFFINITY_HISTORY_SIZE = "IGNITE_AFFINITY_HISTORY_SIZE";
    @SystemProperty(value="Minimum size for affinity assignment history", type=Integer.class, defaults="2")
    public static final String IGNITE_MIN_AFFINITY_HISTORY_SIZE = "IGNITE_MIN_AFFINITY_HISTORY_SIZE";
    @SystemProperty(value="Maximum size for discovery messages history", type=Integer.class, defaults="500")
    public static final String IGNITE_DISCOVERY_HISTORY_SIZE = "IGNITE_DISCOVERY_HISTORY_SIZE";
    @SystemProperty(value="Maximum number of discovery message history used to support client reconnect", type=Integer.class, defaults="512")
    public static final String IGNITE_DISCOVERY_CLIENT_RECONNECT_HISTORY_SIZE = "IGNITE_DISCOVERY_CLIENT_RECONNECT_HISTORY_SIZE";
    @SystemProperty(value="Enables logging a warning message when metrics quantity exceeded a specified number", type=Integer.class, defaults="500")
    public static final String IGNITE_DISCOVERY_METRICS_QNT_WARN = "IGNITE_DISCOVERY_METRICS_QNT_WARN";
    @SystemProperty(value="Time interval in milliseconds that indicates client reconnect throttle must be reset to zero", type=Long.class, defaults="120000")
    public static final String CLIENT_THROTTLE_RECONNECT_RESET_TIMEOUT_INTERVAL = "CLIENT_THROTTLE_RECONNECT_RESET_TIMEOUT_INTERVAL";
    @SystemProperty(value="Number of cache operation retries in case of topology exceptions", type=Integer.class, defaults="100")
    public static final String IGNITE_CACHE_RETRIES_COUNT = "IGNITE_CACHE_RETRIES_COUNT";
    @SystemProperty(value="Enables logging thread dump in case of partition exchange timeout")
    public static final String IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT = "IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT";
    @SystemProperty(value="Enables logging thread dump in case of partition exchange timeout", defaults="false")
    public static final String IGNITE_IO_DUMP_ON_TIMEOUT = "IGNITE_IO_DUMP_ON_TIMEOUT";
    @SystemProperty(value="Enables diagnostic flag", defaults="true")
    public static final String IGNITE_DIAGNOSTIC_ENABLED = "IGNITE_DIAGNOSTIC_ENABLED";
    @SystemProperty(value="Cache operations that take more time than value of this property will be output to log. Set to 0 to disable", type=Long.class, defaults="60000")
    public static final String IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT = "IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT";
    @SystemProperty(value="Upper time limit between long running/hanging operations debug dumps in milliseconds", type=Long.class)
    public static final String IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT = "IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT";
    @SystemProperty(value="JDBC driver cursor remove delay in milliseconds", type=Long.class, defaults="10 minutes")
    public static final String IGNITE_JDBC_DRIVER_CURSOR_REMOVE_DELAY = "IGNITE_JDBC_DRIVER_CURSOR_RMV_DELAY";
    @SystemProperty(value="Long-long offheap map load factor", type=Float.class, defaults="2.5")
    public static final String IGNITE_LONG_LONG_HASH_MAP_LOAD_FACTOR = "IGNITE_LONG_LONG_HASH_MAP_LOAD_FACTOR";
    @SystemProperty(value="Maximum number of nested listener calls before listener notification becomes asynchronous", type=Integer.class, defaults="5")
    public static final String IGNITE_MAX_NESTED_LISTENER_CALLS = "IGNITE_MAX_NESTED_LISTENER_CALLS";
    @SystemProperty(value="Enables local store keeps primary only. Backward compatibility flag")
    public static final String IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY = "IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY";
    @SystemProperty(value="Manages OptimizedMarshaller behavior of serialVersionUID computation for Serializable classes")
    public static final String IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID = "IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID";
    @SystemProperty(value="Manages type of serialization mechanism for String that is marshalled/unmarshalled by BinaryMarshaller. Should be used for cases when a String contains a surrogate symbol without its pair one. This is frequently used in algorithms that encrypts data in String format")
    public static final String IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 = "IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2";
    @SystemProperty(value="Path to the file that contains list of classes allowed to safe deserialization", type=String.class)
    public static final String IGNITE_MARSHALLER_WHITELIST = "IGNITE_MARSHALLER_WHITELIST";
    @SystemProperty(value="Path to the file that contains list of classes disallowed to safe deserialization", type=String.class)
    public static final String IGNITE_MARSHALLER_BLACKLIST = "IGNITE_MARSHALLER_BLACKLIST";
    @SystemProperty(value="Enables default selected keys set to be used inside GridNioServer which lead to some extra garbage generation when processing selected keys. Should be switched to true if there are any problems in communication layer")
    public static final String IGNITE_NO_SELECTOR_OPTS = "IGNITE_NO_SELECTOR_OPTS";
    @SystemProperty(value="Period in milliseconds between calls of the SQL statements cache cleanup task. Cleanup tasks clears cache for terminated threads and for threads which did not perform SQL queries within timeout configured via IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT property", type=Long.class, defaults="10 seconds")
    public static final String IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD = "IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD";
    @SystemProperty(value="Timeout in milliseconds after which thread's SQL statements cache is cleared by cleanup task if the thread does not perform any query", type=Long.class, defaults="10 minutes")
    public static final String IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT = "IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT";
    @SystemProperty(value="Enables backward compatibility of StreamTransformer.from(CacheEntryProcessor) method. If the property is true, then the wrapped CacheEntryProcessor won't be able to be loaded over P2P class loading. If the property is false, then another implementation of StreamTransformer will be returned, that fixes P2P class loading for CacheEntryProcessor, but it will be incompatible with old versions of Ignite")
    public static final String IGNITE_STREAM_TRANSFORMER_COMPATIBILITY_MODE = "IGNITE_STREAM_TRANSFORMER_COMPATIBILITY_MODE";
    @Deprecated
    @SystemProperty(value="If enabled then tree-based data structures - TreeMap and TreeSet - will not be wrapped into special holders introduced to overcome serialization issue caused by missing Comparable interface on BinaryObject")
    public static final String IGNITE_BINARY_DONT_WRAP_TREE_STRUCTURES = "IGNITE_BINARY_DONT_WRAP_TREE_STRUCTURES";
    @SystemProperty(value="Enables consistent ID to calculate by host name, without port, and you can use only one node for host in cluster")
    public static final String IGNITE_CONSISTENT_ID_BY_HOST_WITHOUT_PORT = "IGNITE_CONSISTENT_ID_BY_HOST_WITHOUT_PORT";
    @SystemProperty(value="Consistent ID of Ignite node. Value of the system property will overwrite matched property IgniteConfiguration.setConsistentId(Serializable) in configuration", type=String.class)
    public static final String IGNITE_OVERRIDE_CONSISTENT_ID = "IGNITE_OVERRIDE_CONSISTENT_ID";
    @SystemProperty(value="Ignores local address's hostname if IGNITE_LOCAL_HOST is defined when resolving local node's addresses", defaults="true")
    public static final String IGNITE_IGNORE_LOCAL_HOST_NAME = "IGNITE_IGNORE_LOCAL_HOST_NAME";
    @SystemProperty(value="IO balance period in milliseconds", type=Long.class, defaults="5000")
    public static final String IGNITE_IO_BALANCE_PERIOD = "IGNITE_IO_BALANCE_PERIOD";
    @SystemProperty(value="Enables fields to be written by BinaryMarshaller in sorted order. By default, the natural order is used")
    public static final String IGNITE_BINARY_SORT_OBJECT_FIELDS = "IGNITE_BINARY_SORT_OBJECT_FIELDS";
    @SystemProperty(value="Whether Ignite can access unaligned memory addresses. Defaults to false, meaning that unaligned access will be performed only on x86 architecture")
    public static final String IGNITE_MEMORY_UNALIGNED_ACCESS = "IGNITE_MEMORY_UNALIGNED_ACCESS";
    @SystemProperty(value="When unsafe memory copy if performed below this threshold, Ignite will do it on per-byte basis instead of calling to Unsafe.copyMemory(). 0 disables threshold", type=Long.class, defaults="0")
    public static final String IGNITE_MEMORY_PER_BYTE_COPY_THRESHOLD = "IGNITE_MEMORY_PER_BYTE_COPY_THRESHOLD";
    @Deprecated
    @SystemProperty(value="If enabled BinaryObject will be unwrapped before passing to IndexingSpi to preserve old behavior query processor with IndexingSpi")
    public static final String IGNITE_UNWRAP_BINARY_FOR_INDEXING_SPI = "IGNITE_UNWRAP_BINARY_FOR_INDEXING_SPI";
    @SystemProperty(value="Maximum payload size in bytes for H2TreeIndex. 0 means that inline index store is disabled", type=Integer.class, defaults="10")
    public static final String IGNITE_MAX_INDEX_PAYLOAD_SIZE = "IGNITE_MAX_INDEX_PAYLOAD_SIZE";
    @Deprecated
    @SystemProperty(value="Time interval for calculating rebalance rate statistics, in milliseconds", type=Integer.class, defaults="60000")
    public static final String IGNITE_REBALANCE_STATISTICS_TIME_INTERVAL = "IGNITE_REBALANCE_STATISTICS_TIME_INTERVAL";
    @SystemProperty(value="When cache has entries with expired TTL, each user operation will also remove this amount of expired entries", type=Integer.class, defaults="5")
    public static final String IGNITE_TTL_EXPIRE_BATCH_SIZE = "IGNITE_TTL_EXPIRE_BATCH_SIZE";
    @SystemProperty(value="Indexing discovery history size. Protects from duplicate messages maintaining the list of IDs of recently arrived discovery messages", type=Integer.class, defaults="1000")
    public static final String IGNITE_INDEXING_DISCOVERY_HISTORY_SIZE = "IGNITE_INDEXING_DISCOVERY_HISTORY_SIZE";
    @SystemProperty(value="Cache start size for on-heap maps", type=Integer.class, defaults="4096")
    public static final String IGNITE_CACHE_START_SIZE = "IGNITE_CACHE_START_SIZE";
    @SystemProperty(value="Enables local start all existing caches on client node start")
    public static final String IGNITE_START_CACHES_ON_JOIN = "IGNITE_START_CACHES_ON_JOIN";
    @SystemProperty(value="Skip CRC calculation flag")
    public static final String IGNITE_PDS_SKIP_CRC = "IGNITE_PDS_SKIP_CRC";
    @Deprecated
    @SystemProperty(value="PDS partition destroy checkpoint delay", type=Integer.class)
    public static final String IGNITE_PDS_PARTITION_DESTROY_CHECKPOINT_DELAY = "IGNITE_PDS_PARTITION_DESTROY_CHECKPOINT_DELAY";
    @Deprecated
    @SystemProperty(value="WAL rebalance threshold", type=Integer.class, defaults="500")
    public static final String IGNITE_PDS_WAL_REBALANCE_THRESHOLD = "IGNITE_PDS_WAL_REBALANCE_THRESHOLD";
    @SystemProperty(value="Prefer historical rebalance if there's enough history regardless off all heuristics. This property is intended for integration or performance tests")
    public static final String IGNITE_PREFER_WAL_REBALANCE = "IGNITE_PREFER_WAL_REBALANCE";
    @SystemProperty(value="Threshold of the checkpoint quantity since the last earliest checkpoint map snapshot. After this thresold is reached, a snapshot of the earliest checkpoint map will be captured", type=Integer.class, defaults="5")
    public static final String IGNITE_CHECKPOINT_MAP_SNAPSHOT_THRESHOLD = "IGNITE_CHECKPOINT_MAP_SNAPSHOT_THRESHOLD";
    @SystemProperty(value="Ignite page memory concurrency level", type=Integer.class)
    public static final String IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL = "IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL";
    @SystemProperty(value="Enables Ignite to switch to compatibility mode with versions that don't support service security permissions. In this case security permissions will be ignored (if they set). Default is false, which means that service security permissions will be respected")
    public static final String IGNITE_SECURITY_COMPATIBILITY_MODE = "IGNITE_SECURITY_COMPATIBILITY_MODE";
    @SystemProperty(value="Ignite cluster name. Defaults to utility cache deployment ID", type=String.class)
    public static final String IGNITE_CLUSTER_NAME = "IGNITE_CLUSTER_NAME";
    @SystemProperty(value="When client cache is started or closed special discovery message is sent to notify cluster (for example this is needed for ClusterGroup.forCacheNodes(String) API. This timeout in milliseconds specifies how long to wait after client cache start/close before sending this message. If during this timeout another client cache changed, these events are combined into single message", type=Long.class, defaults="10000")
    public static final String IGNITE_CLIENT_CACHE_CHANGE_MESSAGE_TIMEOUT = "IGNITE_CLIENT_CACHE_CHANGE_MESSAGE_TIMEOUT";
    @SystemProperty(value="If a partition release future completion time during an exchange exceeds this threshold (in milliseconds), the contents of the future will be dumped to the log on exchange. 0 means disabled", type=Integer.class, defaults="0")
    public static final String IGNITE_PARTITION_RELEASE_FUTURE_DUMP_THRESHOLD = "IGNITE_PARTITION_RELEASE_FUTURE_DUMP_THRESHOLD";
    @SystemProperty(value="This property specifies the maximum number of futures that are included into diagnostic message", type=Integer.class, defaults="10")
    public static final String IGNITE_PARTITION_RELEASE_FUTURE_WARN_LIMIT = "IGNITE_PARTITION_RELEASE_FUTURE_WARN_LIMIT";
    @SystemProperty(value="Enables node to forcible fail a remote node when it fails to establish a communication connection")
    public static final String IGNITE_ENABLE_FORCIBLE_NODE_KILL = "IGNITE_ENABLE_FORCIBLE_NODE_KILL";
    @SystemProperty(value="If the property is set, coincidence of client identifier and subject is required when security is enabled", defaults="false")
    public static final String IGNITE_CHECK_SENDER_NODE_SUBJECT = "IGNITE_CHECK_SENDER_NODE_SUBJECT";
    @SystemProperty(value="If the property is set, client nodes should have explicitly rights to access to system cache", defaults="false")
    public static final String IGNITE_SECURITY_FOR_SYS_CACHE_ENABLED = "IGNITE_SECURITY_FOR_SYS_CACHE_ENABLED";
    @SystemProperty(value="Tasks stealing will be started if tasks queue size per data-streamer thread exceeds this threshold", type=Integer.class, defaults="4")
    public static final String IGNITE_DATA_STREAMING_EXECUTOR_SERVICE_TASKS_STEALING_THRESHOLD = "IGNITE_DATA_STREAMING_EXECUTOR_SERVICE_TASKS_STEALING_THRESHOLD";
    @SystemProperty(value="If this property is set, then Ignite will use Async File IO factory by default", defaults="true")
    public static final String IGNITE_USE_ASYNC_FILE_IO_FACTORY = "IGNITE_USE_ASYNC_FILE_IO_FACTORY";
    @SystemProperty(value="Max amount of remembered errors for GridLogThrottle", type=Integer.class, defaults="128")
    public static final String IGNITE_LOG_THROTTLE_CAPACITY = "IGNITE_LOG_THROTTLE_CAPACITY";
    @SystemProperty(value="Checkpoint throttling policy", type=String.class)
    public static final String IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED = "IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED";
    @SystemProperty(value="WAL serializer version", type=Integer.class, defaults="2")
    public static final String IGNITE_WAL_SERIALIZER_VERSION = "IGNITE_WAL_SERIALIZER_VERSION";
    @SystemProperty(value="WAL segment sync timeout in milliseconds", type=Long.class, defaults="500")
    public static final String IGNITE_WAL_SEGMENT_SYNC_TIMEOUT = "IGNITE_WAL_SEGMENT_SYNC_TIMEOUT";
    @SystemProperty(value="Enables usage of legacy node comparator (based on node order)")
    public static final String IGNITE_USE_LEGACY_NODE_COMPARATOR = "IGNITE_USE_LEGACY_NODE_COMPARATOR";
    @SystemProperty(value="Enables usage of the mapped byte buffer", defaults="true")
    public static final String IGNITE_WAL_MMAP = "IGNITE_WAL_MMAP";
    @SystemProperty(value="When set to true, Data store folders are generated only by consistent id, and no consistent ID will be set based on existing data store folders. This option also enables compatible folder generation mode as it was before 2.3")
    public static final String IGNITE_DATA_STORAGE_FOLDER_BY_CONSISTENT_ID = "IGNITE_DATA_STORAGE_FOLDER_BY_CONSISTENT_ID";
    @SystemProperty(value="Disables JVM pause detector")
    public static final String IGNITE_JVM_PAUSE_DETECTOR_DISABLED = "IGNITE_JVM_PAUSE_DETECTOR_DISABLED";
    @SystemProperty(value="JVM pause detector precision", type=Integer.class, defaults="50")
    public static final String IGNITE_JVM_PAUSE_DETECTOR_PRECISION = "IGNITE_JVM_PAUSE_DETECTOR_PRECISION";
    @SystemProperty(value="JVM pause detector threshold", type=Integer.class, defaults="500")
    public static final String IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD = "IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD";
    @SystemProperty(value="JVM pause detector last events count", type=Integer.class, defaults="20")
    public static final String IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT = "IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT";
    @SystemProperty(value="Enables WAL debug log on recovery")
    public static final String IGNITE_WAL_DEBUG_LOG_ON_RECOVERY = "IGNITE_WAL_DEBUG_LOG_ON_RECOVERY";
    @SystemProperty(value="Number of checkpoint history entries held in memory", type=Integer.class, defaults="100")
    public static final String IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE = "IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE";
    @SystemProperty(value="Enables logging in GridClient")
    public static final String IGNITE_GRID_CLIENT_LOG_ENABLED = "IGNITE_GRID_CLIENT_LOG_ENABLED";
    @SystemProperty(value="Enables direct IO. Direct IO enabled only if JAR file with corresponding feature is available in classpath and OS and filesystem settings allows to enable this mode", defaults="true")
    public static final String IGNITE_DIRECT_IO_ENABLED = "IGNITE_DIRECT_IO_ENABLED";
    @SystemProperty(value="Enables development environments warnings")
    public static final String IGNITE_DEV_ONLY_LOGGING_DISABLED = "IGNITE_DEV_ONLY_LOGGING_DISABLED";
    @SystemProperty(value="When set to true (default), pages are written to page store without holding segment lock (with delay). Because other thread may require exactly the same page to be loaded from store, reads are protected by locking", defaults="true")
    public static final String IGNITE_DELAYED_REPLACED_PAGE_WRITE = "IGNITE_DELAYED_REPLACED_PAGE_WRITE";
    @SystemProperty(value="When set to true, WAL implementation with dedicated worker will be used even in FSYNC mode")
    public static final String IGNITE_WAL_FSYNC_WITH_DEDICATED_WORKER = "IGNITE_WAL_FSYNC_WITH_DEDICATED_WORKER";
    @SystemProperty(value="When set to true, on-heap cache cannot be enabled - see CacheConfiguration.setOnheapCacheEnabled(boolean)")
    public static final String IGNITE_DISABLE_ONHEAP_CACHE = "IGNITE_DISABLE_ONHEAP_CACHE";
    @SystemProperty(value="When set to false, loaded pages implementation is switched to previous version of implementation, FullPageIdTable. True value enables 'Robin Hood hashing: backward shift deletion'", defaults="true")
    public static final String IGNITE_LOADED_PAGES_BACKWARD_SHIFT_MAP = "IGNITE_LOADED_PAGES_BACKWARD_SHIFT_MAP";
    @SystemProperty(value="Percentage of archive size for checkpoint trigger", type=Double.class, defaults="0.75")
    public static final String IGNITE_CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE = "IGNITE_CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE";
    @SystemProperty(value="Percentage of WAL archive size to calculate threshold since which removing of old archive should be started", type=Double.class, defaults="0.5")
    public static final String IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE = "IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE";
    @SystemProperty(value="Threshold time (in millis) to print warning to log if waiting for next wal segment took longer than the threshold", type=Long.class, defaults="1000 milliseconds")
    public static final String IGNITE_THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT = "IGNITE_THRESHOLD_WAIT_TIME_NEXT_WAL_SEGMENT";
    @SystemProperty(value="Count of WAL compressor worker threads", type=Integer.class, defaults="4")
    public static final String IGNITE_WAL_COMPRESSOR_WORKER_THREAD_CNT = "IGNITE_WAL_COMPRESSOR_WORKER_THREAD_CNT";
    @SystemProperty(value="Enables read load balancing, that means 'get' requests will be distributed between primary and backup nodes if it is possible and CacheConfiguration.isReadFromBackup() is true. ", defaults="true")
    public static final String IGNITE_READ_LOAD_BALANCING = "IGNITE_READ_LOAD_BALANCING";
    @SystemProperty(value="Number of repetitions to capture a lock in the B+Tree", type=Integer.class, defaults="1000")
    public static final String IGNITE_BPLUS_TREE_LOCK_RETRIES = "IGNITE_BPLUS_TREE_LOCK_RETRIES";
    @SystemProperty(value="Amount of memory reserved in the heap at node start, which can be dropped to increase the chances of success when handling OutOfMemoryError", type=Integer.class, defaults="65536")
    public static final String IGNITE_FAILURE_HANDLER_RESERVE_BUFFER_SIZE = "IGNITE_FAILURE_HANDLER_RESERVE_BUFFER_SIZE";
    @SystemProperty(value="The threshold of uneven distribution above which partition distribution will be logged", type=Float.class, defaults="50.0")
    public static final String IGNITE_PART_DISTRIBUTION_WARN_THRESHOLD = "IGNITE_PART_DISTRIBUTION_WARN_THRESHOLD";
    @SystemProperty(value="When set to false, WAL will not be automatically disabled during rebalancing if there is no partition in OWNING state", defaults="true")
    public static final String IGNITE_DISABLE_WAL_DURING_REBALANCING = "IGNITE_DISABLE_WAL_DURING_REBALANCING";
    @SystemProperty(value="When property is set false each next exchange will try to compare with previous. If last rebalance is equivalent with new possible one, new rebalance does not trigger. Set the property true and each exchange will try to trigger new rebalance")
    public static final String IGNITE_DISABLE_REBALANCING_CANCELLATION_OPTIMIZATION = "IGNITE_DISABLE_REBALANCING_CANCELLATION_OPTIMIZATION";
    @SystemProperty(value="Timeout for TCP client recovery descriptor reservation in milliseconds", type=Long.class, defaults="5000")
    public static final String IGNITE_NIO_RECOVERY_DESCRIPTOR_RESERVATION_TIMEOUT = "IGNITE_NIO_RECOVERY_DESCRIPTOR_RESERVATION_TIMEOUT";
    @SystemProperty(value="Enables Ignite to skip partitions sizes check on partition validation after rebalance has finished. Partitions sizes may differs on nodes when Expiry Policy is in use and it is ok due to lazy entry eviction mechanics. There is no need to disable partition size validation either in normal case or when expiry policy is configured for cache. But it should be disabled manually when policy is used on per entry basis to hint Ignite to skip this check")
    public static final String IGNITE_SKIP_PARTITION_SIZE_VALIDATION = "IGNITE_SKIP_PARTITION_SIZE_VALIDATION";
    @SystemProperty(value="Enables threads dumping on critical node failure")
    public static final String IGNITE_DUMP_THREADS_ON_FAILURE = "IGNITE_DUMP_THREADS_ON_FAILURE";
    @SystemProperty(value="Throttling time out for thread dump generation during failure handling in milliseconds. Default is failure detection timeout. 0 or negative value - throttling is disabled", type=Long.class)
    public static final String IGNITE_DUMP_THREADS_ON_FAILURE_THROTTLING_TIMEOUT = "IGNITE_DUMP_THREADS_ON_FAILURE_THROTTLING_TIMEOUT";
    @Deprecated
    @SystemProperty(value="Throttling timeout in milliseconds which avoid excessive PendingTree access on unwind if there is nothing to clean yet", type=Long.class)
    public static final String IGNITE_UNWIND_THROTTLING_TIMEOUT = "IGNITE_UNWIND_THROTTLING_TIMEOUT";
    @SystemProperty(value="Threshold in seconds for throttling operations logging", type=Integer.class, defaults="10")
    public static final String IGNITE_THROTTLE_LOG_THRESHOLD = "IGNITE_THROTTLE_LOG_THRESHOLD";
    @Deprecated
    @SystemProperty(value="Number of concurrent operation for evict partitions", type=Integer.class)
    public static final String IGNITE_EVICTION_PERMITS = "IGNITE_EVICTION_PERMITS";
    @SystemProperty(value="When set to true, Ignite will allow execute DML operation (MERGE|INSERT|UPDATE|DELETE) within transaction for non MVCC mode")
    public static final String IGNITE_ALLOW_DML_INSIDE_TRANSACTION = "IGNITE_ALLOW_DML_INSIDE_TRANSACTION";
    @SystemProperty(value="Timeout between ZooKeeper client retries in milliseconds", type=Long.class, defaults="2 seconds")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_RETRY_TIMEOUT = "IGNITE_ZOOKEEPER_DISCOVERY_RETRY_TIMEOUT";
    @SystemProperty(value="Number of attempts to reconnect to ZooKeeper", type=Integer.class, defaults="10")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_MAX_RETRY_COUNT = "IGNITE_ZOOKEEPER_DISCOVERY_MAX_RETRY_COUNT";
    @SystemProperty(value="Maximum number for cached MVCC transaction updates. This caching is used for continuous query with MVCC caches", type=Integer.class, defaults="20000")
    public static final String IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD = "IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD";
    @SystemProperty(value="Try reuse memory on deactivation")
    public static final String IGNITE_REUSE_MEMORY_ON_DEACTIVATE = "IGNITE_REUSE_MEMORY_ON_DEACTIVATE";
    @SystemProperty(value="Maximum inactivity period for system worker in milliseconds. When this value is exceeded, worker is considered blocked with consequent critical failure handler invocation", type=Long.class)
    public static final String IGNITE_SYSTEM_WORKER_BLOCKED_TIMEOUT = "IGNITE_SYSTEM_WORKER_BLOCKED_TIMEOUT";
    @SystemProperty(value="Timeout for checkpoint read lock acquisition in milliseconds", type=Long.class)
    public static final String IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT = "IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT";
    @SystemProperty(value="Timeout for waiting schema update if schema was not found for last accepted version in milliseconds", type=Long.class, defaults="30000")
    public static final String IGNITE_WAIT_SCHEMA_UPDATE = "IGNITE_WAIT_SCHEMA_UPDATE";
    @Deprecated
    @SystemProperty(value="Overrides CacheConfiguration.getRebalanceThrottle configuration property for all caches in milliseconds. 0 by default, which means that override is disabled", type=Long.class, defaults="0")
    public static final String IGNITE_REBALANCE_THROTTLE_OVERRIDE = "IGNITE_REBALANCE_THROTTLE_OVERRIDE";
    @SystemProperty(value="Enables start caches in parallel", defaults="true")
    public static final String IGNITE_ALLOW_START_CACHES_IN_PARALLEL = "IGNITE_ALLOW_START_CACHES_IN_PARALLEL";
    @SystemProperty(value="For test purposes only. Force Mvcc mode")
    public static final String IGNITE_FORCE_MVCC_MODE_IN_TESTS = "IGNITE_FORCE_MVCC_MODE_IN_TESTS";
    @SystemProperty(value="Allows to log additional information about all restored partitions after binary and logical recovery phases")
    public static final String IGNITE_RECOVERY_VERBOSE_LOGGING = "IGNITE_RECOVERY_VERBOSE_LOGGING";
    @SystemProperty(value="Disables cache interceptor triggering in case of conflicts")
    public static final String IGNITE_DISABLE_TRIGGERING_CACHE_INTERCEPTOR_ON_CONFLICT = "IGNITE_DISABLE_TRIGGERING_CACHE_INTERCEPTOR_ON_CONFLICT";
    @SystemProperty(value="Disk page compression - CacheConfiguration#setDiskPageCompression", type=DiskPageCompression.class)
    public static final String IGNITE_DEFAULT_DISK_PAGE_COMPRESSION = "IGNITE_DEFAULT_DISK_PAGE_COMPRESSION";
    @SystemProperty(value="Storage page size - DataStorageConfiguration#setPageSize", type=Integer.class)
    public static final String IGNITE_DEFAULT_DATA_STORAGE_PAGE_SIZE = "IGNITE_DEFAULT_DATA_STORAGE_PAGE_SIZE";
    @SystemProperty(value="Manages the type of the implementation of the service processor (implementation of the IgniteServices). All nodes in the cluster must have the same value of this property. If the property is true then event-driven implementation of the service processor will be used. If the property is false then internal cache based implementation of service processor will be used", defaults="true")
    public static final String IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED = "IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED";
    @SystemProperty(value="When set to true, cache metrics are not included into the discovery metrics update message (in this case message contains only cluster metrics). By default cache metrics are included into the message and calculated each time the message is sent. Cache metrics sending can also be turned off by disabling statistics per each cache, but in this case some cache metrics will be unavailable via JMX too")
    public static final String IGNITE_DISCOVERY_DISABLE_CACHE_METRICS_UPDATE = "IGNITE_DISCOVERY_DISABLE_CACHE_METRICS_UPDATE";
    @SystemProperty(value="Maximum number of different partitions to be extracted from between expression within sql query. In case of limit exceeding all partitions will be used", type=Integer.class, defaults="16")
    public static final String IGNITE_SQL_MAX_EXTRACTED_PARTS_FROM_BETWEEN = "IGNITE_SQL_MAX_EXTRACTED_PARTS_FROM_BETWEEN";
    @SystemProperty(value="Maximum amount of bytes that can be stored in history of DistributedMetaStorage updates", type=Long.class, defaults="104857600")
    public static final String IGNITE_GLOBAL_METASTORAGE_HISTORY_MAX_BYTES = "IGNITE_GLOBAL_METASTORAGE_HISTORY_MAX_BYTES";
    @SystemProperty(value="Size threshold to allocate and retain additional HashMap to improve contains() which leads to extra memory consumption", type=Integer.class, defaults="5")
    public static final String IGNITE_AFFINITY_BACKUPS_THRESHOLD = "IGNITE_AFFINITY_BACKUPS_THRESHOLD";
    @SystemProperty(value="Disables memory optimization: BitSets instead of HashSets to store partitions. When number of backups per partitions is > IGNITE_AFFINITY_BACKUPS_THRESHOLD we use HashMap to improve contains() which leads to extra memory consumption, otherwise we use view on the list of cluster nodes to reduce memory consumption on redundant data structures")
    public static final String IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION = "IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION";
    @SystemProperty(value="Limit the maximum number of objects in memory during the recovery procedure", type=Integer.class)
    public static final String IGNITE_RECOVERY_SEMAPHORE_PERMITS = "IGNITE_RECOVERY_SEMAPHORE_PERMITS";
    @SystemProperty(value="Maximum size of history of server nodes (server node IDs) that ever joined to current topology", type=Integer.class, defaults="50")
    public static final String IGNITE_NODE_IDS_HISTORY_SIZE = "IGNITE_NODE_IDS_HISTORY_SIZE";
    @SystemProperty(value="Maximum number of diagnostic warning messages per category, when waiting for PME", type=Integer.class, defaults="10")
    public static final String IGNITE_DIAGNOSTIC_WARN_LIMIT = "IGNITE_DIAGNOSTIC_WARN_LIMIT";
    @SystemProperty(value="Enables triggering failure handler for node if unrecoverable partition inconsistency is discovered during partition update counters exchange")
    public static final String IGNITE_FAIL_NODE_ON_UNRECOVERABLE_PARTITION_INCONSISTENCY = "IGNITE_FAIL_NODE_ON_UNRECOVERABLE_PARTITION_INCONSISTENCY";
    @SystemProperty(value="Allow use composite _key, _val columns at the INSERT/UPDATE/MERGE statements")
    public static final String IGNITE_SQL_ALLOW_KEY_VAL_UPDATES = "IGNITE_SQL_ALLOW_KEY_VAL_UPDATES";
    @SystemProperty(value="Forcibly fills missing columns belonging to the primary key with nulls or default values if those have been specified", defaults="false")
    public static final String IGNITE_SQL_FILL_ABSENT_PK_WITH_DEFAULTS = "IGNITE_SQL_FILL_ABSENT_PK_WITH_DEFAULTS";
    @SystemProperty(value="Interval between logging of time of next auto-adjust in milliseconds", type=Long.class)
    public static final String IGNITE_BASELINE_AUTO_ADJUST_LOG_INTERVAL = "IGNITE_BASELINE_AUTO_ADJUST_LOG_INTERVAL";
    @SystemProperty(value="Starting from this number of dirty pages in checkpoint, array will be sorted with Arrays.parallelSort(Comparable[]) in case of CheckpointWriteOrder.SEQUENTIAL", type=Integer.class, defaults="524288")
    public static final String CHECKPOINT_PARALLEL_SORT_THRESHOLD = "CHECKPOINT_PARALLEL_SORT_THRESHOLD";
    @SystemProperty(value="Keep static cache configuration even if stored cache data differs from the static config. When this property is set, static cache configuration will override persisted configuration. DDL operations are not allowed when this system property is set")
    public static final String IGNITE_KEEP_STATIC_CACHE_CONFIGURATION = "IGNITE_KEEP_STATIC_CACHE_CONFIGURATION";
    @SystemProperty(value="Enable backward compatible to use 'IGNITE' as SQL system schema")
    public static final String IGNITE_SQL_SYSTEM_SCHEMA_NAME_IGNITE = "IGNITE_SQL_SYSTEM_SCHEMA_NAME_IGNITE";
    @SystemProperty(value="Shows if dump requests from local node to near node are allowed, when long running transaction is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread", defaults="true")
    public static final String IGNITE_TX_OWNER_DUMP_REQUESTS_ALLOWED = "IGNITE_TX_OWNER_DUMP_REQUESTS_ALLOWED";
    @SystemProperty(value="Defines factory class for H2 LocalResult", type=String.class, defaults="org.apache.ignite.internal.processors.query.h2.H2LocalResultFactory")
    public static final String IGNITE_H2_LOCAL_RESULT_FACTORY = "IGNITE_H2_LOCAL_RESULT_FACTORY";
    @SystemProperty(value="Defines default memory reservation block size", type=Long.class, defaults="524288")
    public static final String IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE = "IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE";
    @SystemProperty(value="Page lock tracker type. -1 - Disable lock tracking. 1 - HEAP_STACK. 2 - HEAP_LOG. 3 - OFF_HEAP_STACK. 4 - OFF_HEAP_LOG", type=Integer.class, defaults="-1")
    public static final String IGNITE_PAGE_LOCK_TRACKER_TYPE = "IGNITE_PAGE_LOCK_TRACKER_TYPE";
    @SystemProperty(value="Capacity in pages for storing in page lock tracker strucuture", type=Integer.class, defaults="512")
    public static final String IGNITE_PAGE_LOCK_TRACKER_CAPACITY = "IGNITE_PAGE_LOCK_TRACKER_CAPACITY";
    @SystemProperty(value="Page lock tracker thread for checking hangs threads interval", type=Integer.class, defaults="60000")
    public static final String IGNITE_PAGE_LOCK_TRACKER_CHECK_INTERVAL = "IGNITE_PAGE_LOCK_TRACKER_CHECK_INTERVAL";
    @SystemProperty(value="Enables threads locks dumping on critical node failure", defaults="true")
    public static final String IGNITE_DUMP_PAGE_LOCK_ON_FAILURE = "IGNITE_DUMP_PAGE_LOCK_ON_FAILURE";
    @SystemProperty(value="Scan the classpath on startup and log all the files containing in it", defaults="true")
    public static final String IGNITE_LOG_CLASSPATH_CONTENT_ON_STARTUP = "IGNITE_LOG_CLASSPATH_CONTENT_ON_STARTUP";
    @SystemProperty(value="Maximum size of table (rows count) when temporary hash index can be built on fly", type=Integer.class, defaults="100000")
    public static final String IGNITE_HASH_JOIN_MAX_TABLE_SIZE = "IGNITE_HASH_JOIN_MAX_TABLE_SIZE";
    @SystemProperty(value="Enable hash join (create hash index on the fly) for query optimizer. When disabled hash join may be enabled only by index hint", defaults="false")
    public static final String IGNITE_ENABLE_HASH_JOIN = "IGNITE_ENABLE_HASH_JOIN";
    @SystemProperty(value="Threshold timeout for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while acquiring locks, preparing, committing, etc) and user time (time when client node runs some code while holding transaction and not waiting it). Equals 0 if not set. No long transactions are dumped in log if nor this parameter neither IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT is set", type=Long.class)
    public static final String IGNITE_LONG_TRANSACTION_TIME_DUMP_THRESHOLD = "IGNITE_LONG_TRANSACTION_TIME_DUMP_THRESHOLD";
    @SystemProperty(value="The coefficient for samples of completed transactions that will be dumped in log. Must be float value between 0.0 and 1.0 inclusive", type=Float.class)
    public static final String IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT = "IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT";
    @SystemProperty(value="The limit of samples of completed transactions that will be dumped in log per second, if IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_COEFFICIENT is above 0.0. Must be integer value greater than 0", type=Integer.class, defaults="5")
    public static final String IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_PER_SECOND_LIMIT = "IGNITE_TRANSACTION_TIME_DUMP_SAMPLES_PER_SECOND_LIMIT";
    @SystemProperty(value="Disables smart DR throttling", defaults="false")
    public static final String IGNITE_DISABLE_SMART_DR_THROTTLING = "IGNITE_DISABLE_SMART_DR_THROTTLING";
    @SystemProperty(value="Disables onheap caching of pages lists (free lists and reuse lists). If persistence is enabled changes to page lists are not stored to page memory immediately, they are cached in onheap buffer and flushes to page memory on a checkpoint. This property allows to disable such onheap caching")
    public static final String IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING = "IGNITE_PAGES_LIST_DISABLE_ONHEAP_CACHING";
    @SystemProperty(value="The master key name that the node will use during the recovery. If a node was unavailable during a master key change process it won't be able to join to cluster with old the master key. Set up this property to re-encrypt cache keys on startup and join to cluster with the valid master key name", type=String.class)
    public static final String IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP = "IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP";
    @SystemProperty(value="Disable group state lazy store. It means that group state won't be cached and will be read from wal every time", defaults="false")
    public static final String IGNITE_DISABLE_GRP_STATE_LAZY_STORE = "IGNITE_DISABLE_GRP_STATE_LAZY_STORE";
    @SystemProperty(value="Enables extended logging of indexes create/rebuild process. Warning: enabling that option can lead to performance degradation of index creation, rebuilding and node restart")
    public static final String IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING = "IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING";
    @Deprecated
    @SystemProperty(value="Enables node to wait until all of its data is backed up before shutting down. Please note that it will completely prevent last node in cluster from shutting down if any caches exist that have backups configured")
    @IgniteExperimental
    public static final String IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN = "IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN";
    @SystemProperty(value="Choose the index cost function. May be used to compatibility with old version\n The possible values: \"LAST\", \"COMPATIBLE_8_7_28\", \"COMPATIBLE_8_7_12\", \"COMPATIBLE_8_7_6\"", defaults="LAST")
    public static final String IGNITE_INDEX_COST_FUNCTION = "IGNITE_INDEX_COST_FUNCTION";
    @SystemProperty(value="Enables setting attribute value of TcpCommunicationSpi#ATTR_HOST_NAMES when value IgniteConfiguration#getLocalHost is ip, for backward compatibility")
    public static final String IGNITE_TCP_COMM_SET_ATTR_HOST_NAMES = "IGNITE_TCP_COMM_SET_ATTR_HOST_NAMES";
    @SystemProperty(value="When above zero, prints tx key collisions once per interval. Each transaction besides OPTIMISTIC SERIALIZABLE capture locks on all enlisted keys, for some reasons per key lock queue may rise. This property sets the interval during which statistics are collected", type=Integer.class, defaults="1000")
    public static final String IGNITE_DUMP_TX_COLLISIONS_INTERVAL = "IGNITE_DUMP_TX_COLLISIONS_INTERVAL";
    @SystemProperty(value="Defines how many exchange futures are kept uncleared in the queue", type=Integer.class, defaults="10")
    public static final String IGNITE_KEEP_UNCLEARED_EXCHANGE_FUTURES_LIMIT = "IGNITE_KEEP_UNCLEARED_EXCHANGE_FUTURES_LIMIT";
    @SystemProperty(value="If specified, enforces legacy behavior for system properties authorization when SecurityPermissionSet.defaultAllowAll() is set to true: if user's system permission set is empty, all system actions will be prohibited")
    public static final String IGNITE_DFLT_ALLOW_EMPTY_SYS_PERMISSIONS = "IGNITE_DFLT_ALLOW_EMPTY_SYS_PERMISSIONS";
    @SystemProperty(value="Defragmentation region size percentage of configured region size. This percentage will be calculated from largest configured region size and then proportionally subtracted from all configured regions", type=Integer.class, defaults="60")
    public static final String IGNITE_DEFRAGMENTATION_REGION_SIZE_PERCENTAGE = "IGNITE_DEFRAGMENTATION_REGION_SIZE_PERCENTAGE";
    @SystemProperty(value="If true, cache names will be validated not to contain characters which cause issues when persistence is used ({@code \\}, {@code /}, {@code \\0})", defaults="true")
    public static final String IGNITE_VALIDATE_CACHE_NAMES = "IGNITE_VALIDATE_CACHE_NAMES";
    @SystemProperty(value="There can be background tasks that can be interrupted due to node stop, node fail, or cluster deactivation, but need to be completed, so they start after node start or cluster activation. If this option is set to false, then tasks will not be started", defaults="true")
    public static final String IGNITE_EXECUTE_DURABLE_BACKGROUND_TASKS_ON_NODE_START_OR_ACTIVATE = "IGNITE_EXECUTE_DURABLE_BACKGROUND_TASKS_ON_NODE_START_OR_ACTIVATE";
    @SystemProperty(value="Set to true only during the junit tests", defaults="false")
    public static final String IGNITE_TEST_ENV = "IGNITE_TEST_ENV";
    @SystemProperty(value="Use TreeMap instead of HashMap to hold distinct values", defaults="false")
    public static final String IGNITE_SQL_DISTINCT_RESULTS_USE_TREE_MAP = "IGNITE_SQL_DISTINCT_RESULTS_USE_TREE_MAP";
    @SystemProperty(value="Count of rows, being processed within a single checkpoint lock when indexes are rebuilt", type=Integer.class, defaults="1000")
    public static final String IGNITE_INDEX_REBUILD_BATCH_SIZE = "IGNITE_INDEX_REBUILD_BATCH_SIZE";
    @SystemProperty(value="Enables additional check that sender of communication handshake message corresponds to the node id included in the message", defaults="false")
    public static final String IGNITE_CHECK_COMMUNICATION_HANDSHAKE_MESSAGE_SENDER = "IGNITE_CHECK_COMMUNICATION_HANDSHAKE_MESSAGE_SENDER";
    @SystemProperty(value="Enables asserts instead of warning or error log messaged on check some internal invariants", defaults="false")
    public static final String IGNITE_STRICT_CONSISTENCY_CHECK = "IGNITE_STRICT_CONSISTENCY_CHECK";
    @SystemProperty(value="Disable a maintenance task for removing storage folders", defaults="false")
    public static final String IGNITE_DISABLE_MAINTENANCE_CLEAR_FOLDER_TASK = "IGNITE_DISABLE_MAINTENANCE_CLEAR_FOLDER_TASK";
    @SystemProperty(value="Enables an allow overwrite mode for a data streamer", defaults="true")
    public static final String IGNITE_DATA_STREAMER_ALLOW_OVERWRITE = "IGNITE_DATA_STREAMER_ALLOW_OVERWRITE";
    @SystemProperty(value="SSL handshake timeout, in milliseconds", type=Long.class, defaults="3000 milliseconds")
    public static final String IGNITE_SSL_HANDSHAKE_TIMEOUT = "IGNITE_SSL_HANDSHAKE_TIMEOUT";
    @SystemProperty(value="This property allows reducing the number of internal notifications of thick clients when the cache-based implementation of the service framework is used", defaults="false")
    public static final String IGNITE_SERVICES_SET_REMOTE_FILTER_ON_START = "IGNITE_SERVICES_SET_REMOTE_FILTER_ON_START";
    @SystemProperty(value="Node in maintenance mode will automatically shut down after all active maintenance would be completed", defaults="false")
    public static final String IGNITE_MAINTENANCE_AUTO_SHUTDOWN_AFTER_RECOVERY = "IGNITE_MAINTENANCE_AUTO_SHUTDOWN_AFTER_RECOVERY";
    @SystemProperty(value="Dumps latest WAL segments and related index and partition files on data corruption error", defaults="false")
    public static final String IGNITE_DUMP_PERSISTENCE_FILES_ON_DATA_CORRUPTION = "IGNITE_DUMP_PERSISTENCE_FILES_ON_DATA_CORRUPTION";
    @SystemProperty(value="Node in maintenance mode will shut down with specified JVM exit code", defaults="0")
    public static final String IGNITE_MAINTENANCE_MODE_EXIT_CODE = "IGNITE_MAINTENANCE_MODE_EXIT_CODE";
    @SystemProperty(value="SSL unwrap timeout, in milliseconds", type=Long.class, defaults="3000 milliseconds")
    public static final String IGNITE_SSL_UNWRAP_TIMEOUT = "IGNITE_SSL_UNWRAP_TIMEOUT";
    @SystemProperty(value="Packages list to expose in configuration view")
    @IgniteExperimental
    public static final String IGNITE_CONFIGURATION_VIEW_PACKAGES = "IGNITE_CONFIGURATION_VIEW_PACKAGES";
    @SystemProperty(value="Nodes will send messages with compacted topology history", defaults="true")
    public static final String IGNITE_COMPACTED_TOPOLOGY_HISTORY = "IGNITE_COMPACTED_TOPOLOGY_HISTORY";

    private IgniteSystemProperties() {
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name) {
        return IgniteSystemProperties.getEnum(enumCls, name, null);
    }

    public static <E extends Enum<E>> E getEnum(String name, E dflt) {
        return IgniteSystemProperties.getEnum(dflt.getDeclaringClass(), name, dflt);
    }

    private static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name, E dflt) {
        assert (enumCls != null);
        String val = IgniteSystemProperties.getString(name);
        if (val == null) {
            return dflt;
        }
        try {
            return Enum.valueOf(enumCls, val);
        }
        catch (IllegalArgumentException ignore) {
            return dflt;
        }
    }

    @Nullable
    public static String getString(String name) {
        assert (name != null);
        String v = System.getProperty(name);
        if (v == null) {
            v = System.getenv(name);
        }
        return v;
    }

    @Nullable
    public static String getString(String name, String dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : val;
    }

    public static boolean getBoolean(String name) {
        return IgniteSystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : Boolean.parseBoolean(val);
    }

    public static int getInteger(String name, int dflt) {
        int res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Integer.parseInt(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static float getFloat(String name, float dflt) {
        float res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Float.parseFloat(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static long getLong(String name, long dflt) {
        long res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Long.parseLong(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static double getDouble(String name, double dflt) {
        double res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = Double.parseDouble(s);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static UUID getUUID(String name, UUID dflt) {
        UUID res;
        String s = IgniteSystemProperties.getString(name);
        if (s == null) {
            return dflt;
        }
        try {
            res = UUID.fromString(s);
        }
        catch (IllegalArgumentException ignore) {
            res = dflt;
        }
        return res;
    }

    public static Properties snapshot() {
        Properties sysProps = (Properties)System.getProperties().clone();
        Iterator<Map.Entry<Object, Object>> iter = sysProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (entry.getValue() instanceof String && entry.getKey() instanceof String) continue;
            iter.remove();
        }
        return sysProps;
    }
}

