/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite.spi.tracing.Scope;
import org.jetbrains.annotations.NotNull;

public class TracingConfigurationParameters
implements Serializable {
    public static final TracingConfigurationParameters EMPTY = new Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();
    private static final long serialVersionUID = 0L;
    public static final double SAMPLING_RATE_NEVER = 0.0;
    public static final double SAMPLING_RATE_ALWAYS = 1.0;
    private final double samplingRate;
    private final Set<Scope> includedScopes;

    private TracingConfigurationParameters(double samplingRate, Set<Scope> includedScopes) {
        this.samplingRate = samplingRate;
        this.includedScopes = Collections.unmodifiableSet(includedScopes);
    }

    public double samplingRate() {
        return this.samplingRate;
    }

    @NotNull
    public Set<Scope> includedScopes() {
        return this.includedScopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TracingConfigurationParameters that = (TracingConfigurationParameters)o;
        if (Double.compare(that.samplingRate, this.samplingRate) != 0) {
            return false;
        }
        return this.includedScopes != null ? this.includedScopes.equals(that.includedScopes) : that.includedScopes == null;
    }

    public static class Builder {
        private double samplingRate;
        private Set<Scope> includedScopes = Collections.emptySet();

        @NotNull
        public Builder withSamplingRate(double samplingRate) {
            if (samplingRate < 0.0 || samplingRate > 1.0) {
                throw new IllegalArgumentException("Specified sampling rate=[" + samplingRate + "] has invalid value. Should be between 0 and 1 including boundaries.");
            }
            this.samplingRate = samplingRate;
            return this;
        }

        @NotNull
        public Builder withIncludedScopes(Set<Scope> includedScopes) {
            this.includedScopes = includedScopes == null ? Collections.emptySet() : includedScopes;
            return this;
        }

        public TracingConfigurationParameters build() {
            return new TracingConfigurationParameters(this.samplingRate, this.includedScopes);
        }
    }
}

