/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.encryption.keystore;

import java.io.Serializable;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class KeystoreEncryptionKey
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Key k;
    @Nullable
    final byte[] digest;

    KeystoreEncryptionKey(Key k, @Nullable byte[] digest) {
        this.k = k;
        this.digest = digest;
    }

    public Key key() {
        return this.k;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeystoreEncryptionKey key = (KeystoreEncryptionKey)o;
        return Objects.equals(this.k, key.k) && Arrays.equals(this.digest, key.digest);
    }

    public int hashCode() {
        int result = Objects.hash(this.k);
        result = 31 * result + Arrays.hashCode(this.digest);
        return result;
    }

    public String toString() {
        return Base64.getEncoder().encodeToString(this.digest);
    }
}

