/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.collision.priorityqueue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.GridTaskSessionInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.collision.CollisionContext;
import org.apache.ignite.spi.collision.CollisionExternalListener;
import org.apache.ignite.spi.collision.CollisionJobContext;
import org.apache.ignite.spi.collision.CollisionSpi;
import org.apache.ignite.spi.collision.priorityqueue.PriorityQueueCollisionSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=true)
public class PriorityQueueCollisionSpi
extends IgniteSpiAdapter
implements CollisionSpi {
    public static final int DFLT_PARALLEL_JOBS_NUM = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DFLT_WAIT_JOBS_NUM = Integer.MAX_VALUE;
    public static final String DFLT_PRIORITY_ATTRIBUTE_KEY = "grid.task.priority";
    public static final String DFLT_JOB_PRIORITY_ATTRIBUTE_KEY = "grid.job.priority";
    public static final int DFLT_PRIORITY = 0;
    public static final int DFLT_STARVATION_INCREMENT = 1;
    public static final boolean DFLT_PREVENT_STARVATION_ENABLED = true;
    private static final String PRIORITY_ATTRIBUTE_KEY = "gg:collision:priority";
    private volatile int parallelJobsNum = DFLT_PARALLEL_JOBS_NUM;
    private volatile int waitJobsNum = Integer.MAX_VALUE;
    private volatile int runningCnt;
    private volatile int waitingCnt;
    private volatile int heldCnt;
    private String taskPriAttrKey = "grid.task.priority";
    private String jobPriAttrKey = "grid.job.priority";
    private volatile int dfltPri = 0;
    private volatile int starvationInc = 1;
    private volatile boolean preventStarvation = true;
    private final Comparator<GridCollisionJobContextWrapper> priComp = Comparator.comparing(w -> this.getJobPriority(((GridCollisionJobContextWrapper)w).ctx), Comparator.reverseOrder());
    @LoggerResource
    private IgniteLogger log;

    public int getParallelJobsNumber() {
        return this.parallelJobsNum;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setParallelJobsNumber(int parallelJobsNum) {
        A.ensure(parallelJobsNum > 0, "parallelJobsNum > 0");
        this.parallelJobsNum = parallelJobsNum;
        return this;
    }

    public int getWaitingJobsNumber() {
        return this.waitJobsNum;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setWaitingJobsNumber(int waitJobsNum) {
        A.ensure(waitJobsNum >= 0, "waitJobsNum >= 0");
        this.waitJobsNum = waitJobsNum;
        return this;
    }

    public int getCurrentWaitJobsNumber() {
        return this.waitingCnt;
    }

    public int getCurrentActiveJobsNumber() {
        return this.runningCnt + this.heldCnt;
    }

    public int getCurrentRunningJobsNumber() {
        return this.runningCnt;
    }

    public int getCurrentHeldJobsNumber() {
        return this.heldCnt;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setPriorityAttributeKey(String taskPriAttrKey) {
        this.taskPriAttrKey = taskPriAttrKey;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setJobPriorityAttributeKey(String jobPriAttrKey) {
        this.jobPriAttrKey = jobPriAttrKey;
        return this;
    }

    public String getPriorityAttributeKey() {
        return this.taskPriAttrKey;
    }

    public String getJobPriorityAttributeKey() {
        return this.jobPriAttrKey;
    }

    public int getDefaultPriority() {
        return this.dfltPri;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setDefaultPriority(int priority) {
        this.dfltPri = priority;
        return this;
    }

    public int getStarvationIncrement() {
        return this.starvationInc;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setStarvationIncrement(int starvationInc) {
        this.starvationInc = starvationInc;
        return this;
    }

    public boolean isStarvationPreventionEnabled() {
        return this.preventStarvation;
    }

    @IgniteSpiConfiguration(optional=true)
    public PriorityQueueCollisionSpi setStarvationPreventionEnabled(boolean preventStarvation) {
        this.preventStarvation = preventStarvation;
        return this;
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        return F.asMap(this.createSpiAttributeName(PRIORITY_ATTRIBUTE_KEY), this.getPriorityAttributeKey());
    }

    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        this.assertParameter(this.parallelJobsNum > 0, "parallelJobsNum > 0");
        this.assertParameter(this.waitJobsNum >= 0, "waitingJobsNum >= 0");
        this.assertParameter(this.starvationInc >= 0, "starvationInc >= 0");
        this.assertParameter(this.taskPriAttrKey != null, "taskPriAttrKey != null");
        this.assertParameter(this.jobPriAttrKey != null, "jobPriorityAttrKey != null");
        this.startStopwatch();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("parallelJobsNum", this.parallelJobsNum));
            this.log.debug(this.configInfo("taskPriAttrKey", this.taskPriAttrKey));
            this.log.debug(this.configInfo("jobPriorityAttrKey", this.jobPriAttrKey));
            this.log.debug(this.configInfo("dfltPri", this.dfltPri));
            this.log.debug(this.configInfo("starvationInc", this.starvationInc));
            this.log.debug(this.configInfo("preventStarvation", this.preventStarvation));
        }
        this.registerMBean(igniteInstanceName, new PriorityQueueCollisionSpiMBeanImpl(this), PriorityQueueCollisionSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public void setExternalCollisionListener(CollisionExternalListener lsnr) {
    }

    @Override
    public void onCollision(CollisionContext ctx) {
        int waitJobsNum;
        assert (ctx != null);
        int activeSize = ctx.activeJobs().size();
        Collection<CollisionJobContext> waitJobs = ctx.waitingJobs();
        int waitSize = waitJobs.size();
        this.runningCnt = activeSize;
        this.waitingCnt = waitSize;
        this.heldCnt = ctx.heldJobs().size();
        int activateCnt = this.parallelJobsNum - activeSize;
        ArrayList<GridCollisionJobContextWrapper> waitSnap = PriorityQueueCollisionSpi.slice(waitJobs, waitSize);
        boolean waitSnapSorted = false;
        if (activateCnt > 0 && waitSize > 0) {
            if (waitSize <= activateCnt) {
                for (GridCollisionJobContextWrapper cntx : waitSnap) {
                    cntx.getContext().activate();
                    --waitSize;
                }
            } else {
                waitSnap.sort(this.priComp);
                waitSnapSorted = true;
                if (this.preventStarvation) {
                    this.bumpPriority(waitSnap);
                }
                for (int i = 0; i < activateCnt && i < waitSnap.size(); ++i) {
                    waitSnap.get(i).getContext().activate();
                    --waitSize;
                }
            }
        }
        if (waitSize > (waitJobsNum = this.waitJobsNum)) {
            int skip = waitSnap.size() - waitSize;
            if (!waitSnapSorted) {
                waitSnap.sort(this.priComp);
            }
            int i = 0;
            for (GridCollisionJobContextWrapper wrapper : waitSnap) {
                if (++i < skip) continue;
                wrapper.getContext().cancel();
                if (--waitSize > waitJobsNum) continue;
                break;
            }
        }
    }

    private static ArrayList<GridCollisionJobContextWrapper> slice(Collection<CollisionJobContext> src, int num) {
        ArrayList<GridCollisionJobContextWrapper> slice = new ArrayList<GridCollisionJobContextWrapper>();
        Iterator<CollisionJobContext> iter = src.iterator();
        for (int i = 0; i < num && iter.hasNext(); ++i) {
            slice.add(new GridCollisionJobContextWrapper(iter.next(), i));
        }
        return slice;
    }

    private void bumpPriority(List<GridCollisionJobContextWrapper> jobs) {
        int starvationInc = this.starvationInc;
        for (int i = 0; i < jobs.size(); ++i) {
            GridCollisionJobContextWrapper wrapper = jobs.get(i);
            if (i <= wrapper.originalIndex()) continue;
            wrapper.getContext().getJobContext().setAttribute(this.jobPriAttrKey, this.getJobPriority(wrapper.getContext()) + starvationInc);
        }
    }

    private int getJobPriority(CollisionJobContext ctx) {
        assert (ctx != null);
        Integer pri = null;
        ComputeJobContext jobCtx = ctx.getJobContext();
        try {
            pri = (Integer)jobCtx.getAttribute(this.jobPriAttrKey);
        }
        catch (ClassCastException e) {
            LT.error(this.log, e, "Type of job context priority attribute '" + this.jobPriAttrKey + "' is not java.lang.Integer [type=" + jobCtx.getAttribute(this.jobPriAttrKey).getClass() + ']');
        }
        if (pri == null) {
            GridTaskSessionInternal taskSes = (GridTaskSessionInternal)ctx.getTaskSession();
            if (!taskSes.isFullSupport()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Task does not support session attributes (will use default priority): " + this.dfltPri);
                }
                pri = this.dfltPri;
            } else {
                try {
                    pri = (Integer)taskSes.getAttribute(this.taskPriAttrKey);
                }
                catch (ClassCastException e) {
                    LT.error(this.log, e, "Type of task session priority attribute '" + this.taskPriAttrKey + "' is not java.lang.Integer [type=" + taskSes.getAttribute(this.taskPriAttrKey).getClass() + ']');
                }
                if (pri == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed get priority from job context attribute '" + this.jobPriAttrKey + "' and task session attribute '" + this.taskPriAttrKey + "' (will use default priority): " + this.dfltPri);
                    }
                    pri = this.dfltPri;
                }
            }
        }
        return pri;
    }

    @Override
    protected List<String> getConsistentAttributeNames() {
        return Collections.singletonList(this.createSpiAttributeName(PRIORITY_ATTRIBUTE_KEY));
    }

    @Override
    public PriorityQueueCollisionSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(PriorityQueueCollisionSpi.class, this);
    }

    private class PriorityQueueCollisionSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements PriorityQueueCollisionSpiMBean {
        PriorityQueueCollisionSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public int getParallelJobsNumber() {
            return PriorityQueueCollisionSpi.this.getParallelJobsNumber();
        }

        @Override
        @IgniteSpiConfiguration(optional=true)
        public void setParallelJobsNumber(int parallelJobsNum) {
            PriorityQueueCollisionSpi.this.setParallelJobsNumber(parallelJobsNum);
        }

        @Override
        public int getWaitingJobsNumber() {
            return PriorityQueueCollisionSpi.this.getWaitingJobsNumber();
        }

        @Override
        public void setWaitingJobsNumber(int waitJobsNum) {
            PriorityQueueCollisionSpi.this.setWaitingJobsNumber(waitJobsNum);
        }

        @Override
        public String getPriorityAttributeKey() {
            return PriorityQueueCollisionSpi.this.getPriorityAttributeKey();
        }

        @Override
        public String getJobPriorityAttributeKey() {
            return PriorityQueueCollisionSpi.this.getJobPriorityAttributeKey();
        }

        @Override
        public int getDefaultPriority() {
            return PriorityQueueCollisionSpi.this.getDefaultPriority();
        }

        @Override
        public void setDefaultPriority(int dfltPri) {
            PriorityQueueCollisionSpi.this.setDefaultPriority(dfltPri);
        }

        @Override
        public int getStarvationIncrement() {
            return PriorityQueueCollisionSpi.this.getStarvationIncrement();
        }

        @Override
        public void setStarvationIncrement(int starvationInc) {
            PriorityQueueCollisionSpi.this.setStarvationIncrement(starvationInc);
        }

        @Override
        public boolean isStarvationPreventionEnabled() {
            return PriorityQueueCollisionSpi.this.isStarvationPreventionEnabled();
        }

        @Override
        public void setStarvationPreventionEnabled(boolean preventStarvation) {
            PriorityQueueCollisionSpi.this.setStarvationPreventionEnabled(preventStarvation);
        }

        @Override
        public int getCurrentWaitJobsNumber() {
            return PriorityQueueCollisionSpi.this.getCurrentWaitJobsNumber();
        }

        @Override
        public int getCurrentActiveJobsNumber() {
            return PriorityQueueCollisionSpi.this.getCurrentActiveJobsNumber();
        }

        @Override
        public int getCurrentRunningJobsNumber() {
            return PriorityQueueCollisionSpi.this.getCurrentRunningJobsNumber();
        }

        @Override
        public int getCurrentHeldJobsNumber() {
            return PriorityQueueCollisionSpi.this.getCurrentHeldJobsNumber();
        }
    }

    private static class GridCollisionJobContextWrapper {
        private final CollisionJobContext ctx;
        private final int originalIdx;

        private GridCollisionJobContextWrapper(CollisionJobContext ctx, int originalIdx) {
            this.ctx = ctx;
            this.originalIdx = originalIdx;
        }

        public CollisionJobContext getContext() {
            return this.ctx;
        }

        public int originalIndex() {
            return this.originalIdx;
        }
    }
}

