/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.plugin.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.jetbrains.annotations.Nullable;

public class SecurityBasicPermissionSet
implements SecurityPermissionSet {
    private static final long serialVersionUID = 0L;
    public static final String TRACING_PERMISSIONS_SET = "Tracing permissions set";
    @GridToStringInclude
    private Map<String, Collection<SecurityPermission>> cachePermissions = new HashMap<String, Collection<SecurityPermission>>();
    @GridToStringInclude
    private Map<String, Collection<SecurityPermission>> taskPermissions = new HashMap<String, Collection<SecurityPermission>>();
    @GridToStringInclude
    private transient Map<String, Collection<SecurityPermission>> servicePermissions = SecurityUtils.isSecurityCompatibilityMode() ? SecurityUtils.compatibleServicePermissions() : new HashMap();
    @GridToStringInclude
    private Collection<SecurityPermission> systemPermissions;
    private boolean dfltAllowAll;

    public void setCachePermissions(Map<String, Collection<SecurityPermission>> cachePermissions) {
        A.notNull(cachePermissions, "cachePermissions");
        this.cachePermissions = cachePermissions;
    }

    public void setTaskPermissions(Map<String, Collection<SecurityPermission>> taskPermissions) {
        A.notNull(taskPermissions, "taskPermissions");
        this.taskPermissions = taskPermissions;
    }

    public void setServicePermissions(Map<String, Collection<SecurityPermission>> servicePermissions) {
        A.notNull(this.taskPermissions, "servicePermissions");
        this.servicePermissions = servicePermissions;
    }

    public void setTracingPermissions(Collection<SecurityPermission> tracingPermissions) {
        A.notNull(tracingPermissions, "tracingPermissions");
        HashMap<String, Collection<SecurityPermission>> tmp = new HashMap<String, Collection<SecurityPermission>>(this.servicePermissions);
        tmp.put(TRACING_PERMISSIONS_SET, tracingPermissions);
        this.servicePermissions = tmp;
    }

    public void setSystemPermissions(Collection<SecurityPermission> systemPermissions) {
        this.systemPermissions = systemPermissions;
    }

    public void setDefaultAllowAll(boolean dfltAllowAll) {
        this.dfltAllowAll = dfltAllowAll;
    }

    @Override
    public Map<String, Collection<SecurityPermission>> cachePermissions() {
        return this.cachePermissions;
    }

    @Override
    public Map<String, Collection<SecurityPermission>> taskPermissions() {
        return this.taskPermissions;
    }

    @Override
    public Map<String, Collection<SecurityPermission>> servicePermissions() {
        return F.view(this.servicePermissions, s -> !s.equals(TRACING_PERMISSIONS_SET));
    }

    @Override
    public Collection<SecurityPermission> tracingPermissions() {
        return this.servicePermissions.getOrDefault(TRACING_PERMISSIONS_SET, Collections.emptySet());
    }

    @Override
    @Nullable
    public Collection<SecurityPermission> systemPermissions() {
        return this.systemPermissions;
    }

    @Override
    public boolean defaultAllowAll() {
        return this.dfltAllowAll;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityBasicPermissionSet)) {
            return false;
        }
        SecurityBasicPermissionSet other = (SecurityBasicPermissionSet)o;
        return this.dfltAllowAll == other.dfltAllowAll && F.eq(this.cachePermissions, other.cachePermissions) && F.eq(this.taskPermissions, other.taskPermissions) && F.eq(this.servicePermissions, other.servicePermissions) && F.eq(this.systemPermissions, other.systemPermissions);
    }

    public int hashCode() {
        int res = this.dfltAllowAll ? 1 : 0;
        res = 31 * res + (this.cachePermissions != null ? this.cachePermissions.hashCode() : 0);
        res = 31 * res + (this.taskPermissions != null ? this.taskPermissions.hashCode() : 0);
        res = 31 * res + (this.servicePermissions != null ? this.servicePermissions.hashCode() : 0);
        res = 31 * res + (this.systemPermissions != null ? this.systemPermissions.hashCode() : 0);
        return res;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (SecurityUtils.serializeVersion() >= 2) {
            U.writeMap(out, this.servicePermissions);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (SecurityUtils.serializeVersion() >= 2) {
            this.servicePermissions = U.readMap(in);
        }
        if (this.servicePermissions == null) {
            this.servicePermissions = SecurityUtils.serializeVersion() < 2 ? SecurityUtils.compatibleServicePermissions() : Collections.emptyMap();
        }
    }

    public String toString() {
        return S.toString(SecurityBasicPermissionSet.class, this);
    }
}

