/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryField;
import org.apache.ignite.internal.visor.query.VisorQueryHolder;
import org.apache.ignite.internal.visor.query.VisorQueryNextPageTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorQueryFetchFirstPageTask
extends VisorOneNodeTask<VisorQueryNextPageTaskArg, VisorEither<VisorQueryResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryFetchFirstPageJob job(VisorQueryNextPageTaskArg arg) {
        return new VisorQueryFetchFirstPageJob(arg, this.debug);
    }

    private static class VisorQueryFetchFirstPageJob
    extends VisorJob<VisorQueryNextPageTaskArg, VisorEither<VisorQueryResult>> {
        private static final long serialVersionUID = 0L;

        private VisorQueryFetchFirstPageJob(VisorQueryNextPageTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorQueryResult> run(VisorQueryNextPageTaskArg arg) {
            boolean hasMore;
            VisorQueryHolder holder;
            String qryId = arg.getQueryId();
            long start = System.currentTimeMillis();
            if (this.debug) {
                start = VisorTaskUtils.log(this.ignite.log(), "Fetch query first page started: " + qryId, this.getClass(), start);
            }
            if ((holder = VisorQueryUtils.getQueryHolder(this.ignite, qryId)).getErr() != null) {
                return new VisorEither<VisorExceptionWrapper>(new VisorExceptionWrapper(holder.getErr()));
            }
            List<Object[]> rows = null;
            List<VisorQueryField> cols = holder.getColumns();
            boolean bl = hasMore = cols == null;
            if (cols != null) {
                Iterator itr = holder.getIterator();
                rows = VisorQueryUtils.fetchQueryRows(itr, qryId, arg.getPageSize());
                hasMore = itr.hasNext();
            }
            if (hasMore) {
                holder.setAccessed(true);
            } else {
                VisorQueryUtils.removeQueryHolder(this.ignite, qryId);
            }
            if (this.debug) {
                VisorTaskUtils.log(this.ignite.log(), "Fetch query first page finished: " + qryId, this.getClass(), start);
            }
            return new VisorEither<VisorQueryResult>(new VisorQueryResult(this.ignite.localNode().id(), qryId, cols, rows, hasMore, holder.duration() + System.currentTimeMillis() - start));
        }

        public String toString() {
            return S.toString(VisorQueryFetchFirstPageJob.class, this);
        }
    }
}

