/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.misc;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.misc.VisorClusterNode;
import org.apache.ignite.internal.visor.misc.VisorWalTaskArg;
import org.apache.ignite.internal.visor.misc.VisorWalTaskResult;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorWalTask
extends VisorMultiNodeTask<VisorWalTaskArg, VisorWalTaskResult, Collection<String>> {
    private static final long serialVersionUID = 0L;
    private static final Pattern WAL_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal");
    private static final Pattern WAL_SEGMENT_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip");
    private static final FileFilter WAL_ARCHIVE_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && (WAL_NAME_PATTERN.matcher(file.getName()).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches());
        }
    };

    protected VisorWalJob job(VisorWalTaskArg arg) {
        return new VisorWalJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorWalTaskArg> arg) {
        HashSet<String> nodeIds;
        Collection<ClusterNode> srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        VisorWalTaskArg taskArg = arg.getArgument();
        HashSet<String> hashSet = nodeIds = taskArg.getConsistentIds() != null ? new HashSet<String>(arg.getArgument().getConsistentIds()) : null;
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.consistentId().toString())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    @Override
    @Nullable
    protected VisorWalTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<String, Exception> exRes = U.newHashMap(0);
        HashMap<String, Collection<String>> res = U.newHashMap(results.size());
        HashMap<String, VisorClusterNode> nodesInfo = U.newHashMap(results.size());
        for (ComputeJobResult result : results) {
            Collection data;
            ClusterNode node = result.getNode();
            String nodeId = node.consistentId().toString();
            if (result.getException() != null) {
                exRes.put(nodeId, result.getException());
            } else if (result.getData() != null && (data = (Collection)result.getData()) != null) {
                res.put(nodeId, data);
            }
            nodesInfo.put(nodeId, new VisorClusterNode(node));
        }
        return new VisorWalTaskResult(res, exRes, nodesInfo);
    }

    private static long getIndex(File file) {
        return Long.parseLong(file.getName().substring(0, 16));
    }

    private static class VisorWalJob
    extends VisorJob<VisorWalTaskArg, Collection<String>> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        private transient IgniteLogger log;

        public VisorWalJob(VisorWalTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @Nullable
        protected Collection<String> run(@Nullable VisorWalTaskArg arg) throws IgniteException {
            try {
                GridKernalContext cctx = this.ignite.context();
                GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)cctx.cache().context().database();
                FileWriteAheadLogManager wal = (FileWriteAheadLogManager)cctx.cache().context().wal();
                if (dbMgr == null || arg == null || wal == null) {
                    return null;
                }
                switch (arg.getOperation()) {
                    case DELETE_UNUSED_WAL_SEGMENTS: {
                        return this.deleteUnusedWalSegments(dbMgr, wal);
                    }
                }
                return this.getUnusedWalSegments(dbMgr, wal);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to perform WAL task", e);
                throw new IgniteException("Failed to perform WAL task", e);
            }
        }

        Collection<String> getUnusedWalSegments(GridCacheDatabaseSharedManager dbMgr, FileWriteAheadLogManager wal) throws IgniteCheckedException {
            WALPointer lowBoundForTruncate = dbMgr.checkpointHistory().firstCheckpointPointer();
            if (lowBoundForTruncate == null) {
                return Collections.emptyList();
            }
            int maxIdx = this.resolveMaxReservedIndex(wal, lowBoundForTruncate);
            File[] walFiles = this.getWalArchiveDir().listFiles(WAL_ARCHIVE_FILE_FILTER);
            ArrayList<String> res = new ArrayList<String>(walFiles != null && walFiles.length > 0 ? walFiles.length - 1 : 0);
            if (walFiles != null && walFiles.length > 0) {
                File f;
                long fileIdx;
                this.sortWalFiles(walFiles);
                long lastArchIdx = VisorWalTask.getIndex(walFiles[walFiles.length - 1]);
                File[] fileArray = walFiles;
                int n = fileArray.length;
                for (int i = 0; i < n && (fileIdx = VisorWalTask.getIndex(f = fileArray[i])) < (long)maxIdx && fileIdx < lastArchIdx; ++i) {
                    res.add(f.getAbsolutePath());
                }
            }
            return res;
        }

        Collection<String> deleteUnusedWalSegments(GridCacheDatabaseSharedManager dbMgr, FileWriteAheadLogManager wal) throws IgniteCheckedException {
            WALPointer lowBoundForTruncate = dbMgr.checkpointHistory().firstCheckpointPointer();
            if (lowBoundForTruncate == null) {
                return Collections.emptyList();
            }
            int maxIdx = this.resolveMaxReservedIndex(wal, lowBoundForTruncate);
            File[] walFiles = this.getWalArchiveDir().listFiles(WAL_ARCHIVE_FILE_FILTER);
            dbMgr.onWalTruncated(lowBoundForTruncate);
            int num = wal.truncate(lowBoundForTruncate);
            if (walFiles != null) {
                File walFile;
                this.sortWalFiles(walFiles);
                ArrayList<String> res = new ArrayList<String>(num);
                File[] fileArray = walFiles;
                int n = fileArray.length;
                for (int i = 0; i < n && VisorWalTask.getIndex(walFile = fileArray[i]) < (long)maxIdx && num > 0; --num, ++i) {
                    res.add(walFile.getAbsolutePath());
                }
                return res;
            }
            return Collections.emptyList();
        }

        private int resolveMaxReservedIndex(FileWriteAheadLogManager wal, WALPointer lowBoundForTruncate) {
            FileWALPointer low = (FileWALPointer)lowBoundForTruncate;
            int resCnt = wal.reserved(null, lowBoundForTruncate);
            long highIdx = low.index();
            return (int)(highIdx - (long)resCnt + 1L);
        }

        private File getWalArchiveDir() throws IgniteCheckedException {
            File workDir0;
            IgniteConfiguration igCfg = this.ignite.context().config();
            DataStorageConfiguration dsCfg = igCfg.getDataStorageConfiguration();
            PdsFolderSettings<GridCacheDatabaseSharedManager.NodeFileLockHolder> resFldrs = this.ignite.context().pdsFolderResolver().resolveFolders();
            String consId = resFldrs.folderName();
            File dir = dsCfg.getWalArchivePath() != null ? ((workDir0 = new File(dsCfg.getWalArchivePath())).isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory(igCfg.getWorkDirectory(), dsCfg.getWalArchivePath(), false), consId)) : new File(U.resolveWorkDirectory(igCfg.getWorkDirectory(), "db/wal/archive", false), consId);
            if (!dir.exists()) {
                throw new IgniteCheckedException("WAL archive directory does not exists" + dir.getAbsolutePath());
            }
            return dir;
        }

        private void sortWalFiles(File[] files) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return Long.compare(VisorWalTask.getIndex(o1), VisorWalTask.getIndex(o2));
                }
            });
        }
    }
}

