/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.checkpoint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;

public class VisorCheckpointJobResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private long durationMillis;
    private Throwable error;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.nodeId);
        out.writeLong(this.durationMillis);
        out.writeObject(this.error);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = (UUID)in.readObject();
        this.durationMillis = in.readLong();
        this.error = (Exception)in.readObject();
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public boolean success() {
        return null == this.error;
    }

    public boolean failed() {
        return !this.success();
    }

    public long durationMillis() {
        return this.durationMillis;
    }

    public Throwable error() {
        return this.error;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public void durationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public void error(Throwable error) {
        this.error = error;
    }
}

