/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.checker;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.verify.RepairAlgorithm;
import org.apache.ignite.internal.util.typedef.internal.U;

public class VisorPartitionReconciliationTaskArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Set<String> caches;
    private boolean repair;
    private boolean locOutput;
    private boolean fastCheck;
    private Map<Integer, Set<Integer>> partsToRepair;
    private boolean includeSensitive;
    private int parallelism;
    private int batchSize;
    private int recheckAttempts;
    private RepairAlgorithm repairAlg;
    private int recheckDelay;

    public VisorPartitionReconciliationTaskArg() {
    }

    public VisorPartitionReconciliationTaskArg(Set<String> caches, boolean fastCheck, boolean repair, boolean includeSensitive, boolean locOutput, int parallelism, int batchSize, int recheckAttempts, RepairAlgorithm repairAlg, int recheckDelay) {
        this.caches = caches;
        this.fastCheck = fastCheck;
        this.includeSensitive = includeSensitive;
        this.locOutput = locOutput;
        this.repair = repair;
        this.parallelism = parallelism;
        this.batchSize = batchSize;
        this.recheckAttempts = recheckAttempts;
        this.repairAlg = repairAlg;
        this.recheckDelay = recheckDelay;
    }

    public VisorPartitionReconciliationTaskArg(Builder b) {
        this(b.caches, b.fastCheck, b.repair, b.includeSensitive, b.locOutput, b.parallelism, b.batchSize, b.recheckAttempts, b.repairAlg, b.recheckDelay);
        if (b.partsToRepair != null) {
            this.partsToRepair = b.partsToRepair.entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> new HashSet((Collection)e.getValue())));
        }
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.caches);
        out.writeBoolean(this.repair);
        out.writeBoolean(this.includeSensitive);
        out.writeBoolean(this.locOutput);
        out.writeInt(this.parallelism);
        out.writeInt(this.batchSize);
        out.writeInt(this.recheckAttempts);
        U.writeEnum(out, this.repairAlg);
        out.writeInt(this.recheckDelay);
        out.writeBoolean(this.fastCheck);
        U.writeIntKeyMap(out, this.partsToRepair);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.caches = U.readSet(in);
        this.repair = in.readBoolean();
        this.includeSensitive = in.readBoolean();
        this.locOutput = in.readBoolean();
        this.parallelism = in.readInt();
        this.batchSize = in.readInt();
        this.recheckAttempts = in.readInt();
        this.repairAlg = RepairAlgorithm.fromOrdinal(in.readByte());
        this.recheckDelay = in.readInt();
        if (protoVer >= 2) {
            this.fastCheck = in.readBoolean();
            this.partsToRepair = U.readIntKeyMap(in);
        }
    }

    public Set<String> caches() {
        return this.caches;
    }

    public boolean repair() {
        return this.repair;
    }

    public boolean fastCheck() {
        return this.fastCheck;
    }

    public Map<Integer, Set<Integer>> partitionsToRepair() {
        return this.partsToRepair;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int recheckAttempts() {
        return this.recheckAttempts;
    }

    public boolean includeSensitive() {
        return this.includeSensitive;
    }

    public boolean locOutput() {
        return this.locOutput;
    }

    public RepairAlgorithm repairAlg() {
        return this.repairAlg;
    }

    public int parallelism() {
        return this.parallelism;
    }

    public int recheckDelay() {
        return this.recheckDelay;
    }

    public static class Builder {
        private Set<String> caches;
        private boolean repair;
        private boolean locOutput;
        private boolean fastCheck;
        private Map<Integer, Set<Integer>> partsToRepair;
        private boolean includeSensitive;
        private int parallelism;
        private int batchSize;
        private int recheckAttempts;
        private RepairAlgorithm repairAlg;
        private int recheckDelay;

        public Builder() {
            this.caches = null;
            this.repair = false;
            this.locOutput = true;
            this.includeSensitive = true;
            this.fastCheck = false;
            this.parallelism = 4;
            this.batchSize = 100;
            this.recheckAttempts = 2;
            this.recheckDelay = 1;
            this.repairAlg = RepairAlgorithm.defaultValue();
        }

        public Builder(VisorPartitionReconciliationTaskArg cpFrom) {
            this.caches = cpFrom.caches;
            this.repair = cpFrom.repair;
            this.locOutput = cpFrom.locOutput;
            this.includeSensitive = cpFrom.includeSensitive;
            this.fastCheck = cpFrom.fastCheck;
            this.partsToRepair = cpFrom.partsToRepair;
            this.parallelism = cpFrom.parallelism;
            this.batchSize = cpFrom.batchSize;
            this.recheckAttempts = cpFrom.recheckAttempts;
            this.recheckDelay = cpFrom.recheckDelay;
            this.repairAlg = cpFrom.repairAlg;
        }

        public VisorPartitionReconciliationTaskArg build() {
            return new VisorPartitionReconciliationTaskArg(this);
        }

        public Builder caches(Set<String> caches) {
            this.caches = caches;
            return this;
        }

        public Builder repair(boolean repair) {
            this.repair = repair;
            return this;
        }

        public Builder fastCheck(boolean fastCheck) {
            this.fastCheck = fastCheck;
            return this;
        }

        public Builder partitionsToRepair(Map<Integer, Set<Integer>> partsToRepair) {
            this.partsToRepair = partsToRepair;
            return this;
        }

        public Builder locOutput(boolean locOutput) {
            this.locOutput = locOutput;
            return this;
        }

        public Builder includeSensitive(boolean includeSensitive) {
            this.includeSensitive = includeSensitive;
            return this;
        }

        public Builder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder recheckAttempts(int recheckAttempts) {
            this.recheckAttempts = recheckAttempts;
            return this;
        }

        public Builder repairAlg(RepairAlgorithm repairAlg) {
            this.repairAlg = repairAlg;
            return this;
        }

        public Builder recheckDelay(int recheckDelay) {
            this.recheckDelay = recheckDelay;
            return this;
        }
    }
}

