/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.ClearCachesTaskArg;
import org.apache.ignite.internal.visor.cache.ClearCachesTaskResult;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ClearCachesTask
extends VisorOneNodeTask<ClearCachesTaskArg, ClearCachesTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<ClearCachesTaskArg, ClearCachesTaskResult> job(ClearCachesTaskArg arg) {
        return new ClearCacheJob(arg, this.debug);
    }

    private static class ClearCacheJob
    extends VisorJob<ClearCachesTaskArg, ClearCachesTaskResult> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private GridCompoundFuture opFut;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private List<String> clearedCaches = new ArrayList<String>();
        private List<String> nonExistentCaches = new ArrayList<String>();

        private ClearCacheJob(ClearCachesTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ClearCachesTaskResult run(@Nullable ClearCachesTaskArg arg) throws IgniteException {
            if (this.opFut == null) {
                this.opFut = new GridCompoundFuture();
                for (String cache : arg.caches()) {
                    IgniteCache ignCache = this.ignite.cache(cache);
                    if (ignCache == null) {
                        this.nonExistentCaches.add(cache);
                        continue;
                    }
                    GridFutureAdapter fut = new GridFutureAdapter();
                    ignCache.clearAsync().listen(asyncClearFut -> {
                        try {
                            asyncClearFut.get();
                        }
                        catch (IgniteException e) {
                            fut.onDone(e);
                            return;
                        }
                        this.clearedCaches.add(cache);
                        fut.onDone();
                    });
                    this.opFut.add(fut);
                }
                this.jobCtx.holdcc();
                this.opFut.listen(f -> this.jobCtx.callcc());
                this.opFut.markInitialized();
                return null;
            }
            assert (this.opFut.isDone());
            return new ClearCachesTaskResult(this.clearedCaches, this.nonExistentCaches);
        }
    }
}

