/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;

public abstract class VisorServerNodeTask<A, R>
extends VisorOneNodeTask<A, R> {
    private static final long serialVersionUID = 0L;

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<A> arg) {
        List<UUID> argNodeIds = arg.getNodes();
        assert (argNodeIds.size() == 1);
        UUID argNodeId = argNodeIds.get(0);
        DiscoCache discoCache = this.ignite.context().discovery().discoCache();
        ClusterNode argNode = discoCache.node(argNodeId);
        A argument = arg.getArgument();
        if (!argNode.isClient() && !argNode.isDaemon() && this.nodeFilter(argNode, argument)) {
            return argNodeIds;
        }
        ClusterNode srvNode = this.ignite.cluster().forServers().forPredicate(node -> this.nodeFilter((ClusterNode)node, argument)).forRandom().node();
        if (srvNode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(srvNode.id());
    }

    protected boolean nodeFilter(ClusterNode node, A argument) {
        return true;
    }
}

