/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.UUID;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.util.typedef.T2;

public class SqlKillQueryCommand
implements SqlCommand {
    private static final String ASYNC = "ASYNC";
    private long nodeQryId;
    private UUID nodeId;
    private boolean async;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.async = SqlParserUtils.skipIfMatchesOptionalKeyword(lex, ASYNC);
        this.parseGlobalQueryId(lex);
        return this;
    }

    private void parseGlobalQueryId(SqlLexer lex) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
            String tok = lex.token();
            T2<UUID, Long> ids = SqlKillQueryCommand.parseGlobalQueryId(tok);
            if (ids == null) {
                throw SqlParserUtils.error(lex, "Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
            }
            this.nodeId = (UUID)ids.get1();
            this.nodeQryId = (Long)ids.get2();
            return;
        }
        if (this.async) {
            throw SqlParserUtils.error(lex, "Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
        }
        throw SqlParserUtils.error(lex, "Expected ASYNC token or global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
    }

    public static T2<UUID, Long> parseGlobalQueryId(String globalQryId) {
        String[] ids = globalQryId.split("_");
        if (ids.length != 2) {
            return null;
        }
        try {
            return new T2<UUID, Long>(UUID.fromString(ids[0]), Long.parseLong(ids[1]));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
    }

    public long nodeQueryId() {
        return this.nodeQryId;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public boolean async() {
        return this.async;
    }
}

