/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing;

import org.apache.ignite.spi.tracing.Scope;

public enum SpanType {
    DISCOVERY_NODE_JOIN_REQUEST(Scope.DISCOVERY, "discovery.node.join.request", 1, true),
    DISCOVERY_NODE_JOIN_ADD(Scope.DISCOVERY, "discovery.node.join.add", 2),
    DISCOVERY_NODE_JOIN_FINISH(Scope.DISCOVERY, "discovery.node.join.finish", 3),
    DISCOVERY_NODE_FAILED(Scope.DISCOVERY, "discovery.node.failed", 4, true),
    DISCOVERY_NODE_LEFT(Scope.DISCOVERY, "discovery.node.left", 5, true),
    DISCOVERY_CUSTOM_EVENT(Scope.DISCOVERY, "discovery.custom.event", 6, true),
    EXCHANGE_FUTURE(Scope.DISCOVERY, "exchange.future", 7, true),
    AFFINITY_CALCULATION(Scope.DISCOVERY, "affinity.calculation", 8),
    COMMUNICATION_JOB_EXECUTE_REQUEST(Scope.COMMUNICATION, "communication.job.execute.request", 9),
    COMMUNICATION_JOB_EXECUTE_RESPONSE(Scope.COMMUNICATION, "communication.job.execute.response", 10),
    COMMUNICATION_SOCKET_WRITE(Scope.COMMUNICATION, "socket.write", 11, true),
    COMMUNICATION_SOCKET_READ(Scope.COMMUNICATION, "socket.read", 12),
    COMMUNICATION_REGULAR_PROCESS(Scope.COMMUNICATION, "process.regular", 13),
    COMMUNICATION_ORDERED_PROCESS(Scope.COMMUNICATION, "process.ordered", 14),
    TX(Scope.TX, "transaction", 15, true),
    TX_COMMIT(Scope.TX, "transactions.commit", 16),
    TX_ROLLBACK(Scope.TX, "transactions.rollback", 17),
    TX_CLOSE(Scope.TX, "transactions.close", 18),
    TX_SUSPEND(Scope.TX, "transactions.suspend", 19),
    TX_RESUME(Scope.TX, "transactions.resume", 20),
    TX_NEAR_PREPARE(Scope.TX, "transactions.near.prepare", 21),
    TX_NEAR_PREPARE_ON_DONE(Scope.TX, "transactions.near.prepare.ondone", 22),
    TX_NEAR_PREPARE_ON_ERROR(Scope.TX, "transactions.near.prepare.onerror", 23),
    TX_NEAR_PREPARE_ON_TIMEOUT(Scope.TX, "transactions.near.prepare.ontimeout", 24),
    TX_DHT_PREPARE(Scope.TX, "transactions.dht.prepare", 25),
    TX_DHT_PREPARE_ON_DONE(Scope.TX, "transactions.dht.prepare.ondone", 26),
    TX_NEAR_FINISH(Scope.TX, "transactions.near.finish", 27),
    TX_NEAR_FINISH_ON_DONE(Scope.TX, "transactions.near.finish.ondone", 28),
    TX_DHT_FINISH(Scope.TX, "transactions.dht.finish", 29),
    TX_DHT_FINISH_ON_DONE(Scope.TX, "transactions.dht.finish.ondone", 30),
    TX_MAP_PROCEED(Scope.TX, "transactions.lock.map.proceed", 31),
    TX_COLOCATED_LOCK_MAP(Scope.TX, "transactions.colocated.lock.map", 32),
    TX_DHT_LOCK_MAP(Scope.TX, "transactions.dht.lock.map", 33),
    TX_NEAR_ENLIST_READ(Scope.TX, "transactions.near.enlist.read", 34),
    TX_NEAR_ENLIST_WRITE(Scope.TX, "transactions.near.enlist.write", 35),
    TX_PROCESS_DHT_PREPARE_REQ(Scope.TX, "tx.dht.process.prepare.req", 36),
    TX_PROCESS_DHT_FINISH_REQ(Scope.TX, "tx.dht.process.finish.req", 37),
    TX_PROCESS_DHT_FINISH_RESP(Scope.TX, "tx.dht.process.finish.resp", 38),
    TX_PROCESS_DHT_ONE_PHASE_COMMIT_ACK_REQ(Scope.TX, "tx.dht.process.one-phase-commit-ack.req", 39),
    TX_PROCESS_DHT_PREPARE_RESP(Scope.TX, "tx.dht.process.prepare.response", 40),
    TX_NEAR_FINISH_REQ(Scope.TX, "tx.near.process.finish.request", 41),
    TX_NEAR_FINISH_RESP(Scope.TX, "tx.near.process.finish.response", 42),
    TX_NEAR_PREPARE_REQ(Scope.TX, "tx.near.process.prepare.request", 43),
    TX_NEAR_PREPARE_RESP(Scope.TX, "tx.near.process.prepare.response", 44),
    CUSTOM_JOB_CALL(Scope.COMMUNICATION, "job.call", 45, true),
    CACHE_API_PUT(Scope.CACHE_API_WRITE, "cache.api.put", 46, true),
    CACHE_API_PUT_ALL(Scope.CACHE_API_WRITE, "cache.api.put.all", 47, true),
    CACHE_API_PUT_ASYNC(Scope.CACHE_API_WRITE, "cache.api.put.async", 48, true),
    CACHE_API_PUT_ALL_ASYNC(Scope.CACHE_API_WRITE, "cache.api.put.all.async", 49, true),
    CACHE_API_REMOVE(Scope.CACHE_API_WRITE, "cache.api.remove", 50, true),
    CACHE_API_REMOVE_ALL(Scope.CACHE_API_WRITE, "cache.api.remove.all", 51, true),
    CACHE_API_REMOVE_ASYNC(Scope.CACHE_API_WRITE, "cache.api.remove.async", 52, true),
    CACHE_API_REMOVE_ALL_ASYNC(Scope.CACHE_API_WRITE, "cache.api.remove.all.async", 53, true),
    CACHE_API_NEAR_PROCESS_ATOMIC_UPDATE_REQUEST(Scope.CACHE_API_WRITE, "cache.api.near.process.atomic.update.request", 54, false),
    CACHE_API_NEAR_PROCESS_ATOMIC_UPDATE_RESPONSE(Scope.CACHE_API_WRITE, "cache.api.near.process.atomic.update.response", 55, false),
    CACHE_API_DHT_PROCESS_ATOMIC_UPDATE_REQUEST(Scope.CACHE_API_WRITE, "cache.api.dht.process.atomic.update.request", 56, false),
    CACHE_API_DHT_PROCESS_ATOMIC_UPDATE_RESPONSE(Scope.CACHE_API_WRITE, "cache.api.dht.process.atomic.update.response", 57, false),
    CACHE_API_DHT_PROCESS_ATOMIC_NEAR_RESPONSE(Scope.CACHE_API_WRITE, "cache.api.dht.process.atomic.near.response", 58, false),
    CACHE_API_PROCESS_CHECK_UPDATE_REQUEST(Scope.CACHE_API_WRITE, "cache.api.process.check.update.request", 59, false),
    CACHE_API_DHT_PROCESS_ATOMIC_DEFERRED_UPDATE_RESPONSE(Scope.CACHE_API_WRITE, "cache.api.dht.process.atomic.deferred.update.response", 60, false),
    CACHE_API_DHT_UPDATE_FUTURE(Scope.CACHE_API_WRITE, "cache.api.dht.update.future", 61, false),
    CACHE_API_UPDATE_MAP(Scope.CACHE_API_WRITE, "cache.api.update.map", 62, false),
    CACHE_API_NEAR_UPDATE_FUTURE(Scope.CACHE_API_WRITE, "cache.api.near.update.future", 63, false),
    CACHE_API_NEAR_UPDATE_PRIMARY_FAILED_RESPONSE(Scope.CACHE_API_WRITE, "cache.api.near.atomic.primary.failed.response", 64, false),
    CACHE_API_GET(Scope.CACHE_API_READ, "cache.api.get", 65, true),
    CACHE_API_GET_ALL(Scope.CACHE_API_READ, "cache.api.get.all", 66, true),
    CACHE_API_GET_ASYNC(Scope.CACHE_API_READ, "cache.api.get.async", 67, true),
    CACHE_API_GET_ALL_ASYNC(Scope.CACHE_API_READ, "cache.api.get.all.async", 68, true),
    CACHE_API_NEAR_GET_FUTURE(Scope.CACHE_API_READ, "cache.api.near.get.future", 69, false),
    CACHE_API_PARTITIONED_GET_FUTURE(Scope.CACHE_API_READ, "cache.api.partitioned.get.future", 70, false),
    CACHE_API_PARTITIONED_SINGLE_GET_FUTURE(Scope.CACHE_API_READ, "cache.api.partitioned.single.get.future", 71, false),
    CACHE_API_DHT_GET_FUTURE(Scope.CACHE_API_READ, "cache.api.dht.get.future", 72, false),
    CACHE_API_DHT_SINGLE_GET_FUTURE(Scope.CACHE_API_READ, "cache.api.dht.single.get.future", 73, false),
    CACHE_API_GET_MAP(Scope.CACHE_API_READ, "cache.api.get.map", 74, false),
    CACHE_API_NEAR_PROCESS_ATOMIC_GET_REQUEST(Scope.CACHE_API_READ, "cache.api.near.atomic.get.request", 75, false),
    CACHE_API_NEAR_PROCESS_ATOMIC_GET_RESPONSE(Scope.CACHE_API_READ, "cache.api.near.atomic.get.response", 76, false),
    CACHE_API_NEAR_PROCESS_ATOMIC_SINGLE_GET_REQUEST(Scope.CACHE_API_READ, "cache.api.near.atomic.single.get.request", 77, false),
    CACHE_API_NEAR_PROCESS_ATOMIC_SINGLE_GET_RESPONSE(Scope.CACHE_API_READ, "cache.api.near.atomic.single.get.response", 78, false),
    SQL_QRY(Scope.SQL, "sql.query", 79, true),
    SQL_CURSOR_OPEN(Scope.SQL, "sql.cursor.open", 80),
    SQL_CURSOR_CLOSE(Scope.SQL, "sql.cursor.close", 81),
    SQL_CURSOR_CANCEL(Scope.SQL, "sql.cursor.cancel", 82),
    SQL_QRY_PARSE(Scope.SQL, "sql.query.parse", 83),
    SQL_QRY_EXEC_REQ(Scope.SQL, "sql.query.execute.request", 84),
    SQL_NEXT_PAGE_REQ(Scope.SQL, "sql.next.page.request", 85),
    SQL_PAGE_RESP(Scope.SQL, "sql.page.response", 86),
    SQL_QRY_EXECUTE(Scope.SQL, "sql.query.execute", 87),
    SQL_PAGE_PREPARE(Scope.SQL, "sql.page.prepare", 88),
    SQL_FAIL_RESP(Scope.SQL, "sql.fail.response", 89),
    SQL_DML_QRY_EXEC_REQ(Scope.SQL, "sql.dml.query.execute.request", 90),
    SQL_DML_QRY_RESP(Scope.SQL, "sql.dml.query.response", 91),
    SQL_QRY_CANCEL_REQ(Scope.SQL, "sql.query.cancel.request", 92),
    SQL_ITER_OPEN(Scope.SQL, "sql.iterator.open", 93),
    SQL_ITER_CLOSE(Scope.SQL, "sql.iterator.close", 94),
    SQL_PAGE_FETCH(Scope.SQL, "sql.page.fetch", 95),
    SQL_PAGE_WAIT(Scope.SQL, "sql.page.wait", 96),
    SQL_IDX_RANGE_REQ(Scope.SQL, "sql.index.range.request", 97),
    SQL_IDX_RANGE_RESP(Scope.SQL, "sql.index.range.response", 98),
    SQL_DML_QRY_EXECUTE(Scope.SQL, "sql.dml.query.execute", 99),
    SQL_CMD_QRY_EXECUTE(Scope.SQL, "sql.command.query.execute", 100),
    SQL_PARTITIONS_RESERVE(Scope.SQL, "sql.partitions.reserve", 101),
    SQL_CACHE_UPDATE(Scope.SQL, "sql.cache.update", 102),
    SQL_BATCH_PROCESS(Scope.SQL, "sql.batch.process", 103),
    SQL_QRY_MAP_END(Scope.SQL, "sql.query.map.end", 104);

    private final Scope scope;
    private final String spanName;
    private final int idx;
    private static final SpanType[] VALS;
    private boolean rootSpan;

    private SpanType(Scope scope, String spanName, int idx) {
        this.scope = scope;
        this.spanName = spanName;
        this.idx = idx;
    }

    private SpanType(Scope scope, String spanName, int idx, boolean rootSpan) {
        this(scope, spanName, idx);
        this.rootSpan = rootSpan;
    }

    public Scope scope() {
        return this.scope;
    }

    public String spanName() {
        return this.spanName;
    }

    public int index() {
        return this.idx;
    }

    public boolean rootSpan() {
        return this.rootSpan;
    }

    public static SpanType fromIndex(int idx) {
        return idx < 0 || idx >= VALS.length ? null : VALS[idx];
    }

    static {
        SpanType[] spanTypes = SpanType.values();
        int maxIdx = 0;
        for (SpanType spanType : spanTypes) {
            maxIdx = Math.max(maxIdx, spanType.idx);
        }
        VALS = new SpanType[maxIdx + 1];
        SpanType[] spanTypeArray = spanTypes;
        int n = spanTypeArray.length;
        for (int i = 0; i < n; ++i) {
            SpanType spanType;
            SpanType.VALS[spanType.idx] = spanType = spanTypeArray[i];
        }
    }
}

