/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.ru;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.ru.RollingUpgradeStatus;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;

public class IgniteRollingUpgradeStatus
extends IgniteDataTransferObject
implements RollingUpgradeStatus {
    private static final long serialVersionUID = 0L;
    private boolean enabled;
    private boolean forcedModeEnabled;
    private IgniteProductVersion initVer;
    private IgniteProductVersion updateVer;
    private byte[] supportedFeatures;

    public IgniteRollingUpgradeStatus() {
    }

    public IgniteRollingUpgradeStatus(boolean enabled, boolean forcedModeEnabled, IgniteProductVersion initVer, IgniteProductVersion updateVer, byte[] supportedFeatures) {
        assert (enabled || !forcedModeEnabled) : "Forced mode cannot be enabled if Rolling Upgrade is disabled.";
        this.enabled = enabled;
        this.forcedModeEnabled = forcedModeEnabled;
        this.initVer = initVer;
        this.updateVer = updateVer;
        this.supportedFeatures = supportedFeatures;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean forcedModeEnabled() {
        return this.forcedModeEnabled;
    }

    @Override
    public IgniteProductVersion initialVersion() {
        return this.initVer;
    }

    @Override
    public IgniteProductVersion targetVersion() {
        return this.updateVer;
    }

    public byte[] supportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.forcedModeEnabled);
        out.writeObject(this.initVer);
        out.writeObject(this.updateVer);
        out.writeObject(new HashSet());
        out.writeObject(this.supportedFeatures);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.enabled = in.readBoolean();
        this.forcedModeEnabled = in.readBoolean();
        this.initVer = (IgniteProductVersion)in.readObject();
        this.updateVer = (IgniteProductVersion)in.readObject();
        in.readObject();
        if (protoVer >= 2) {
            this.supportedFeatures = (byte[])in.readObject();
        }
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public String toString() {
        return S.toString(IgniteRollingUpgradeStatus.class, this);
    }
}

