/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.VectorQuery;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRequest;

public class ClientVectorQueryRequest
extends ClientCacheRequest {
    private final int pageSize;
    private final VectorQuery qry;

    public ClientVectorQueryRequest(BinaryRawReader reader) {
        super(reader);
        this.pageSize = reader.readInt();
        String type = reader.readString();
        String field = reader.readString();
        float[] clauseVector = reader.readFloatArray();
        int k = reader.readInt();
        float threshold = reader.readFloat();
        this.qry = new VectorQuery(type, field, clauseVector, k, threshold);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache<Object, Object> cache = this.cache(ctx);
        try {
            QueryCursor<Cache.Entry> cur = cache.query(this.qry);
            ClientCacheEntryQueryCursor cliCur = new ClientCacheEntryQueryCursor(cur, this.pageSize, ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheQueryResponse(this.requestId(), cliCur);
        }
        catch (Throwable e) {
            ctx.decrementCursors();
            throw e;
        }
    }
}

