/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.binary;

import java.util.Collection;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public class ClientBinaryTypesGetResponse
extends ClientResponse {
    private final Collection<BinaryType> types;

    ClientBinaryTypesGetResponse(long reqId, Collection<BinaryType> types) {
        super(reqId);
        this.types = types;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        writer.writeInt(this.types.size());
        for (BinaryType type : this.types) {
            BinaryTypeImpl typeImpl = (BinaryTypeImpl)type;
            BinaryMetadata meta = typeImpl.metadata();
            PlatformUtils.writeBinaryMetadata(writer, meta, false);
        }
    }
}

