/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.binary;

import java.util.HashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformBinaryProcessor
extends PlatformAbstractTarget {
    private static final int OP_GET_META = 1;
    private static final int OP_GET_ALL_META = 2;
    private static final int OP_PUT_META = 3;
    private static final int OP_GET_SCHEMA = 4;
    private static final int OP_REGISTER_TYPE = 5;
    private static final int OP_GET_TYPE = 6;
    private static final int OP_REGISTER_ENUM = 7;
    private static final int OP_GET_META_WITH_SCHEMAS = 8;
    private static final int OP_REMOVE_TYPE = 9;

    public PlatformBinaryProcessor(PlatformContext platformCtx) {
        super(platformCtx);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                this.platformCtx.processMetadata(reader);
                return 1L;
            }
            case 5: {
                int res;
                int typeId = reader.readInt();
                String typeName = reader.readString();
                boolean registerSameJavaType = reader.readBoolean();
                int n = res = this.platformContext().kernalContext().marshallerContext().registerClassName((byte)1, typeId, typeName, false) ? 1 : 0;
                if (registerSameJavaType && res == 1) {
                    res = this.platformContext().kernalContext().marshallerContext().registerClassName((byte)0, typeId, typeName, false) ? 1 : 0;
                }
                return res;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 2) {
            this.platformCtx.writeAllMetadata(writer);
        } else {
            super.processOutStream(type, writer);
        }
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                int typeId = reader.readInt();
                this.platformCtx.writeMetadata(writer, typeId, false);
                break;
            }
            case 8: {
                int typeId = reader.readInt();
                this.platformCtx.writeMetadata(writer, typeId, true);
                break;
            }
            case 4: {
                int typeId = reader.readInt();
                int schemaId = reader.readInt();
                this.platformCtx.writeSchema(writer, typeId, schemaId);
                break;
            }
            case 6: {
                int typeId = reader.readInt();
                byte platformId = reader.readByte();
                try {
                    String typeName = this.platformContext().kernalContext().marshallerContext().getClassName(platformId, typeId);
                    writer.writeString(typeName);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new BinaryObjectException(e);
                }
            }
            case 7: {
                String name = reader.readString();
                int cnt = reader.readInt();
                HashMap<String, Integer> vals = new HashMap<String, Integer>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    vals.put(reader.readString(), reader.readInt());
                }
                BinaryType binaryType = this.platformCtx.kernalContext().grid().binary().registerEnum(name, vals);
                this.platformCtx.writeMetadata(writer, binaryType.typeId(), false);
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 9: {
                this.platformCtx.kernalContext().cacheObjects().binary().removeType((int)val);
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }
}

