/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV2;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV3;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMetaV4;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.processors.query.ColumnInformation;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.TableInformation;
import org.jetbrains.annotations.Nullable;

public class JdbcMetadataInfo {
    private final GridKernalContext ctx;
    private static final Comparator<ColumnInformation> bySchemaThenTabNameThenColOrder = new Comparator<ColumnInformation>(){

        @Override
        public int compare(ColumnInformation o1, ColumnInformation o2) {
            int schemaCmp = o1.schemaName().compareTo(o2.schemaName());
            if (schemaCmp != 0) {
                return schemaCmp;
            }
            int tblNameCmp = o1.tableName().compareTo(o2.tableName());
            if (tblNameCmp != 0) {
                return tblNameCmp;
            }
            return Integer.compare(o1.columnId(), o2.columnId());
        }
    };
    private static final Comparator<TableInformation> byTblTypeThenSchemaThenTblName = new Comparator<TableInformation>(){

        @Override
        public int compare(TableInformation o1, TableInformation o2) {
            int tblTypeCmp = o1.tableType().compareTo(o2.tableType());
            if (tblTypeCmp != 0) {
                return tblTypeCmp;
            }
            int schemCmp = o1.schemaName().compareTo(o2.schemaName());
            if (schemCmp != 0) {
                return schemCmp;
            }
            return o1.tableName().compareTo(o2.tableName());
        }
    };

    public JdbcMetadataInfo(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public Collection<JdbcPrimaryKeyMeta> getPrimaryKeys(String schemaNamePtrn, String tblNamePtrn) {
        HashSet<JdbcPrimaryKeyMeta> meta = new HashSet<JdbcPrimaryKeyMeta>();
        for (String cacheName : this.ctx.cache().publicCacheNames()) {
            for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                String keyName;
                if (!QueryUtils.matches(table.schemaName(), schemaNamePtrn) || !QueryUtils.matches(table.tableName(), tblNamePtrn)) continue;
                ArrayList<String> fields = new ArrayList<String>();
                for (String field : table.fields().keySet()) {
                    if (!table.property(field).key()) continue;
                    fields.add(field);
                }
                String string = keyName = table.keyFieldName() == null ? "PK_" + table.schemaName() + "_" + table.tableName() : table.keyFieldName();
                if (fields.isEmpty()) {
                    String keyColName = table.keyFieldName() == null ? "_KEY" : table.keyFieldName();
                    meta.add(new JdbcPrimaryKeyMeta(table.schemaName(), table.tableName(), keyName, Collections.singletonList(keyColName)));
                    continue;
                }
                meta.add(new JdbcPrimaryKeyMeta(table.schemaName(), table.tableName(), keyName, fields));
            }
        }
        return meta;
    }

    public List<JdbcTableMeta> getTablesMeta(String schemaNamePtrn, String tblNamePtrn, String[] tblTypes) {
        Collection<TableInformation> tblsMeta = this.ctx.query().getIndexing().tablesInformation(schemaNamePtrn, tblNamePtrn, tblTypes);
        return tblsMeta.stream().sorted(byTblTypeThenSchemaThenTblName).map(t -> new JdbcTableMeta(t.schemaName(), t.tableName(), t.tableType())).collect(Collectors.toList());
    }

    public Collection<JdbcColumnMeta> getColumnsMeta(@Nullable ClientListenerProtocolVersion protoVer, String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        boolean useNewest = protoVer == null;
        LinkedHashSet<JdbcColumnMeta> metas = new LinkedHashSet<JdbcColumnMeta>();
        Collection<ColumnInformation> colsInfo = this.ctx.query().getIndexing().columnsInformation(schemaNamePtrn, tblNamePtrn, colNamePtrn);
        colsInfo.stream().sorted(bySchemaThenTabNameThenColOrder).forEachOrdered(info -> {
            JdbcColumnMeta colMeta = useNewest || protoVer.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0 ? new JdbcColumnMetaV4(info.schemaName(), info.tableName(), info.columnName(), info.fieldClass(), info.nullable(), info.defaultValue(), info.precision(), info.scale()) : (protoVer.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0 ? new JdbcColumnMetaV3(info.schemaName(), info.tableName(), info.columnName(), info.fieldClass(), info.nullable(), info.defaultValue()) : (protoVer.compareTo(JdbcConnectionContext.VER_2_3_0) >= 0 ? new JdbcColumnMetaV2(info.schemaName(), info.tableName(), info.columnName(), info.fieldClass(), info.nullable()) : new JdbcColumnMeta(info.schemaName(), info.tableName(), info.columnName(), info.fieldClass())));
            if (!metas.contains(colMeta)) {
                metas.add(colMeta);
            }
        });
        return metas;
    }

    public SortedSet<String> getSchemasMeta(String schemaNamePtrn) {
        TreeSet<String> schemas = new TreeSet<String>();
        for (String schema : this.ctx.query().getIndexing().schemasNames()) {
            if (!QueryUtils.matches(schema, schemaNamePtrn)) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public SortedSet<JdbcIndexMeta> getIndexesMeta(String schemaNamePtrn, String tblNamePtrn) {
        Comparator<JdbcIndexMeta> byIndexName = new Comparator<JdbcIndexMeta>(){

            @Override
            public int compare(JdbcIndexMeta o1, JdbcIndexMeta o2) {
                int schemaCmp = o1.schemaName().compareTo(o2.schemaName());
                if (schemaCmp != 0) {
                    return schemaCmp;
                }
                int tableCmp = o1.tableName().compareTo(o2.tableName());
                if (tableCmp != 0) {
                    return tableCmp;
                }
                return o1.indexName().compareTo(o2.indexName());
            }
        };
        TreeSet<JdbcIndexMeta> meta = new TreeSet<JdbcIndexMeta>(byIndexName);
        for (String cacheName : this.ctx.cache().publicCacheNames()) {
            for (GridQueryTypeDescriptor table : this.ctx.query().types(cacheName)) {
                if (!QueryUtils.matches(table.schemaName(), schemaNamePtrn) || !QueryUtils.matches(table.tableName(), tblNamePtrn)) continue;
                for (GridQueryIndexDescriptor idxDesc : table.indexes().values()) {
                    meta.add(new JdbcIndexMeta(table.schemaName(), table.tableName(), idxDesc));
                }
            }
        }
        return meta;
    }
}

