/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.mxbean.MetricsMxBean;

public class MetricsMxBeanImpl
implements MetricsMxBean {
    private final GridMetricManager mmgr;
    private final IgniteLogger log;

    public MetricsMxBeanImpl(GridMetricManager mmgr, IgniteLogger log) {
        this.mmgr = mmgr;
        this.log = log;
    }

    @Override
    public void resetMetrics(String registry) {
        assert (registry != null);
        MetricRegistry mreg = this.mmgr.registry(registry);
        if (mreg != null) {
            mreg.reset();
        } else if (this.log.isInfoEnabled()) {
            this.log.info("\"" + registry + "\" not found.");
        }
    }

    @Override
    public void configureHitRateMetric(String name, long rateTimeInterval) {
        try {
            this.mmgr.configureHitRate(name, rateTimeInterval);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void configureHistogramMetric(String name, long[] bounds) {
        try {
            this.mmgr.configureHistogram(name, bounds);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }
}

