/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.diagnostic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedDataStructureException;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentRouter;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.diagnostic.ReconciliationExecutionContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class DiagnosticProcessor
extends GridProcessorAdapter {
    public static final boolean DFLT_DUMP_PAGE_LOCK_ON_FAILURE = true;
    private static final boolean IGNITE_DUMP_PAGE_LOCK_ON_FAILURE = IgniteSystemProperties.getBoolean("IGNITE_DUMP_PAGE_LOCK_ON_FAILURE", true);
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'_'HH-mm-ss_SSS");
    public static final String DEFAULT_TARGET_FOLDER = "diagnostic";
    private final Path diagnosticPath;
    private final ReconciliationExecutionContext reconciliationExecutionContext;
    @Nullable
    private final FileIOFactory fileIOFactory;
    private final boolean dumpPersistenceFilesOnDataCorruption = IgniteSystemProperties.getBoolean("IGNITE_DUMP_PERSISTENCE_FILES_ON_DATA_CORRUPTION");

    public DiagnosticProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        this.diagnosticPath = U.resolveWorkDirectory(ctx.config().getWorkDirectory(), DEFAULT_TARGET_FOLDER, false).toPath();
        this.reconciliationExecutionContext = new ReconciliationExecutionContext(ctx);
        this.fileIOFactory = GridCacheUtils.isPersistenceEnabled(ctx.config()) ? ctx.config().getDataStorageConfiguration().getFileIOFactory() : null;
    }

    public void onFailure(FailureContext failureCtx) {
        CorruptedDataStructureException corruptedDataStructureEx;
        if (IGNITE_DUMP_PAGE_LOCK_ON_FAILURE) {
            this.ctx.cache().context().diagnostic().pageLockTracker().dumpLocksToLog();
        }
        if ((corruptedDataStructureEx = X.cause(failureCtx.error(), CorruptedDataStructureException.class)) != null && !F.isEmpty(corruptedDataStructureEx.pageIds()) && this.fileIOFactory != null) {
            File[] walDirs = DiagnosticProcessor.walDirs(this.ctx);
            if (F.isEmpty(walDirs)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Skipping dump diagnostic info due to WAL not configured");
                }
            } else {
                try {
                    File corruptedPagesFile = DiagnosticProcessor.corruptedPagesFile(this.diagnosticPath, this.fileIOFactory, corruptedDataStructureEx.groupId(), corruptedDataStructureEx.pageIds());
                    String walDirsStr = Arrays.stream(walDirs).map(File::getAbsolutePath).collect(Collectors.joining(", ", "[", "]"));
                    String args = "--wal-dir " + walDirs[0].getAbsolutePath() + (walDirs.length == 1 ? "" : " --wal-archive-dir " + walDirs[1].getAbsolutePath());
                    if (this.ctx.config().getDataStorageConfiguration().getPageSize() != 4096) {
                        args = args + " --page-size " + this.ctx.config().getDataStorageConfiguration().getPageSize();
                    }
                    args = args + " --pages " + corruptedPagesFile.getAbsolutePath();
                    this.log.warning(corruptedDataStructureEx.getClass().getSimpleName() + " has occurred. To diagnose it, make a backup of the following directories: " + walDirsStr + ". Then, run the following command: bin/wal-reader.sh " + args);
                }
                catch (Throwable t) {
                    String pages = LongStream.of(corruptedDataStructureEx.pageIds()).mapToObj(pageId -> corruptedDataStructureEx.groupId() + ":" + pageId).collect(Collectors.joining("\n", "", ""));
                    this.log.error("Failed to dump diagnostic info of partition corruption. Page ids:\n" + pages, t);
                }
            }
        }
        if (this.dumpPersistenceFilesOnDataCorruption && corruptedDataStructureEx != null) {
            this.log.warning("Copying persistence files to dump folder.");
            this.dumpPersistenceFilesOnFailure(corruptedDataStructureEx);
        }
    }

    File getBaseDumpDir() throws IgniteCheckedException {
        Serializable consistentId = this.ctx.config().getConsistentId();
        String path = "db/dump/" + U.maskForFileName(String.valueOf(consistentId));
        return U.resolveWorkDirectory(this.ctx.config().getWorkDirectory(), path, false);
    }

    private void dumpPersistenceFilesOnFailure(CorruptedDataStructureException ex) {
        IgniteCacheDatabaseSharedManager dbSharedManager;
        IgnitePageStoreManager storeManager;
        IgniteCacheObjectProcessor processor;
        File baseDumpDir;
        try {
            baseDumpDir = this.getBaseDumpDir();
        }
        catch (IgniteCheckedException e) {
            this.log.error("Unable to resolve dump directory", e);
            return;
        }
        EncryptionSpi encSpi = this.ctx.config().getEncryptionSpi();
        if (encSpi instanceof KeystoreEncryptionSpi) {
            this.dumpEncryptionKeys((KeystoreEncryptionSpi)encSpi, baseDumpDir);
        }
        if ((processor = this.ctx.cacheObjects()) instanceof CacheObjectBinaryProcessorImpl) {
            ((CacheObjectBinaryProcessorImpl)processor).dumpMetadata(baseDumpDir);
        }
        this.dumpLogs(baseDumpDir);
        IgniteWriteAheadLogManager wal = this.ctx.cache().context().wal();
        if (wal instanceof FileWriteAheadLogManager) {
            ((FileWriteAheadLogManager)wal).dumpWalFiles(baseDumpDir);
        }
        if ((storeManager = this.ctx.cache().context().pageStore()) instanceof FilePageStoreManager) {
            ((FilePageStoreManager)storeManager).dumpPartitionFiles(baseDumpDir, ex.groupId(), ex.pageIds());
            ((FilePageStoreManager)storeManager).dumpUtilityCache(baseDumpDir);
        }
        if ((dbSharedManager = this.ctx.cache().context().database()) instanceof GridCacheDatabaseSharedManager) {
            ((GridCacheDatabaseSharedManager)dbSharedManager).dumpMetaStorageAndCheckpoints(baseDumpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpEncryptionKeys(KeystoreEncryptionSpi encSpi, File baseDumpDir) {
        InputStream jksInputStream = null;
        try {
            URL clsPthRes;
            File dumpDir = new File(baseDumpDir, "jks");
            dumpDir.mkdirs();
            this.log.warning("Sensitive encryption information is being collected into " + dumpDir.getAbsolutePath() + " in order to make further corruption analysis possible.");
            String keyStorePath = encSpi.getKeyStorePath();
            File absolutePathKeyStoreFile = new File(keyStorePath);
            if (absolutePathKeyStoreFile.exists()) {
                jksInputStream = new FileInputStream(absolutePathKeyStoreFile);
            }
            if (jksInputStream == null && (clsPthRes = KeystoreEncryptionSpi.class.getClassLoader().getResource(keyStorePath)) != null) {
                jksInputStream = clsPthRes.openStream();
            }
            if (jksInputStream != null) {
                DiagnosticProcessor.writeStreamToFile(jksInputStream, new File(dumpDir, "keystore.jks"));
            }
            String extras = String.format("keySize=%d\nkeyStorePassword=%s\nmasterKeyName=%s", encSpi.getKeySize(), new String(encSpi.getKeyStorePwd()), encSpi.getMasterKeyName());
            DiagnosticProcessor.writeStreamToFile(new ByteArrayInputStream(extras.getBytes(StandardCharsets.UTF_8)), new File(dumpDir, "extras.txt"));
        }
        catch (Throwable t) {
            if (jksInputStream != null) {
                try {
                    jksInputStream.close();
                }
                catch (Throwable e) {
                    t.addSuppressed(e);
                }
                jksInputStream = null;
            }
            this.log.error("Failed to dump encryption keys.", t);
        }
        finally {
            if (jksInputStream != null) {
                try {
                    jksInputStream.close();
                }
                catch (Throwable t) {
                    this.log.error("Failed to close JKS input stream.", t);
                }
            }
        }
    }

    private void dumpLogs(File baseDumpDir) {
        try {
            File logDir = U.resolveWorkDirectory(this.ctx.config().getWorkDirectory(), "log", false);
            if (logDir.exists() && logDir.isDirectory()) {
                File dumpDir = new File(baseDumpDir, "log");
                for (File logFile : logDir.listFiles()) {
                    U.copy(logFile, new File(dumpDir, logFile.getName()), false);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to dump logs.", e);
        }
    }

    private static void writeStreamToFile(InputStream in, File outFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outFile);){
            U.copy(in, out);
            out.getFD().sync();
        }
    }

    public ReconciliationExecutionContext reconciliationExecutionContext() {
        return this.reconciliationExecutionContext;
    }

    public static File corruptedPagesFile(Path dirPath, FileIOFactory ioFactory, int grpId, long ... pageIds) throws IOException {
        dirPath.toFile().mkdirs();
        File f = dirPath.resolve("corruptedPages_" + LocalDateTime.now().format(TIME_FORMATTER) + ".txt").toFile();
        assert (!f.exists());
        try (FileIO fileIO = ioFactory.create(f);){
            for (long pageId : pageIds) {
                byte[] bytes = (grpId + ":" + pageId + U.nl()).getBytes(StandardCharsets.UTF_8);
                int left = bytes.length;
                while (left - fileIO.writeFully(bytes, bytes.length - left, left) > 0) {
                }
            }
            fileIO.force();
        }
        return f;
    }

    @Nullable
    static File[] walDirs(GridKernalContext ctx) {
        SegmentRouter sr;
        IgniteWriteAheadLogManager walMgr = ctx.cache().context().wal();
        if (walMgr instanceof FileWriteAheadLogManager && (sr = ((FileWriteAheadLogManager)walMgr).getSegmentRouter()) != null) {
            File workDir = sr.getWalWorkDir();
            return sr.hasArchive() ? F.asArray(workDir, sr.getWalArchiveDir()) : F.asArray(workDir);
        }
        return null;
    }
}

