/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicStampedValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheAtomicStampedImpl<T, S>
extends AtomicDataStructureProxy<GridCacheAtomicStampedValue<T, S>>
implements GridCacheAtomicStampedEx<T, S>,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };

    public GridCacheAtomicStampedImpl() {
    }

    public GridCacheAtomicStampedImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>> atomicView) {
        super(name, key, atomicView);
    }

    @Override
    public IgniteBiTuple<T, S> get() {
        this.checkRemoved();
        try {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)this.cacheView.get(this.key);
            if (stmp == null) {
                throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + this.name);
            }
            return stmp.get();
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public void set(final T val, final S stamp) {
        this.checkRemoved();
        try {
            if (this.ctx.dataStructures().knownType(val) && this.ctx.dataStructures().knownType(stamp)) {
                EntryProcessorResult res = this.cacheView.invoke(this.key, new StampedSetEntryProcessor<T, S>(val, stamp), new Object[0]);
                assert (res != null);
                res.get();
            } else {
                CU.retryTopologySafe(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicStampedImpl.this.ctx, GridCacheAtomicStampedImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheAtomicStampedValue ref = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.cacheView.get(GridCacheAtomicStampedImpl.this.key);
                            if (ref == null) {
                                throw new IgniteException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
                            }
                            GridCacheAtomicStampedImpl.this.cacheView.put(GridCacheAtomicStampedImpl.this.key, new GridCacheAtomicStampedValue<Object, Object>(val, stamp));
                            tx.commit();
                        }
                        return null;
                    }
                });
            }
        }
        catch (EntryProcessorException | IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public boolean compareAndSet(final T expVal, final T newVal, final S expStamp, final S newStamp) {
        this.checkRemoved();
        try {
            if (this.ctx.dataStructures().knownType(expVal) && this.ctx.dataStructures().knownType(newVal) && this.ctx.dataStructures().knownType(expStamp) && this.ctx.dataStructures().knownType(newStamp)) {
                EntryProcessorResult res = this.cacheView.invoke(this.key, new StampedCompareAndSetEntryProcessor<T, S>(expVal, expStamp, newVal, newStamp), new Object[0]);
                assert (res != null && res.get() != null) : res;
                return (Boolean)res.get();
            }
            return CU.retryTopologySafe(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try (GridNearTxLocal tx = CU.txStartInternal(GridCacheAtomicStampedImpl.this.ctx, GridCacheAtomicStampedImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheAtomicStampedValue val = (GridCacheAtomicStampedValue)GridCacheAtomicStampedImpl.this.cacheView.get(GridCacheAtomicStampedImpl.this.key);
                        if (val == null) {
                            throw new IgniteException("Failed to find atomic stamped with given name: " + GridCacheAtomicStampedImpl.this.name);
                        }
                        if (F.eq(expVal, val.value()) && F.eq(expStamp, val.stamp())) {
                            GridCacheAtomicStampedImpl.this.cacheView.put(GridCacheAtomicStampedImpl.this.key, new GridCacheAtomicStampedValue<Object, Object>(newVal, newStamp));
                            tx.commit();
                            Boolean bl = true;
                            return bl;
                        }
                        Boolean bl = false;
                        return bl;
                    }
                }
            });
        }
        catch (EntryProcessorException | IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public S stamp() {
        this.checkRemoved();
        try {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)this.cacheView.get(this.key);
            if (stmp == null) {
                throw new IgniteException("Failed to find atomic stamped with given name: " + this.name);
            }
            return stmp.stamp();
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public T value() {
        this.checkRemoved();
        try {
            GridCacheAtomicStampedValue stmp = (GridCacheAtomicStampedValue)this.cacheView.get(this.key);
            if (stmp == null) {
                throw new IgniteCheckedException("Failed to find atomic stamped with given name: " + this.name);
            }
            return stmp.value();
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.checkRemovedAfterFail(e);
        }
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicStamped(this.name, this.ctx.group().name());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicStamped<Object, Object> igniteAtomicStamped = t.get1().dataStructures().atomicStamped(t.get2(), null, null, null, false);
            return igniteAtomicStamped;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Atomic stamped was removed from cache: " + this.name);
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridCacheAtomicStampedImpl.class, this);
    }

    static class StampedCompareAndSetEntryProcessor<T, S>
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>, Boolean> {
        private static final long serialVersionUID = 0L;
        private final T expVal;
        private final S expStamp;
        private final T newVal;
        private final S newStamp;

        StampedCompareAndSetEntryProcessor(T expVal, S expStamp, T newVal, S newStamp) {
            this.expVal = expVal;
            this.expStamp = expStamp;
            this.newVal = newVal;
            this.newStamp = newStamp;
        }

        @Override
        public Boolean process(MutableEntry<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>> e, Object ... args) {
            GridCacheAtomicStampedValue val = (GridCacheAtomicStampedValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic stamped with given name: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            if (F.eq(this.expVal, val.value()) && F.eq(this.expStamp, val.stamp())) {
                e.setValue(new GridCacheAtomicStampedValue<T, S>(this.newVal, this.newStamp));
                return true;
            }
            return false;
        }

        public String toString() {
            return GridToStringBuilder.toString(StampedCompareAndSetEntryProcessor.class, this);
        }
    }

    static class StampedSetEntryProcessor<T, S>
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>, Void> {
        private static final long serialVersionUID = 0L;
        private final T newVal;
        private final S newStamp;

        StampedSetEntryProcessor(T newVal, S newStamp) {
            this.newVal = newVal;
            this.newStamp = newStamp;
        }

        @Override
        public Void process(MutableEntry<GridCacheInternalKey, GridCacheAtomicStampedValue<T, S>> e, Object ... args) {
            GridCacheAtomicStampedValue val = (GridCacheAtomicStampedValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic stamped with given name: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            e.setValue(new GridCacheAtomicStampedValue<T, S>(this.newVal, this.newStamp));
            return null;
        }

        public String toString() {
            return GridToStringBuilder.toString(StampedSetEntryProcessor.class, this, super.toString());
        }
    }
}

