/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import org.jetbrains.annotations.Nullable;

public enum RepairAlgorithm {
    LATEST,
    PRIMARY,
    MAJORITY,
    REMOVE,
    PRINT_ONLY,
    LATEST_SKIP_MISSING_PRIMARY,
    LATEST_TRUST_MISSING_PRIMARY;

    private static final RepairAlgorithm[] VALS;

    @Nullable
    public static RepairAlgorithm fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public static RepairAlgorithm fromString(String str) {
        for (RepairAlgorithm val : VALS) {
            if (!val.name().equalsIgnoreCase(str)) continue;
            return val;
        }
        throw new IllegalArgumentException("Invalid repair algorithm [name=" + str + ']');
    }

    public static RepairAlgorithm defaultValue() {
        return PRINT_ONLY;
    }

    static {
        VALS = RepairAlgorithm.values();
    }
}

