/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PartitionReconciliationSkippedEntityHolder<T>
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private T skippedEntity;
    private SkippingReason skippingReason;

    public PartitionReconciliationSkippedEntityHolder() {
    }

    public PartitionReconciliationSkippedEntityHolder(T skippedEntity, SkippingReason skippingReason) {
        this.skippedEntity = skippedEntity;
        this.skippingReason = skippingReason;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.skippedEntity);
        U.writeEnum(out, this.skippingReason);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.skippedEntity = in.readObject();
        this.skippingReason = SkippingReason.fromOrdinal(in.readByte());
    }

    public T skippedEntity() {
        return this.skippedEntity;
    }

    public void skippedEntity(T skippedEntity) {
        this.skippedEntity = skippedEntity;
    }

    public SkippingReason skippingReason() {
        return this.skippingReason;
    }

    public void skippingReason(SkippingReason skippingReason) {
        this.skippingReason = skippingReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReconciliationSkippedEntityHolder that = (PartitionReconciliationSkippedEntityHolder)o;
        return Objects.equals(this.skippedEntity, that.skippedEntity) && this.skippingReason == that.skippingReason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.skippedEntity, this.skippingReason});
    }

    public static enum SkippingReason {
        ENTITY_WITH_TTL("Given entity has ttl enabled."),
        KEY_WAS_NOT_REPAIRED("Key was not repaired. Repair attempts were over."),
        LOST_PARTITION("The partition does not have any owner (it is possible that the partition is lost).");

        private String reason;
        private static final SkippingReason[] VALS;

        private SkippingReason(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }

        @Nullable
        public static SkippingReason fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = SkippingReason.values();
        }
    }
}

