/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxImplicitSingleStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteTxLocalAdapter
extends IgniteTxAdapter
implements IgniteTxLocalEx {
    private static final long serialVersionUID = 0L;
    protected static final AtomicReferenceFieldUpdater<IgniteTxLocalAdapter, Throwable> COMMIT_ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(IgniteTxLocalAdapter.class, Throwable.class, "commitErr");
    protected static final AtomicIntegerFieldUpdater<IgniteTxLocalAdapter> DONE_FLAG_UPD = AtomicIntegerFieldUpdater.newUpdater(IgniteTxLocalAdapter.class, "doneFlag");
    protected GridCacheVersion minVer;
    protected volatile int doneFlag;
    private Collection<GridCacheVersion> committedVers = Collections.emptyList();
    private Collection<GridCacheVersion> rolledbackVers = Collections.emptyList();
    private GridCacheVersion completedBase;
    private boolean sndTransformedVals;
    protected volatile Throwable commitErr;
    protected GridCacheReturn implicitRes;
    private boolean depEnabled;
    @GridToStringInclude
    protected IgniteTxLocalState txState;
    protected CacheWriteSynchronizationMode syncMode;
    protected volatile boolean qryEnlisted;

    protected IgniteTxLocalAdapter() {
    }

    protected IgniteTxLocalAdapter(GridCacheSharedContext cctx, GridCacheVersion xidVer, boolean implicit, boolean implicitSingle, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean invalidate, boolean storeEnabled, boolean onePhaseCommit, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(cctx, xidVer, implicit, true, sys, plc, concurrency, isolation, timeout, invalidate, storeEnabled, onePhaseCommit, txSize, subjId, taskNameHash);
        this.minVer = xidVer;
        this.txState = implicitSingle ? new IgniteTxImplicitSingleStateImpl() : new IgniteTxStateImpl();
    }

    public final CacheWriteSynchronizationMode syncMode() {
        if (this.syncMode != null) {
            return this.syncMode;
        }
        return this.txState().syncMode(this.cctx);
    }

    public void syncMode(CacheWriteSynchronizationMode syncMode) {
        this.syncMode = syncMode;
    }

    @Override
    public IgniteTxLocalState txState() {
        return this.txState;
    }

    protected void initResult() {
        this.implicitRes = new GridCacheReturn(this.localResult(), false);
    }

    @Override
    public UUID eventNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    public UUID originatingNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    public boolean empty() {
        return this.txState.empty();
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        return Collections.singleton(this.nodeId);
    }

    @Override
    public Throwable commitError() {
        return this.commitErr;
    }

    @Override
    public void commitError(Throwable e) {
        COMMIT_ERR_UPD.compareAndSet(this, null, e);
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        assert (false);
        return false;
    }

    @Override
    public boolean activeCachesDeploymentEnabled() {
        return this.depEnabled;
    }

    @Override
    public void activeCachesDeploymentEnabled(boolean depEnabled) {
        this.depEnabled = depEnabled;
    }

    @Override
    public boolean isStarted() {
        return this.txState.initialized();
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.txState.hasWriteKey(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.txState.readSet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.txState.writeSet();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.txState.readMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.txState.writeMap();
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.txState.allEntries();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.txState.readEntries();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.txState.writeEntries();
    }

    @Override
    @Nullable
    public IgniteTxEntry entry(IgniteTxKey key) {
        return this.txState.entry(key);
    }

    @Override
    public void seal() {
        this.txState.seal();
    }

    public void implicitSingleResult(GridCacheReturn ret) {
        assert (ret != null);
        if (ret.invokeResult()) {
            this.implicitRes.mergeEntryProcessResults(ret);
        } else {
            this.implicitRes = ret;
        }
    }

    public boolean hasInterceptor() {
        return this.txState().hasInterceptor(this.cctx);
    }

    public void sendTransformedValues(boolean snd) {
        this.sndTransformedVals = snd;
    }

    protected boolean commitAfterLock() {
        return this.implicit() && (!this.dht() || this.colocated());
    }

    @Override
    @Nullable
    public GridTuple<CacheObject> peek(GridCacheContext cacheCtx, boolean failFast, KeyCacheObject key) throws GridCacheFilterFailedException {
        IgniteTxEntry e = this.entry(cacheCtx.txKey(key));
        if (e != null) {
            return e.hasPreviousValue() ? F.t(e.previousValue()) : null;
        }
        return null;
    }

    @Override
    public GridCacheVersion minVersion() {
        return this.minVer;
    }

    public void userPrepare(@Nullable Collection<IgniteTxEntry> entries) throws IgniteCheckedException {
        if (this.state() != TransactionState.PREPARING) {
            if (this.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Transaction timed out: " + this);
            }
            TransactionState state = this.state();
            this.setRollbackOnly();
            throw new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)state) + ", tx=" + this + ']');
        }
        this.checkValid();
        try {
            this.cctx.tm().prepareTx(this, entries);
            if (this.txState().mvccEnabled()) {
                this.calculatePartitionUpdateCounters();
            }
        }
        catch (IgniteCheckedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.setRollbackOnly();
            if (e instanceof Error) {
                throw e;
            }
            throw new IgniteCheckedException("Transaction validation produced a runtime exception: " + this, e);
        }
    }

    public void calculatePartitionUpdateCounters() throws IgniteTxRollbackCheckedException {
        TxCounters counters = this.txCounters(false);
        if (counters != null && F.isEmpty(counters.updateCounters())) {
            ArrayList<PartitionUpdateCountersMessage> cntrMsgs = new ArrayList<PartitionUpdateCountersMessage>();
            for (Map.Entry<Integer, Map<Integer, AtomicLong>> record : counters.accumulatedUpdateCounters().entrySet()) {
                int cacheId = record.getKey();
                Map<Integer, AtomicLong> partToCntrs = record.getValue();
                assert (partToCntrs != null);
                if (F.isEmpty(partToCntrs)) continue;
                PartitionUpdateCountersMessage msg = new PartitionUpdateCountersMessage(cacheId, partToCntrs.size());
                GridCacheContext ctx0 = this.cctx.cacheContext(cacheId);
                GridDhtPartitionTopology top = ctx0.topology();
                assert (top != null);
                for (Map.Entry<Integer, AtomicLong> e : partToCntrs.entrySet()) {
                    boolean valid;
                    AtomicLong acc = e.getValue();
                    assert (acc != null);
                    long cntr = acc.get();
                    assert (cntr >= 0L);
                    if (cntr == 0L) continue;
                    int p = e.getKey();
                    GridDhtLocalPartition part = top.localPartition(p);
                    boolean bl = valid = part != null && (part.state() == GridDhtPartitionState.OWNING || part.state() == GridDhtPartitionState.LOST) && part.primary(top.readyTopologyVersion());
                    if (!valid) {
                        if (part != null && !part.primary(top.readyTopologyVersion())) {
                            log.warning("Failed to prepare a transaction on outdated topology, rolling back [tx=" + CU.txString(this) + ", readyTopVer=" + top.readyTopologyVersion() + ", lostParts=" + top.lostPartitions() + ", part=" + part.toString() + ']');
                            throw new IgniteTxRollbackCheckedException("Failed to prepare a transaction on outdated topology, please try again [timeout=" + this.timeout() + ", tx=" + CU.txString(this) + ']');
                        }
                        throw new AssertionError((Object)("Invalid primary mapping [tx=" + CU.txString(this) + ", readyTopVer=" + top.readyTopologyVersion() + ", lostParts=" + top.lostPartitions() + ", part=" + (part == null ? "NULL" : part.toString()) + ']'));
                    }
                    msg.add(p, part.getAndIncrementUpdateCounter(cntr), cntr);
                }
                if (msg.size() <= 0) continue;
                cntrMsgs.add(msg);
            }
            counters.updateCounters(cntrMsgs);
        }
    }

    private void checkCommitLocks(GridCacheEntryEx entry) {
        assert (this.ownsLockUnsafe(entry)) : "Lock is not owned for commit [entry=" + entry + ", tx=" + this + ']';
    }

    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key) {
        return cacheCtx.cache().entryEx(key.key());
    }

    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key, AffinityTopologyVersion topVer) {
        return cacheCtx.cache().entryEx(key.key(), topVer);
    }

    @Override
    public void userCommit() throws IgniteCheckedException {
        boolean empty;
        TransactionState state = this.state();
        if (state != TransactionState.COMMITTING) {
            if (this.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Transaction timed out: " + this);
            }
            this.setRollbackOnly();
            throw new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)state) + ", tx=" + this + ']');
        }
        this.checkValid();
        Collection<IgniteTxEntry> commitEntries = this.near() || this.cctx.snapshot().needTxReadLogging() ? this.allEntries() : this.writeEntries();
        boolean bl = empty = F.isEmpty(commitEntries) && !this.queryEnlisted();
        if (!empty || this.colocated()) {
            this.cctx.tm().addCommittedTx(this);
        }
        if (!empty) {
            boolean needTaskName = this.cctx.gridEvents().isRecordable(64) || this.cctx.gridEvents().isRecordable(63) || this.cctx.gridEvents().isRecordable(65);
            String taskName = needTaskName ? this.resolveTaskName() : null;
            this.batchStoreCommit(this.writeEntries(), taskName);
            WALPointer ptr = null;
            this.cctx.database().checkpointReadLock();
            try {
                this.cctx.tm().txContext(this);
                AffinityTopologyVersion topVer = this.topologyVersion();
                TxCounters txCounters = this.txCounters(false);
                block9: for (IgniteTxEntry txEntry : commitEntries) {
                    GridCacheContext<?, ?> cacheCtx = txEntry.context();
                    GridDrType drType = cacheCtx.isDrEnabled() ? GridDrType.DR_PRIMARY : GridDrType.DR_NONE;
                    UUID nodeId = txEntry.nodeId() == null ? this.nodeId : txEntry.nodeId();
                    while (true) {
                        try {
                            GridCacheEntryEx cached = txEntry.cached();
                            if (!this.evictNearEntry(txEntry, false)) {
                                ExpiryPolicy expiry;
                                GridCacheVersion explicitVer;
                                boolean evt;
                                if (cacheCtx.isNear() && cacheCtx.dr().receiveEnabled()) {
                                    cached.markObsolete(this.xidVer);
                                    continue block9;
                                }
                                if (cached.detached()) continue block9;
                                boolean updateNearCache = this.updateNearCache(cacheCtx, txEntry.key(), topVer);
                                boolean metrics = true;
                                if (!updateNearCache && cacheCtx.isNear() && txEntry.locallyMapped()) {
                                    metrics = false;
                                }
                                boolean bl2 = evt = !this.isNearLocallyMapped(txEntry, false);
                                if (!F.isEmpty(txEntry.entryProcessors()) || !F.isEmpty(txEntry.filters())) {
                                    txEntry.cached().unswap(false);
                                }
                                IgniteBiTuple<GridCacheOperation, CacheObject> res = this.applyTransformClosures(txEntry, true, null, taskName);
                                GridCacheVersion dhtVer = null;
                                if (cacheCtx.isNear()) {
                                    ExpiryPolicy expiry2;
                                    if (txEntry.op() == GridCacheOperation.CREATE || txEntry.op() == GridCacheOperation.UPDATE || txEntry.op() == GridCacheOperation.DELETE || txEntry.op() == GridCacheOperation.TRANSFORM) {
                                        dhtVer = txEntry.dhtVersion();
                                    }
                                    if ((txEntry.op() == GridCacheOperation.CREATE || txEntry.op() == GridCacheOperation.UPDATE) && txEntry.conflictExpireTime() == -1L && (expiry2 = cacheCtx.expiryForTxEntry(txEntry)) != null) {
                                        txEntry.cached().unswap(false);
                                        Duration duration = cached.hasValue() ? expiry2.getExpiryForUpdate() : expiry2.getExpiryForCreation();
                                        txEntry.ttl(CU.toTtl(duration));
                                    }
                                }
                                GridCacheOperation op = res.get1();
                                CacheObject val = res.get2();
                                if (txEntry.conflictVersion() != null) {
                                    explicitVer = txEntry.conflictVersion();
                                    if (txEntry.conflictVersion().dataCenterId() == this.writeVersion().dataCenterId()) {
                                        explicitVer = new GridCacheVersionEx(explicitVer.topologyVersion(), explicitVer.nodeOrderAndDrIdRaw(), explicitVer.order(), explicitVer.copy());
                                    }
                                } else {
                                    explicitVer = this.writeVersion();
                                }
                                if ((op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) && txEntry.conflictExpireTime() == -1L && (expiry = cacheCtx.expiryForTxEntry(txEntry)) != null) {
                                    Duration duration = cached.hasValue() ? expiry.getExpiryForUpdate() : expiry.getExpiryForCreation();
                                    long ttl = CU.toTtl(duration);
                                    txEntry.ttl(ttl);
                                    if (ttl == -2L) {
                                        op = GridCacheOperation.DELETE;
                                    }
                                }
                                boolean conflictNeedResolve = cacheCtx.conflictNeedResolve();
                                GridCacheVersionConflictContext conflictCtx = null;
                                if (conflictNeedResolve) {
                                    IgniteBiTuple<GridCacheOperation, GridCacheVersionConflictContext> conflictRes = this.conflictResolve(op, txEntry, val, explicitVer, cached);
                                    assert (conflictRes != null);
                                    conflictCtx = conflictRes.get2();
                                    if (conflictCtx.isUseOld()) {
                                        op = GridCacheOperation.NOOP;
                                    } else if (conflictCtx.isUseNew()) {
                                        txEntry.ttl(conflictCtx.ttl());
                                        txEntry.conflictExpireTime(conflictCtx.expireTime());
                                    } else {
                                        assert (conflictCtx.isMerge());
                                        op = conflictRes.get1();
                                        val = txEntry.context().toCacheObject(conflictCtx.mergeValue());
                                        explicitVer = this.writeVersion();
                                        txEntry.ttl(conflictCtx.ttl());
                                        txEntry.conflictExpireTime(conflictCtx.expireTime());
                                    }
                                } else {
                                    explicitVer = null;
                                }
                                if (this.sndTransformedVals || conflictNeedResolve) {
                                    assert (this.sndTransformedVals && cacheCtx.isReplicated() || conflictNeedResolve);
                                    txEntry.value(val, true, false);
                                    txEntry.op(op);
                                    txEntry.entryProcessors(null);
                                    txEntry.conflictVersion(explicitVer);
                                }
                                if (dhtVer == null) {
                                    GridCacheVersion gridCacheVersion = dhtVer = explicitVer != null ? explicitVer : this.writeVersion();
                                }
                                if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                                    assert (val != null) : txEntry;
                                    GridCacheUpdateTxResult updRes = cached.innerSet(this, this.eventNodeId(), txEntry.nodeId(), val, false, false, txEntry.ttl(), evt, metrics, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, cached.detached() ? GridDrType.DR_NONE : drType, txEntry.conflictExpireTime(), cached.isNear() ? null : explicitVer, CU.subjectId(this, this.cctx), taskName, dhtVer, null);
                                    if (updRes.success()) {
                                        txEntry.updateCounter(updRes.updateCounter());
                                    }
                                    if (updRes.loggedPointer() != null) {
                                        ptr = updRes.loggedPointer();
                                    }
                                    if (updRes.success() && updateNearCache) {
                                        CacheObject val0 = val;
                                        boolean metrics0 = metrics;
                                        GridCacheVersion dhtVer0 = dhtVer;
                                        this.updateNearEntrySafely(cacheCtx, txEntry.key(), entry -> entry.innerSet(null, this.eventNodeId(), nodeId, val0, false, false, txEntry.ttl(), false, metrics0, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, CU.empty0(), GridDrType.DR_NONE, txEntry.conflictExpireTime(), null, CU.subjectId(this, this.cctx), taskName, dhtVer0, null));
                                    }
                                } else if (op == GridCacheOperation.DELETE) {
                                    GridCacheUpdateTxResult updRes = cached.innerRemove(this, this.eventNodeId(), txEntry.nodeId(), false, evt, metrics, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, cached.detached() ? GridDrType.DR_NONE : drType, cached.isNear() ? null : explicitVer, CU.subjectId(this, this.cctx), taskName, dhtVer, null);
                                    if (updRes.success()) {
                                        txEntry.updateCounter(updRes.updateCounter());
                                    }
                                    if (updRes.loggedPointer() != null) {
                                        ptr = updRes.loggedPointer();
                                    }
                                    if (updRes.success() && updateNearCache) {
                                        boolean metrics0 = metrics;
                                        GridCacheVersion dhtVer0 = dhtVer;
                                        this.updateNearEntrySafely(cacheCtx, txEntry.key(), entry -> entry.innerRemove(null, this.eventNodeId(), nodeId, false, false, metrics0, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, CU.empty0(), GridDrType.DR_NONE, null, CU.subjectId(this, this.cctx), taskName, dhtVer0, null));
                                    }
                                } else if (op == GridCacheOperation.RELOAD) {
                                    cached.innerReload();
                                    if (updateNearCache) {
                                        this.updateNearEntrySafely(cacheCtx, txEntry.key(), entry -> entry.innerReload());
                                    }
                                } else if (op == GridCacheOperation.READ) {
                                    Duration duration;
                                    ExpiryPolicy expiry3;
                                    CacheGroupContext grp = cacheCtx.group();
                                    if (grp.persistenceEnabled()) {
                                        this.cctx.tm().pendingTxsTracker().onKeysRead(this.nearXidVersion(), Collections.singletonList(txEntry.key()));
                                        if (grp.walEnabled() && this.cctx.snapshot().needTxReadLogging()) {
                                            ptr = this.cctx.wal().log(new DataRecord(new DataEntry(cacheCtx.cacheId(), txEntry.key(), val, op, this.nearXidVersion(), this.writeVersion(), 0L, txEntry.key().partition(), txEntry.updateCounter(), DataEntry.flags(CU.txOnPrimary(this)))));
                                        }
                                    }
                                    if ((expiry3 = cacheCtx.expiryForTxEntry(txEntry)) != null && (duration = expiry3.getExpiryForAccess()) != null) {
                                        cached.updateTtl(null, CU.toTtl(duration));
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug("Ignoring READ entry when committing: " + txEntry);
                                    }
                                } else {
                                    assert (this.ownsLock(txEntry.cached())) : "Transaction does not own lock for group lock entry during  commit [tx=" + this + ", txEntry=" + txEntry + ']';
                                    if (!(conflictCtx != null && conflictCtx.isUseOld() || txEntry.ttl() == -1L)) {
                                        cached.updateTtl(null, txEntry.ttl());
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug("Ignoring NOOP entry when committing: " + txEntry);
                                    }
                                }
                            }
                            if (txEntry.op() == GridCacheOperation.READ) continue block9;
                            this.checkCommitLocks(cached);
                            continue block9;
                        }
                        catch (GridCacheEntryRemovedException ignored) {
                            if (log.isDebugEnabled()) {
                                log.debug("Got removed entry during transaction commit (will retry): " + txEntry);
                            }
                            txEntry.cached(this.entryEx(cacheCtx, txEntry.txKey(), this.topologyVersion()));
                            continue;
                        }
                        break;
                    }
                }
                if (!this.txState.mvccEnabled() && txCounters != null) {
                    this.cctx.tm().txHandler().applyPartitionsUpdatesCounters(txCounters.updateCounters());
                    for (IgniteTxEntry entry2 : commitEntries) {
                        if (entry2.cqNotifyClosure() == null) continue;
                        entry2.cqNotifyClosure().applyx();
                    }
                }
                this.applyTxSizes();
                this.cctx.mvccCaching().onTxFinished(this, true);
                if (ptr != null) {
                    this.cctx.wal().flush(ptr, false);
                }
            }
            catch (Throwable ex) {
                this.cctx.tm().removeCommittedTx(this);
                if (X.hasCause(ex, NodeStoppingException.class)) {
                    U.warn(log, "Failed to commit transaction, node is stopping [tx=" + CU.txString(this) + ", err=" + ex + ']');
                    boolean persistenceEnabled = CU.isPersistenceEnabled(this.cctx.kernalContext().config());
                    if (persistenceEnabled) {
                        GridCacheDatabaseSharedManager dbManager = (GridCacheDatabaseSharedManager)this.cctx.database();
                        dbManager.getCheckpointer().skipCheckpointOnNodeStop(true);
                    }
                    throw ex;
                }
                IgniteCheckedException err = this.heuristicException(ex);
                COMMIT_ERR_UPD.compareAndSet(this, null, err);
                this.state(TransactionState.UNKNOWN);
                try {
                    this.uncommit();
                }
                catch (Throwable e) {
                    err.addSuppressed(e);
                }
                throw err;
            }
            finally {
                this.cctx.database().checkpointReadUnlock();
                this.cctx.tm().resetContext();
            }
        }
        if (!this.onePhaseCommit() && DONE_FLAG_UPD.compareAndSet(this, 0, 1)) {
            this.cctx.tm().commitTx(this);
            boolean needsCompletedVersions = this.needsCompletedVersions();
            assert (!needsCompletedVersions || this.completedBase != null);
            assert (!needsCompletedVersions || this.committedVers != null);
            assert (!needsCompletedVersions || this.rolledbackVers != null);
        }
    }

    private void updateNearEntrySafely(GridCacheContext cacheCtx, KeyCacheObject entryKey, NearEntryUpdateClojure<GridCacheEntryEx> updateClojure) throws IgniteCheckedException {
        GridCacheEntryEx nearCached;
        while ((nearCached = cacheCtx.dht().near().peekEx(entryKey)) != null) {
            try {
                updateClojure.apply(nearCached);
                break;
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (log.isDebugEnabled()) {
                    log.debug("Got removed entry during transaction commit (will retry): " + nearCached);
                }
                cacheCtx.dht().near().removeEntry(nearCached);
            }
        }
    }

    public void tmFinish(boolean commit, boolean nodeStop, boolean clearThreadMap) throws IgniteCheckedException {
        assert (this.onePhaseCommit());
        if (DONE_FLAG_UPD.compareAndSet(this, 0, 1)) {
            if (!nodeStop) {
                if (commit) {
                    this.cctx.tm().commitTx(this);
                } else {
                    this.cctx.tm().rollbackTx(this, clearThreadMap, false);
                }
            }
            this.state(commit ? TransactionState.COMMITTED : TransactionState.ROLLED_BACK);
            if (commit) {
                boolean needsCompletedVersions = this.needsCompletedVersions();
                assert (!needsCompletedVersions || this.completedBase != null) : "Missing completed base for transaction: " + this;
                assert (!needsCompletedVersions || this.committedVers != null) : "Missing committed versions for transaction: " + this;
                assert (!needsCompletedVersions || this.rolledbackVers != null) : "Missing rolledback versions for transaction: " + this;
            }
            this.cctx.mvccCaching().onTxFinished(this, commit);
        }
    }

    @Override
    public void completedVersions(GridCacheVersion completedBase, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        this.completedBase = completedBase;
        this.committedVers = committedVers;
        this.rolledbackVers = rolledbackVers;
    }

    public GridCacheVersion completedBase() {
        return this.completedBase;
    }

    public Collection<GridCacheVersion> committedVersions() {
        return this.committedVers;
    }

    public Collection<GridCacheVersion> rolledbackVersions() {
        return this.rolledbackVers;
    }

    @Override
    public void userRollback(boolean clearThreadMap) throws IgniteCheckedException {
        TransactionState state = this.state();
        if (state != TransactionState.ROLLING_BACK && state != TransactionState.ROLLED_BACK) {
            this.setRollbackOnly();
            throw new IgniteCheckedException("Invalid transaction state for rollback [state=" + (Object)((Object)state) + ", tx=" + this + ']');
        }
        if (this.near()) {
            for (IgniteTxEntry e : this.allEntries()) {
                this.evictNearEntry(e, false);
            }
        }
        if (DONE_FLAG_UPD.compareAndSet(this, 0, 1)) {
            Collection<CacheStoreManager> stores;
            this.cctx.tm().rollbackTx(this, clearThreadMap, this.skipCompletedVersions());
            this.cctx.mvccCaching().onTxFinished(this, false);
            if (!this.internal() && (stores = this.txState.stores(this.cctx)) != null && !stores.isEmpty()) {
                assert (this.isWriteToStoreFromDhtValid(stores)) : "isWriteToStoreFromDht can't be different within one transaction";
                boolean isWriteToStoreFromDht = F.first(stores).isWriteToStoreFromDht();
                if (!stores.isEmpty() && (this.near() || isWriteToStoreFromDht)) {
                    this.sessionEnd(stores, false);
                }
            }
        }
    }

    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext ctx, IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        return null;
    }

    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext cacheCtx, Collection<KeyCacheObject> keys) {
        return null;
    }

    protected final void postLockWrite(GridCacheContext cacheCtx, Iterable<KeyCacheObject> keys, GridCacheReturn ret, boolean rmv, boolean retval, boolean read, long accessTtl, CacheEntryPredicate[] filter, boolean computeInvoke) throws IgniteCheckedException {
        block4: for (KeyCacheObject k : keys) {
            IgniteTxEntry txEntry = this.entry(cacheCtx.txKey(k));
            if (txEntry == null) {
                throw new IgniteCheckedException("Transaction entry is null (most likely collection of keys passed into cache operation was changed before operation completed) [missingKey=" + k + ", tx=" + this + ']');
            }
            while (true) {
                GridCacheEntryEx cached = txEntry.cached();
                try {
                    boolean pass;
                    boolean invoke;
                    assert (cached.detached() || cached.lockedLocally(this.xidVersion()) || this.isRollbackOnly()) : "Transaction lock is not acquired [entry=" + cached + ", tx=" + this + ", nodeId=" + this.cctx.localNodeId() + ", threadId=" + this.threadId + ']';
                    if (log.isDebugEnabled()) {
                        log.debug("Post lock write entry: " + cached);
                    }
                    CacheObject v = txEntry.previousValue();
                    boolean hasPrevVal = txEntry.hasPreviousValue();
                    if (this.onePhaseCommit()) {
                        filter = txEntry.filters();
                    }
                    if (!F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter)) {
                        retval = true;
                    }
                    boolean bl = invoke = txEntry.op() == GridCacheOperation.TRANSFORM;
                    if (retval || invoke) {
                        if (!cacheCtx.isNear()) {
                            if (!hasPrevVal) {
                                boolean readThrough = cacheCtx.isLocal() && (invoke || cacheCtx.loadPreviousValue()) && !txEntry.skipStore();
                                v = cached.innerGet(null, this, readThrough, !invoke, !invoke && !this.dht(), CU.subjectId(this, this.cctx), null, this.resolveTaskName(), null, txEntry.keepBinary());
                            }
                        } else if (!hasPrevVal) {
                            v = cached.rawGet();
                        }
                        if (txEntry.op() == GridCacheOperation.TRANSFORM) {
                            if (computeInvoke) {
                                GridCacheVersion ver;
                                txEntry.readValue(v);
                                try {
                                    ver = cached.version();
                                }
                                catch (GridCacheEntryRemovedException e) {
                                    assert (this.optimistic()) : txEntry;
                                    if (log.isDebugEnabled()) {
                                        log.debug("Failed to get entry version: [msg=" + e.getMessage() + ']');
                                    }
                                    ver = null;
                                }
                                this.addInvokeResult(txEntry, v, ret, ver);
                            }
                        } else {
                            ret.value(cacheCtx, v, txEntry.keepBinary(), U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                        }
                    }
                    boolean bl2 = pass = F.isEmpty(filter) || cacheCtx.isAll(cached, filter);
                    ret.success(pass && (!retval ? !rmv || cached.hasValue() || v != null : !rmv || v != null));
                    if (this.onePhaseCommit()) {
                        txEntry.filtersPassed(pass);
                    }
                    boolean updateTtl = read;
                    if (pass) {
                        txEntry.markValid();
                        if (log.isDebugEnabled()) {
                            log.debug("Filter passed in post lock for key: " + k);
                        }
                    } else {
                        txEntry.setAndMarkValid(txEntry.previousOperation(), cacheCtx.toCacheObject(ret.value()));
                        txEntry.filters(CU.empty0());
                        txEntry.filtersSet(false);
                        boolean bl3 = updateTtl = !cacheCtx.putIfAbsentFilter(filter);
                    }
                    if (!updateTtl) continue block4;
                    if (!read) {
                        ExpiryPolicy expiryPlc = cacheCtx.expiryForTxEntry(txEntry);
                        if (expiryPlc == null) continue block4;
                        txEntry.ttl(CU.toTtl(expiryPlc.getExpiryForAccess()));
                        continue block4;
                    }
                    txEntry.ttl(accessTtl);
                    continue block4;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got removed entry in putAllAsync method (will retry): " + cached);
                    }
                    txEntry.cached(this.entryEx(cached.context(), txEntry.txKey(), this.topologyVersion()));
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addInvokeResult(IgniteTxEntry txEntry, CacheObject cacheVal, GridCacheReturn ret, GridCacheVersion ver) {
        GridCacheContext<?, ?> ctx = txEntry.context();
        Object key0 = null;
        Object val0 = null;
        IgniteThread.onEntryProcessorEntered(true);
        if (this.cctx.kernalContext().deploy().enabled() && this.deploymentLdrId != null) {
            U.restoreDeploymentContext(this.cctx.kernalContext(), this.deploymentLdrId);
        }
        try {
            Object res = null;
            for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : txEntry.entryProcessors()) {
                CacheInvokeEntry<Object, Object> invokeEntry = new CacheInvokeEntry<Object, Object>(txEntry.key(), key0, cacheVal, val0, ver, txEntry.keepBinary(), txEntry.cached());
                EntryProcessor entryProcessor = (EntryProcessor)t.get1();
                res = entryProcessor.process(invokeEntry, (Object[])t.get2());
                val0 = invokeEntry.getValue(txEntry.keepBinary());
                key0 = invokeEntry.key();
            }
            if (val0 != null) {
                ctx.validateKeyAndValue(txEntry.key(), ctx.toCacheObject(val0));
            }
            if (res != null) {
                ret.addEntryProcessResult(ctx, txEntry.key(), key0, res, null, txEntry.keepBinary());
            }
        }
        catch (Exception e) {
            ret.addEntryProcessResult(ctx, txEntry.key(), key0, null, e, txEntry.keepBinary());
        }
        finally {
            IgniteThread.onEntryProcessorLeft();
        }
    }

    public boolean init() {
        return !this.txState.init(this.txSize) || this.cctx.tm().onStarted(this);
    }

    @Override
    public final void addActiveCache(GridCacheContext cacheCtx, boolean recovery) throws IgniteCheckedException {
        this.txState.addActiveCache(cacheCtx, recovery, this);
    }

    protected void checkValid() throws IgniteCheckedException {
        this.checkValid(true);
    }

    protected void checkValid(boolean checkTimeout) throws IgniteCheckedException {
        if (this.local() && !this.dht() && this.remainingTime() == -1L && checkTimeout) {
            this.state(TransactionState.MARKED_ROLLBACK, true);
        }
        if (this.isRollbackOnly()) {
            if (this.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Cache transaction timed out: " + CU.txString(this));
            }
            TransactionState state = this.state();
            if (state == TransactionState.ROLLING_BACK || state == TransactionState.ROLLED_BACK) {
                Throwable commitErr0 = this.commitErr;
                if (commitErr0 != null) {
                    throw new IgniteTxRollbackCheckedException(commitErr0);
                }
                throw new IgniteTxRollbackCheckedException("Cache transaction is marked as rollback-only (will be rolled back automatically): " + this);
            }
            if (state == TransactionState.UNKNOWN) {
                throw new IgniteTxHeuristicCheckedException("Cache transaction is in unknown state (remote transactions will be invalidated): " + this);
            }
            throw this.rollbackException();
        }
    }

    @Override
    public Collection<GridCacheVersion> alternateVersions() {
        return Collections.emptyList();
    }

    public final IgniteTxEntry addEntry(GridCacheOperation op, @Nullable CacheObject val, @Nullable EntryProcessor entryProcessor, Object[] invokeArgs, GridCacheEntryEx entry, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, boolean filtersSet, long drTtl, long drExpireTime, @Nullable GridCacheVersion drVer, boolean skipStore, boolean keepBinary, boolean addReader) {
        IgniteTxEntry txEntry;
        assert (invokeArgs == null || op == GridCacheOperation.TRANSFORM);
        IgniteTxKey key = entry.txKey();
        this.checkInternal(key);
        IgniteTxEntry old = this.entry(key);
        if (!(filtersSet && F.isEmptyOrNulls(filter) || old == null || !old.filtersSet())) {
            filter = old.filters();
        }
        if (old != null) {
            if (entryProcessor != null) {
                assert (val == null);
                assert (op == GridCacheOperation.TRANSFORM);
                old.addEntryProcessor(entryProcessor, invokeArgs);
            } else {
                assert (old.op() != GridCacheOperation.TRANSFORM);
                old.op(op);
                old.value(val, op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE, op == GridCacheOperation.READ);
            }
            old.cached(entry);
            old.filters(filter);
            old.skipStore(skipStore);
            old.keepBinary(keepBinary);
            if (drTtl >= 0L) {
                assert (drExpireTime >= 0L);
                this.entryTtlDr(key, drTtl, drExpireTime);
            } else {
                this.entryExpiry(key, expiryPlc);
            }
            txEntry = old;
            if (log.isDebugEnabled()) {
                log.debug("Updated transaction entry: " + txEntry);
            }
        } else {
            boolean hasDrTtl = drTtl >= 0L;
            txEntry = new IgniteTxEntry(entry.context(), this, op, val, EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), entryProcessor), invokeArgs, hasDrTtl ? drTtl : -1L, entry, filter, drVer, skipStore, keepBinary, addReader);
            txEntry.conflictExpireTime(drExpireTime);
            if (!hasDrTtl) {
                txEntry.expiry(expiryPlc);
            }
            this.txState.addEntry(txEntry);
            if (log.isDebugEnabled()) {
                log.debug("Created transaction entry: " + txEntry);
            }
        }
        txEntry.filtersSet(filtersSet);
        while (true) {
            try {
                this.updateExplicitVersion(txEntry, entry);
                return txEntry;
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (log.isDebugEnabled()) {
                    log.debug("Got removed entry in transaction newEntry method (will retry): " + entry);
                }
                entry = this.entryEx(entry.context(), txEntry.txKey(), this.topologyVersion());
                txEntry.cached(entry);
                continue;
            }
            break;
        }
    }

    protected void updateExplicitVersion(IgniteTxEntry txEntry, GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        if (!entry.context().isDht()) {
            GridCacheMvccCandidate explicitCand = entry.localOwner();
            if (explicitCand == null) {
                explicitCand = this.cctx.mvcc().explicitLock(this.threadId(), entry.txKey());
            }
            if (explicitCand != null) {
                GridCacheVersion explicitVer = explicitCand.version();
                boolean locCand = false;
                if (explicitCand.nearLocal() || explicitCand.local()) {
                    locCand = this.cctx.localNodeId().equals(explicitCand.nodeId());
                } else if (explicitCand.dhtLocal()) {
                    locCand = this.cctx.localNodeId().equals(explicitCand.otherNodeId());
                }
                if (!explicitVer.equals(this.xidVer) && explicitCand.isHeldByThread(this.threadId) && !explicitCand.tx() && locCand) {
                    txEntry.explicitVersion(explicitVer);
                    if (explicitVer.isLess(this.minVer)) {
                        this.minVer = explicitVer;
                    }
                }
            }
        }
    }

    public Map<Integer, Set<Integer>> partsMap() {
        return null;
    }

    @Override
    public void touchPartition(int cacheId, int partId) {
        this.txState.touchPartition(cacheId, partId);
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(IgniteTxLocalAdapter.class, this, "super", (Object)super.toString(), "size", (Object)this.allEntries().size());
    }

    void entryExpiry(IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            e.expiry(expiryPlc);
            e.conflictExpireTime(-1L);
        }
    }

    boolean entryTtlDr(IgniteTxKey key, long ttl, long expireTime) {
        assert (key != null);
        assert (ttl >= 0L);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            e.ttl(ttl);
            e.conflictExpireTime(expireTime);
            e.expiry(null);
        }
        return e != null;
    }

    public long entryTtl(IgniteTxKey key) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        return e != null ? e.ttl() : 0L;
    }

    public long entryExpireTime(IgniteTxKey key) {
        assert (key != null);
        IgniteTxEntry e = this.entry(key);
        if (e != null) {
            long expireTime;
            long ttl = e.ttl();
            assert (ttl != -1L);
            if (ttl > 0L && (expireTime = U.currentTimeMillis() + ttl) > 0L) {
                return expireTime;
            }
        }
        return 0L;
    }

    public boolean queryEnlisted() {
        return this.qryEnlisted;
    }

    public void markQueryEnlisted() {
        assert (this.mvccSnapshot != null && this.txState.mvccEnabled());
        if (!this.qryEnlisted) {
            this.qryEnlisted = true;
            if (!this.cctx.localNode().isClient()) {
                this.cctx.coordinators().registerLocalTransaction(this.mvccSnapshot.coordinatorVersion(), this.mvccSnapshot.counter());
            }
        }
    }

    @FunctionalInterface
    private static interface NearEntryUpdateClojure<E extends GridCacheEntryEx> {
        public void apply(E var1) throws IgniteCheckedException, GridCacheEntryRemovedException;
    }

    protected abstract class PostMissClosure<T>
    implements IgniteBiClosure<T, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;

        protected PostMissClosure() {
        }

        @Override
        public final IgniteInternalFuture<T> apply(T t, Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                IgniteInternalFuture<T> fut = this.postMiss(t);
                rollback = false;
                IgniteInternalFuture<T> igniteInternalFuture = fut;
                return igniteInternalFuture;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract IgniteInternalFuture<T> postMiss(T var1) throws IgniteCheckedException;
    }

    protected abstract class PostLockClosure2<T>
    implements IgniteBiClosure<Boolean, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;

        protected PostLockClosure2() {
        }

        @Override
        public final IgniteInternalFuture<T> apply(Boolean locked, @Nullable Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                if (!locked.booleanValue()) {
                    throw new GridClosureException(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + IgniteTxLocalAdapter.this.timeout() + ", tx=" + CU.txString(IgniteTxLocalAdapter.this) + ']'));
                }
                IgniteInternalFuture<T> fut = this.postLock();
                rollback = false;
                IgniteInternalFuture<T> igniteInternalFuture = fut;
                return igniteInternalFuture;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract IgniteInternalFuture<T> postLock() throws IgniteCheckedException;
    }

    protected abstract class PostLockClosure1<T>
    implements IgniteBiClosure<Boolean, Exception, IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;
        private T arg;
        private boolean commit;

        protected PostLockClosure1(T arg) {
            this(arg, true);
        }

        protected PostLockClosure1(T arg, boolean commit) {
            this.arg = arg;
            this.commit = commit;
        }

        @Override
        public final IgniteInternalFuture<T> apply(Boolean locked, final @Nullable Exception e) {
            TransactionDeadlockException deadlockErr = X.cause(e, TransactionDeadlockException.class);
            if (e != null && deadlockErr == null) {
                IgniteTxLocalAdapter.this.setRollbackOnly();
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    return IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw new GridClosureException(e);
                        }
                    });
                }
                throw new GridClosureException(e);
            }
            if (deadlockErr != null || !locked.booleanValue()) {
                IgniteTxLocalAdapter.this.setRollbackOnly();
                final GridClosureException ex = new GridClosureException(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + IgniteTxLocalAdapter.this.timeout() + ", tx=" + CU.txString(IgniteTxLocalAdapter.this) + ']', deadlockErr));
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    return IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw ex;
                        }
                    });
                }
                throw ex;
            }
            boolean rollback = true;
            try {
                final T r = this.postLock(this.arg);
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    rollback = false;
                    IgniteInternalFuture igniteInternalFuture = IgniteTxLocalAdapter.this.commitAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T applyx(IgniteInternalFuture<IgniteInternalTx> f) throws IgniteCheckedException {
                            f.get();
                            return r;
                        }
                    });
                    return igniteInternalFuture;
                }
                rollback = false;
                GridFinishedFuture<T> gridFinishedFuture = new GridFinishedFuture<T>(r);
                return gridFinishedFuture;
            }
            catch (IgniteCheckedException ex) {
                if (this.commit && IgniteTxLocalAdapter.this.commitAfterLock()) {
                    IgniteInternalFuture igniteInternalFuture = IgniteTxLocalAdapter.this.rollbackAsync().chain(new C1<IgniteInternalFuture<IgniteInternalTx>, T>(){

                        @Override
                        public T apply(IgniteInternalFuture<IgniteInternalTx> f) {
                            throw new GridClosureException(ex);
                        }
                    });
                    return igniteInternalFuture;
                }
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    IgniteTxLocalAdapter.this.setRollbackOnly();
                }
            }
        }

        protected abstract T postLock(T var1) throws IgniteCheckedException;
    }

    protected abstract class PMC<T>
    extends PostMissClosure<T> {
        private static final long serialVersionUID = 0L;

        protected PMC() {
        }
    }

    protected abstract class PLC2<T>
    extends PostLockClosure2<T> {
        private static final long serialVersionUID = 0L;

        protected PLC2() {
        }
    }

    protected abstract class PLC1<T>
    extends PostLockClosure1<T> {
        private static final long serialVersionUID = 0L;

        protected PLC1(T arg) {
            super(arg);
        }

        protected PLC1(T arg, boolean commit) {
            super(arg, commit);
        }
    }
}

