/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.EncryptedRecord;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotFinishRecord;
import org.apache.ignite.internal.pagemem.wal.record.IncrementalSnapshotStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.IndexRenameRootPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.LazyDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MasterKeyChangeRecordV2;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.PartitionClearingStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.ReencryptionStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.pagemem.wal.record.delta.ClusterSnapshotRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertFragmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccMarkUpdatedRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccUpdateNewTxStateHintRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccUpdateTxStateHintRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageRemoveRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageSetFreeListPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageUpdateRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixCountRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixLeftmostChildRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.FixRemoveId;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InnerReplaceRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InsertRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MergeRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageAddRootRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageCutRootRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootInlineFlagsCreatedVersionRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootInlineRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateIndexDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateLastAllocatedIndex;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateLastSuccessfulFullSnapshotId;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateLastSuccessfulSnapshotId;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateNextSnapshotId;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV2;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV3;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV4;
import org.apache.ignite.internal.pagemem.wal.record.delta.NewRootInitRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageListMetaResetCountRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListAddPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListInitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListRemovePageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListSetNextRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PagesListSetPreviousRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RecycleRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RemoveRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.ReplaceRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.RotatedIdPartRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.SplitExistingPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.SplitForwardPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.TrackingPageDeltaRecord;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.record.HeaderRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.DecryptionResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.TxRecordSerializer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class RecordDataV1Serializer
implements RecordDataSerializer {
    static final int HEADER_RECORD_DATA_SIZE = 12;
    protected final GridCacheSharedContext cctx;
    protected final int pageSize;
    protected final int realPageSize;
    protected final IgniteCacheObjectProcessor co;
    private final IgniteLogger log;
    private TxRecordSerializer txRecordSerializer;
    private final EncryptionSpi encSpi;
    private final EncryptionCacheKeyProvider encMgr;
    private final boolean encryptionDisabled;
    private static final byte ENCRYPTED = 1;
    private static final byte PLAIN = 0;

    public RecordDataV1Serializer(GridCacheSharedContext cctx, EncryptionCacheKeyProvider keyProvider) {
        this.cctx = cctx;
        this.txRecordSerializer = new TxRecordSerializer();
        this.co = cctx.kernalContext().cacheObjects();
        this.pageSize = cctx.database().pageSize();
        this.encSpi = cctx.gridConfig().getEncryptionSpi();
        this.encMgr = keyProvider;
        this.encryptionDisabled = this.encSpi instanceof NoopEncryptionSpi;
        this.realPageSize = this.encSpi != null ? CU.encryptedPageSize(this.pageSize, this.encSpi) : this.pageSize;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public int size(WALRecord record) throws IgniteCheckedException {
        int clSz = this.plainSize(record);
        if (this.needEncryption(record)) {
            return this.encSpi.encryptedSize(clSz) + 4 + 4 + 1 + 1;
        }
        return clSz;
    }

    @Override
    public WALRecord readRecord(WALRecord.RecordType type, ByteBufferBackedDataInput in, int size) throws IOException, IgniteCheckedException {
        if (type == WALRecord.RecordType.ENCRYPTED_RECORD || type == WALRecord.RecordType.ENCRYPTED_RECORD_V2) {
            DecryptionResult decryptionResult = this.readEncryptedData(in, true, type == WALRecord.RecordType.ENCRYPTED_RECORD_V2);
            if (decryptionResult.isDecryptedSuccessfully()) {
                ByteBufferBackedDataInput data = decryptionResult.decryptedData();
                return this.readPlainRecord(decryptionResult.recordType(), data, true, data.buffer().capacity());
            }
            return new EncryptedRecord(decryptionResult.grpId(), decryptionResult.recordType());
        }
        return this.readPlainRecord(type, in, false, size);
    }

    @Override
    public void writeRecord(WALRecord rec, ByteBuffer buf) throws IgniteCheckedException {
        if (this.needEncryption(rec)) {
            int clSz = this.plainSize(rec);
            ByteBuffer clData = ByteBuffer.allocate(clSz);
            this.writePlainRecord(rec, clData);
            clData.rewind();
            this.writeEncryptedData(((WalRecordCacheGroupAware)((Object)rec)).groupId(), rec.type(), clData, buf);
            return;
        }
        this.writePlainRecord(rec, buf);
    }

    private boolean needEncryption(WALRecord rec) {
        if (this.encryptionDisabled) {
            return false;
        }
        if (!(rec instanceof WalRecordCacheGroupAware)) {
            return false;
        }
        return this.needEncryption(((WalRecordCacheGroupAware)((Object)rec)).groupId());
    }

    private boolean needEncryption(int grpId) {
        if (this.encryptionDisabled) {
            return false;
        }
        GridEncryptionManager encMgr = this.cctx.kernalContext().encryption();
        return encMgr != null && encMgr.getActiveKey(grpId) != null;
    }

    private DecryptionResult readEncryptedData(ByteBufferBackedDataInput in, boolean readType, boolean readKeyId) throws IOException, IgniteCheckedException {
        int keyId;
        int grpId = in.readInt();
        int encRecSz = in.readInt();
        WALRecord.RecordType plainRecType = readType ? RecordV1Serializer.readRecordType(in) : null;
        int n = keyId = readKeyId ? in.readUnsignedByte() : 0;
        if (this.encMgr == null || this.encSpi == null) {
            int skipped = in.skipBytes(encRecSz);
            assert (skipped == encRecSz);
            return new DecryptionResult(null, plainRecType, grpId);
        }
        GroupKey grpKey = this.encMgr.groupKey(grpId, keyId);
        if (grpKey == null) {
            int skipped = in.skipBytes(encRecSz);
            assert (skipped == encRecSz);
            return new DecryptionResult(null, plainRecType, grpId);
        }
        byte[] encData = new byte[encRecSz];
        in.readFully(encData);
        byte[] clData = this.encSpi.decrypt(encData, grpKey.key());
        return new DecryptionResult(ByteBuffer.wrap(clData), plainRecType, grpId);
    }

    private void writeEncryptedData(int grpId, @Nullable WALRecord.RecordType plainRecType, ByteBuffer clData, ByteBuffer dst) {
        int dtSz = this.encSpi.encryptedSize(clData.capacity());
        dst.putInt(grpId);
        dst.putInt(dtSz);
        if (plainRecType != null) {
            RecordV1Serializer.putRecordType(dst, plainRecType);
        }
        GroupKey grpKey = this.encMgr.getActiveKey(grpId);
        dst.put(grpKey.id());
        this.encSpi.encrypt(clData, grpKey.key(), dst);
    }

    int plainSize(WALRecord record) throws IgniteCheckedException {
        switch (record.type()) {
            case PAGE_RECORD: {
                assert (record instanceof PageSnapshot);
                PageSnapshot pageRec = (PageSnapshot)record;
                return pageRec.pageDataSize() + 12;
            }
            case CHECKPOINT_RECORD: {
                CheckpointRecord cpRec = (CheckpointRecord)record;
                assert (cpRec.checkpointMark() == null || cpRec.checkpointMark() instanceof FileWALPointer) : "Invalid WAL record: " + cpRec;
                int cacheStatesSize = this.cacheStatesSize(cpRec.cacheGroupStates());
                FileWALPointer walPtr = (FileWALPointer)cpRec.checkpointMark();
                return 18 + cacheStatesSize + (walPtr == null ? 0 : 16);
            }
            case META_PAGE_INIT: {
                return 32;
            }
            case INDEX_META_PAGE_DELTA_RECORD: {
                return 20;
            }
            case PARTITION_META_PAGE_UPDATE_COUNTERS: {
                return 45;
            }
            case PARTITION_META_PAGE_UPDATE_COUNTERS_V2: {
                return 53;
            }
            case PARTITION_META_PAGE_DELTA_RECORD_V3: {
                return 61;
            }
            case PARTITION_META_PAGE_DELTA_RECORD_V4: {
                return 69;
            }
            case MEMORY_RECOVERY: {
                return 8;
            }
            case PARTITION_DESTROY: {
                return 8;
            }
            case DATA_RECORD_V2: {
                DataRecord dataRec = (DataRecord)record;
                return 4 + this.dataSize(dataRec);
            }
            case METASTORE_DATA_RECORD: {
                MetastoreDataRecord metastoreDataRec = (MetastoreDataRecord)record;
                return 4 + metastoreDataRec.key().getBytes().length + 4 + (metastoreDataRec.value() != null ? metastoreDataRec.value().length : 0);
            }
            case HEADER_RECORD: {
                return 12;
            }
            case DATA_PAGE_INSERT_RECORD: {
                DataPageInsertRecord diRec = (DataPageInsertRecord)record;
                return 14 + diRec.payload().length;
            }
            case DATA_PAGE_UPDATE_RECORD: {
                DataPageUpdateRecord uRec = (DataPageUpdateRecord)record;
                return 18 + uRec.payload().length;
            }
            case DATA_PAGE_INSERT_FRAGMENT_RECORD: {
                DataPageInsertFragmentRecord difRec = (DataPageInsertFragmentRecord)record;
                return 24 + difRec.payloadSize();
            }
            case DATA_PAGE_REMOVE_RECORD: {
                return 13;
            }
            case DATA_PAGE_SET_FREE_LIST_PAGE: {
                return 20;
            }
            case MVCC_DATA_PAGE_MARK_UPDATED_RECORD: {
                return 36;
            }
            case MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD: {
                return 17;
            }
            case MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD: {
                return 17;
            }
            case INIT_NEW_PAGE_RECORD: {
                return 24;
            }
            case BTREE_META_PAGE_INIT_ROOT: {
                return 20;
            }
            case BTREE_META_PAGE_INIT_ROOT2: {
                return 22;
            }
            case BTREE_META_PAGE_INIT_ROOT_V3: {
                return 61;
            }
            case BTREE_META_PAGE_ADD_ROOT: {
                return 20;
            }
            case BTREE_META_PAGE_CUT_ROOT: {
                return 12;
            }
            case BTREE_INIT_NEW_ROOT: {
                NewRootInitRecord riRec = (NewRootInitRecord)record;
                return 40 + riRec.io().getItemSize();
            }
            case BTREE_PAGE_RECYCLE: {
                return 20;
            }
            case BTREE_PAGE_INSERT: {
                InsertRecord inRec = (InsertRecord)record;
                return 26 + inRec.io().getItemSize();
            }
            case BTREE_FIX_LEFTMOST_CHILD: {
                return 20;
            }
            case BTREE_FIX_COUNT: {
                return 14;
            }
            case BTREE_PAGE_REPLACE: {
                ReplaceRecord rRec = (ReplaceRecord)record;
                return 18 + rRec.io().getItemSize();
            }
            case BTREE_PAGE_REMOVE: {
                return 16;
            }
            case BTREE_PAGE_INNER_REPLACE: {
                return 32;
            }
            case BTREE_FORWARD_PAGE_SPLIT: {
                return 36;
            }
            case BTREE_EXISTING_PAGE_SPLIT: {
                return 22;
            }
            case BTREE_PAGE_MERGE: {
                return 31;
            }
            case BTREE_FIX_REMOVE_ID: {
                return 20;
            }
            case PAGES_LIST_SET_NEXT: {
                return 20;
            }
            case PAGES_LIST_SET_PREVIOUS: {
                return 20;
            }
            case PAGES_LIST_INIT_NEW_PAGE: {
                return 44;
            }
            case PAGES_LIST_ADD_PAGE: {
                return 20;
            }
            case PAGES_LIST_REMOVE_PAGE: {
                return 20;
            }
            case TRACKING_PAGE_DELTA: {
                return 36;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: {
                return 28;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: {
                return 20;
            }
            case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: {
                return 20;
            }
            case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                return 16;
            }
            case PART_META_UPDATE_STATE: {
                return 17;
            }
            case PAGE_LIST_META_RESET_COUNT_RECORD: {
                return 12;
            }
            case ROTATED_ID_PART_RECORD: {
                return 13;
            }
            case SWITCH_SEGMENT_RECORD: {
                return 0;
            }
            case TX_RECORD: {
                return this.txRecordSerializer.size((TxRecord)record);
            }
            case MASTER_KEY_CHANGE_RECORD_V2: {
                return ((MasterKeyChangeRecordV2)record).dataSize();
            }
            case REENCRYPTION_START_RECORD: {
                return ((ReencryptionStartRecord)record).dataSize();
            }
            case INDEX_ROOT_PAGE_RENAME_RECORD: {
                return ((IndexRenameRootPageRecord)record).dataSize();
            }
            case PARTITION_CLEARING_START_RECORD: {
                return 16;
            }
            case CLUSTER_SNAPSHOT: {
                return 4 + ((ClusterSnapshotRecord)record).clusterSnapshotName().getBytes().length;
            }
            case INCREMENTAL_SNAPSHOT_START_RECORD: {
                return 16;
            }
            case INCREMENTAL_SNAPSHOT_FINISH_RECORD: {
                return ((IncrementalSnapshotFinishRecord)record).dataSize();
            }
        }
        throw new UnsupportedOperationException("Type: " + (Object)((Object)record.type()));
    }

    WALRecord readPlainRecord(WALRecord.RecordType type, ByteBufferBackedDataInput in, boolean encrypted, int recordSize) throws IOException, IgniteCheckedException {
        WALRecord res;
        switch (type) {
            case PAGE_RECORD: {
                byte[] arr = new byte[this.pageSize];
                int cacheId = in.readInt();
                long pageId = in.readLong();
                in.readFully(arr);
                res = new PageSnapshot(new FullPageId(pageId, cacheId), arr, encrypted ? this.realPageSize : this.pageSize);
                break;
            }
            case CHECKPOINT_RECORD: {
                long msb = in.readLong();
                long lsb = in.readLong();
                boolean hasPtr = in.readByte() != 0;
                long idx = hasPtr ? in.readLong() : 0L;
                int off = hasPtr ? in.readInt() : 0;
                int len = hasPtr ? in.readInt() : 0;
                Map<Integer, CacheState> states = this.readPartitionStates(in);
                boolean end = in.readByte() != 0;
                FileWALPointer walPtr = hasPtr ? new FileWALPointer(idx, off, len) : null;
                CheckpointRecord cpRec = new CheckpointRecord(new UUID(msb, lsb), walPtr, end);
                cpRec.cacheGroupStates(states);
                res = cpRec;
                break;
            }
            case META_PAGE_INIT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                long treeRoot = in.readLong();
                long reuseListRoot = in.readLong();
                res = new MetaPageInitRecord(cacheId, pageId, ioType, ioVer, treeRoot, reuseListRoot, this.log);
                break;
            }
            case INDEX_META_PAGE_DELTA_RECORD: {
                res = new MetaPageUpdateIndexDataRecord(in);
                break;
            }
            case PARTITION_META_PAGE_UPDATE_COUNTERS: {
                res = new MetaPageUpdatePartitionDataRecord(in);
                break;
            }
            case PARTITION_META_PAGE_UPDATE_COUNTERS_V2: {
                res = new MetaPageUpdatePartitionDataRecordV2(in);
                break;
            }
            case PARTITION_META_PAGE_DELTA_RECORD_V3: {
                res = new MetaPageUpdatePartitionDataRecordV3(in);
                break;
            }
            case PARTITION_META_PAGE_DELTA_RECORD_V4: {
                res = new MetaPageUpdatePartitionDataRecordV4(in);
                break;
            }
            case MEMORY_RECOVERY: {
                long ts = in.readLong();
                res = new MemoryRecoveryRecord(ts);
                break;
            }
            case PARTITION_DESTROY: {
                int cacheId = in.readInt();
                int partId = in.readInt();
                res = new PartitionDestroyRecord(cacheId, partId);
                break;
            }
            case DATA_RECORD_V2: 
            case DATA_RECORD: {
                int entryCnt = in.readInt();
                ArrayList<DataEntry> entries = new ArrayList<DataEntry>(entryCnt);
                for (int i = 0; i < entryCnt; ++i) {
                    entries.add(this.readPlainDataEntry(in, type));
                }
                res = new DataRecord(entries, 0L);
                break;
            }
            case ENCRYPTED_DATA_RECORD: 
            case ENCRYPTED_DATA_RECORD_V2: 
            case ENCRYPTED_DATA_RECORD_V3: {
                int entryCnt = in.readInt();
                ArrayList<DataEntry> entries = new ArrayList<DataEntry>(entryCnt);
                for (int i = 0; i < entryCnt; ++i) {
                    entries.add(this.readEncryptedDataEntry(in, type));
                }
                res = new DataRecord(entries, 0L);
                break;
            }
            case METASTORE_DATA_RECORD: {
                byte[] val;
                int strLen = in.readInt();
                byte[] strBytes = new byte[strLen];
                in.readFully(strBytes);
                String key = new String(strBytes);
                int valLen = in.readInt();
                assert (valLen >= 0);
                if (valLen > 0) {
                    val = new byte[valLen];
                    in.readFully(val);
                } else {
                    val = null;
                }
                return new MetastoreDataRecord(key, val);
            }
            case HEADER_RECORD: {
                long magic = in.readLong();
                if (magic != -5705984118950656934L && magic != 5622654036411574606L) {
                    throw new EOFException("Magic is corrupted [actual=" + U.hexLong(magic) + ']');
                }
                int ver = in.readInt();
                res = new HeaderRecord(ver);
                break;
            }
            case DATA_PAGE_INSERT_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int size = in.readUnsignedShort();
                in.ensure(size);
                byte[] payload = new byte[size];
                in.readFully(payload);
                res = new DataPageInsertRecord(cacheId, pageId, payload);
                break;
            }
            case DATA_PAGE_UPDATE_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemId = in.readInt();
                int size = in.readUnsignedShort();
                in.ensure(size);
                byte[] payload = new byte[size];
                in.readFully(payload);
                res = new DataPageUpdateRecord(cacheId, pageId, itemId, payload);
                break;
            }
            case DATA_PAGE_INSERT_FRAGMENT_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long lastLink = in.readLong();
                int payloadSize = in.readInt();
                byte[] payload = new byte[payloadSize];
                in.readFully(payload);
                res = new DataPageInsertFragmentRecord(cacheId, pageId, payload, lastLink);
                break;
            }
            case DATA_PAGE_REMOVE_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemId = in.readUnsignedByte();
                res = new DataPageRemoveRecord(cacheId, pageId, itemId);
                break;
            }
            case DATA_PAGE_SET_FREE_LIST_PAGE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long freeListPage = in.readLong();
                res = new DataPageSetFreeListPageRecord(cacheId, pageId, freeListPage);
                break;
            }
            case MVCC_DATA_PAGE_MARK_UPDATED_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemId = in.readInt();
                long newMvccCrd = in.readLong();
                long newMvccCntr = in.readLong();
                int newMvccOpCntr = in.readInt();
                res = new DataPageMvccMarkUpdatedRecord(cacheId, pageId, itemId, newMvccCrd, newMvccCntr, newMvccOpCntr);
                break;
            }
            case MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemId = in.readInt();
                byte txState = in.readByte();
                res = new DataPageMvccUpdateTxStateHintRecord(cacheId, pageId, itemId, txState);
                break;
            }
            case MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemId = in.readInt();
                byte newTxState = in.readByte();
                res = new DataPageMvccUpdateNewTxStateHintRecord(cacheId, pageId, itemId, newTxState);
                break;
            }
            case INIT_NEW_PAGE_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                long virtualPageId = in.readLong();
                res = new InitNewPageRecord(cacheId, pageId, ioType, ioVer, virtualPageId, this.log);
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rootId = in.readLong();
                res = new MetaPageInitRootRecord(cacheId, pageId, rootId);
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT2: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rootId2 = in.readLong();
                short inlineSize = in.readShort();
                res = new MetaPageInitRootInlineRecord(cacheId, pageId, rootId2, inlineSize);
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT_V3: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rootId3 = in.readLong();
                short inlineSize3 = in.readShort();
                long flags = in.readLong();
                byte[] revHash = new byte[20];
                byte maj = in.readByte();
                byte min = in.readByte();
                byte maint = in.readByte();
                long verTs = in.readLong();
                in.readFully(revHash);
                IgniteProductVersion createdVer = new IgniteProductVersion(maj, min, maint, verTs, revHash);
                res = new MetaPageInitRootInlineFlagsCreatedVersionRecord(cacheId, pageId, rootId3, inlineSize3, flags, createdVer);
                break;
            }
            case BTREE_META_PAGE_ADD_ROOT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rootId = in.readLong();
                res = new MetaPageAddRootRecord(cacheId, pageId, rootId);
                break;
            }
            case BTREE_META_PAGE_CUT_ROOT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                res = new MetaPageCutRootRecord(cacheId, pageId);
                break;
            }
            case BTREE_INIT_NEW_ROOT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rootId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                long leftId = in.readLong();
                long rightId = in.readLong();
                Object io = BPlusIO.getBPlusIO(ioType, ioVer);
                byte[] rowBytes = new byte[((BPlusIO)io).getItemSize()];
                in.readFully(rowBytes);
                res = new NewRootInitRecord(cacheId, pageId, rootId, (BPlusInnerIO)io, leftId, rowBytes, rightId);
                break;
            }
            case BTREE_PAGE_RECYCLE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long newPageId = in.readLong();
                res = new RecycleRecord(cacheId, pageId, newPageId);
                break;
            }
            case BTREE_PAGE_INSERT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                int itemIdx = in.readUnsignedShort();
                long rightId = in.readLong();
                Object io = BPlusIO.getBPlusIO(ioType, ioVer);
                byte[] rowBytes = new byte[((BPlusIO)io).getItemSize()];
                in.readFully(rowBytes);
                res = new InsertRecord(cacheId, pageId, io, itemIdx, rowBytes, rightId);
                break;
            }
            case BTREE_FIX_LEFTMOST_CHILD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rightId = in.readLong();
                res = new FixLeftmostChildRecord(cacheId, pageId, rightId);
                break;
            }
            case BTREE_FIX_COUNT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int cnt = in.readUnsignedShort();
                res = new FixCountRecord(cacheId, pageId, cnt);
                break;
            }
            case BTREE_PAGE_REPLACE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                int itemIdx = in.readUnsignedShort();
                Object io = BPlusIO.getBPlusIO(ioType, ioVer);
                byte[] rowBytes = new byte[((BPlusIO)io).getItemSize()];
                in.readFully(rowBytes);
                res = new ReplaceRecord(cacheId, pageId, io, rowBytes, itemIdx);
                break;
            }
            case BTREE_PAGE_REMOVE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int itemIdx = in.readUnsignedShort();
                int cnt = in.readUnsignedShort();
                res = new RemoveRecord(cacheId, pageId, itemIdx, cnt);
                break;
            }
            case BTREE_PAGE_INNER_REPLACE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int dstIdx = in.readUnsignedShort();
                long srcPageId = in.readLong();
                int srcIdx = in.readUnsignedShort();
                long rmvId = in.readLong();
                res = new InnerReplaceRecord(cacheId, pageId, dstIdx, srcPageId, srcIdx, rmvId);
                break;
            }
            case BTREE_FORWARD_PAGE_SPLIT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long fwdId = in.readLong();
                int ioType = in.readUnsignedShort();
                int ioVer = in.readUnsignedShort();
                long srcPageId = in.readLong();
                int mid = in.readUnsignedShort();
                int cnt = in.readUnsignedShort();
                res = new SplitForwardPageRecord(cacheId, pageId, fwdId, ioType, ioVer, srcPageId, mid, cnt);
                break;
            }
            case BTREE_EXISTING_PAGE_SPLIT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int mid = in.readUnsignedShort();
                long fwdId = in.readLong();
                res = new SplitExistingPageRecord(cacheId, pageId, mid, fwdId);
                break;
            }
            case BTREE_PAGE_MERGE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long prntId = in.readLong();
                int prntIdx = in.readUnsignedShort();
                long rightId = in.readLong();
                boolean emptyBranch = in.readBoolean();
                res = new MergeRecord(cacheId, pageId, prntId, prntIdx, rightId, emptyBranch);
                break;
            }
            case BTREE_FIX_REMOVE_ID: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rmvId = in.readLong();
                res = new FixRemoveId(cacheId, pageId, rmvId);
                break;
            }
            case PAGES_LIST_SET_NEXT: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long nextPageId = in.readLong();
                res = new PagesListSetNextRecord(cacheId, pageId, nextPageId);
                break;
            }
            case PAGES_LIST_SET_PREVIOUS: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long prevPageId = in.readLong();
                res = new PagesListSetPreviousRecord(cacheId, pageId, prevPageId);
                break;
            }
            case PAGES_LIST_INIT_NEW_PAGE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int ioType = in.readInt();
                int ioVer = in.readInt();
                long newPageId = in.readLong();
                long prevPageId = in.readLong();
                long addDataPageId = in.readLong();
                res = new PagesListInitNewPageRecord(cacheId, pageId, ioType, ioVer, newPageId, prevPageId, addDataPageId, this.log);
                break;
            }
            case PAGES_LIST_ADD_PAGE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long dataPageId = in.readLong();
                res = new PagesListAddPageRecord(cacheId, pageId, dataPageId);
                break;
            }
            case PAGES_LIST_REMOVE_PAGE: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long rmvdPageId = in.readLong();
                res = new PagesListRemovePageRecord(cacheId, pageId, rmvdPageId);
                break;
            }
            case TRACKING_PAGE_DELTA: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long pageIdToMark = in.readLong();
                long nextSnapshotId0 = in.readLong();
                long lastSuccessfulSnapshotId0 = in.readLong();
                res = new TrackingPageDeltaRecord(cacheId, pageId, pageIdToMark, nextSnapshotId0, lastSuccessfulSnapshotId0);
                break;
            }
            case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long nextSnapshotId = in.readLong();
                res = new MetaPageUpdateNextSnapshotId(cacheId, pageId, nextSnapshotId);
                break;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long lastSuccessfulFullSnapshotId = in.readLong();
                res = new MetaPageUpdateLastSuccessfulFullSnapshotId(cacheId, pageId, lastSuccessfulFullSnapshotId);
                break;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                long lastSuccessfulSnapshotId = in.readLong();
                long lastSuccessfulSnapshotTag = in.readLong();
                res = new MetaPageUpdateLastSuccessfulSnapshotId(cacheId, pageId, lastSuccessfulSnapshotId, lastSuccessfulSnapshotTag);
                break;
            }
            case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int lastAllocatedIdx = in.readInt();
                res = new MetaPageUpdateLastAllocatedIndex(cacheId, pageId, lastAllocatedIdx);
                break;
            }
            case PART_META_UPDATE_STATE: {
                int cacheId = in.readInt();
                int partId = in.readInt();
                byte state = in.readByte();
                long updateCntr = in.readLong();
                GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(state);
                res = new PartitionMetaStateRecord(cacheId, partId, partState, updateCntr);
                break;
            }
            case PAGE_LIST_META_RESET_COUNT_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                res = new PageListMetaResetCountRecord(cacheId, pageId);
                break;
            }
            case ROTATED_ID_PART_RECORD: {
                int cacheId = in.readInt();
                long pageId = in.readLong();
                int rotatedIdPart = in.readByte() & 0xFF;
                res = new RotatedIdPartRecord(cacheId, pageId, rotatedIdPart);
                break;
            }
            case SWITCH_SEGMENT_RECORD: {
                throw new EOFException("END OF SEGMENT");
            }
            case TX_RECORD: {
                res = this.txRecordSerializer.readTx(in);
                break;
            }
            case MASTER_KEY_CHANGE_RECORD_V2: 
            case MASTER_KEY_CHANGE_RECORD: {
                int keyNameLen = in.readInt();
                byte[] keyNameBytes = new byte[keyNameLen];
                in.readFully(keyNameBytes);
                String masterKeyName = new String(keyNameBytes);
                int keysCnt = in.readInt();
                ArrayList<T2<Integer, GroupKeyEncrypted>> grpKeys = new ArrayList<T2<Integer, GroupKeyEncrypted>>(keysCnt);
                boolean readKeyId = type == WALRecord.RecordType.MASTER_KEY_CHANGE_RECORD_V2;
                for (int i = 0; i < keysCnt; ++i) {
                    int grpId = in.readInt();
                    int keyId = readKeyId ? in.readByte() & 0xFF : 0;
                    int grpKeySize = in.readInt();
                    byte[] grpKey = new byte[grpKeySize];
                    in.readFully(grpKey);
                    grpKeys.add(new T2<Integer, GroupKeyEncrypted>(grpId, new GroupKeyEncrypted(keyId, grpKey)));
                }
                res = new MasterKeyChangeRecordV2(masterKeyName, grpKeys);
                break;
            }
            case REENCRYPTION_START_RECORD: {
                int grpsCnt = in.readInt();
                HashMap<Integer, Byte> map = U.newHashMap(grpsCnt);
                for (int i = 0; i < grpsCnt; ++i) {
                    int grpId = in.readInt();
                    byte keyId = in.readByte();
                    map.put(grpId, keyId);
                }
                res = new ReencryptionStartRecord(map);
                break;
            }
            case INDEX_ROOT_PAGE_RENAME_RECORD: {
                res = new IndexRenameRootPageRecord(in);
                break;
            }
            case PARTITION_CLEARING_START_RECORD: {
                int partId0 = in.readInt();
                int grpId = in.readInt();
                long clearVer = in.readLong();
                res = new PartitionClearingStartRecord(partId0, grpId, clearVer);
                break;
            }
            case CLUSTER_SNAPSHOT: {
                int snpNameLen = in.readInt();
                byte[] snpName = new byte[snpNameLen];
                in.readFully(snpName);
                res = new ClusterSnapshotRecord(new String(snpName));
                break;
            }
            case INCREMENTAL_SNAPSHOT_START_RECORD: {
                long mst = in.readLong();
                long lst = in.readLong();
                res = new IncrementalSnapshotStartRecord(new UUID(mst, lst));
                break;
            }
            case INCREMENTAL_SNAPSHOT_FINISH_RECORD: {
                long mstSignBits = in.readLong();
                long lstSignBits = in.readLong();
                Set<GridCacheVersion> included = this.readVersions(in);
                Set<GridCacheVersion> excluded = this.readVersions(in);
                res = new IncrementalSnapshotFinishRecord(new UUID(mstSignBits, lstSignBits), included, excluded);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type: " + (Object)((Object)type));
            }
        }
        return res;
    }

    void writePlainRecord(WALRecord rec, ByteBuffer buf) throws IgniteCheckedException {
        switch (rec.type()) {
            case PAGE_RECORD: {
                PageSnapshot snap = (PageSnapshot)rec;
                buf.putInt(snap.fullPageId().groupId());
                buf.putLong(snap.fullPageId().pageId());
                buf.put(snap.pageDataBuffer());
                break;
            }
            case MEMORY_RECOVERY: {
                MemoryRecoveryRecord memoryRecoveryRecord = (MemoryRecoveryRecord)rec;
                buf.putLong(memoryRecoveryRecord.time());
                break;
            }
            case PARTITION_DESTROY: {
                PartitionDestroyRecord partDestroy = (PartitionDestroyRecord)rec;
                buf.putInt(partDestroy.groupId());
                buf.putInt(partDestroy.partitionId());
                break;
            }
            case META_PAGE_INIT: {
                MetaPageInitRecord updRootsRec = (MetaPageInitRecord)rec;
                buf.putInt(updRootsRec.groupId());
                buf.putLong(updRootsRec.pageId());
                buf.putShort((short)updRootsRec.ioType());
                buf.putShort((short)updRootsRec.ioVersion());
                buf.putLong(updRootsRec.treeRoot());
                buf.putLong(updRootsRec.reuseListRoot());
                break;
            }
            case INDEX_META_PAGE_DELTA_RECORD: {
                ((MetaPageUpdateIndexDataRecord)rec).toBytes(buf);
                break;
            }
            case PARTITION_META_PAGE_UPDATE_COUNTERS: 
            case PARTITION_META_PAGE_UPDATE_COUNTERS_V2: 
            case PARTITION_META_PAGE_DELTA_RECORD_V3: 
            case PARTITION_META_PAGE_DELTA_RECORD_V4: {
                ((MetaPageUpdatePartitionDataRecord)rec).toBytes(buf);
                break;
            }
            case CHECKPOINT_RECORD: {
                CheckpointRecord cpRec = (CheckpointRecord)rec;
                assert (cpRec.checkpointMark() == null || cpRec.checkpointMark() instanceof FileWALPointer) : "Invalid WAL record: " + cpRec;
                FileWALPointer walPtr = (FileWALPointer)cpRec.checkpointMark();
                UUID cpId = cpRec.checkpointId();
                buf.putLong(cpId.getMostSignificantBits());
                buf.putLong(cpId.getLeastSignificantBits());
                buf.put(walPtr == null ? (byte)0 : 1);
                if (walPtr != null) {
                    buf.putLong(walPtr.index());
                    buf.putInt(walPtr.fileOffset());
                    buf.putInt(walPtr.length());
                }
                RecordDataV1Serializer.putCacheStates(buf, cpRec.cacheGroupStates());
                buf.put(cpRec.end() ? (byte)1 : 0);
                break;
            }
            case DATA_RECORD_V2: {
                DataRecord dataRec = (DataRecord)rec;
                buf.putInt(dataRec.writeEntries().size());
                boolean encrypted = this.isDataRecordEncrypted(dataRec);
                for (DataEntry dataEntry : dataRec.writeEntries()) {
                    if (encrypted) {
                        this.putEncryptedDataEntry(buf, dataEntry);
                        continue;
                    }
                    this.putPlainDataEntry(buf, dataEntry);
                }
                break;
            }
            case METASTORE_DATA_RECORD: {
                MetastoreDataRecord metastoreDataRecord = (MetastoreDataRecord)rec;
                byte[] strBytes = metastoreDataRecord.key().getBytes();
                buf.putInt(strBytes.length);
                buf.put(strBytes);
                if (metastoreDataRecord.value() != null) {
                    buf.putInt(metastoreDataRecord.value().length);
                    buf.put(metastoreDataRecord.value());
                    break;
                }
                buf.putInt(0);
                break;
            }
            case HEADER_RECORD: {
                buf.putLong(-5705984118950656934L);
                buf.putInt(((HeaderRecord)rec).version());
                break;
            }
            case DATA_PAGE_INSERT_RECORD: {
                DataPageInsertRecord diRec = (DataPageInsertRecord)rec;
                buf.putInt(diRec.groupId());
                buf.putLong(diRec.pageId());
                buf.putShort((short)diRec.payload().length);
                buf.put(diRec.payload());
                break;
            }
            case DATA_PAGE_UPDATE_RECORD: {
                DataPageUpdateRecord uRec = (DataPageUpdateRecord)rec;
                buf.putInt(uRec.groupId());
                buf.putLong(uRec.pageId());
                buf.putInt(uRec.itemId());
                buf.putShort((short)uRec.payload().length);
                buf.put(uRec.payload());
                break;
            }
            case DATA_PAGE_INSERT_FRAGMENT_RECORD: {
                DataPageInsertFragmentRecord difRec = (DataPageInsertFragmentRecord)rec;
                buf.putInt(difRec.groupId());
                buf.putLong(difRec.pageId());
                buf.putLong(difRec.lastLink());
                buf.putInt(difRec.payloadSize());
                buf.put(difRec.payload());
                break;
            }
            case DATA_PAGE_REMOVE_RECORD: {
                DataPageRemoveRecord drRec = (DataPageRemoveRecord)rec;
                buf.putInt(drRec.groupId());
                buf.putLong(drRec.pageId());
                buf.put((byte)drRec.itemId());
                break;
            }
            case DATA_PAGE_SET_FREE_LIST_PAGE: {
                DataPageSetFreeListPageRecord freeListRec = (DataPageSetFreeListPageRecord)rec;
                buf.putInt(freeListRec.groupId());
                buf.putLong(freeListRec.pageId());
                buf.putLong(freeListRec.freeListPage());
                break;
            }
            case MVCC_DATA_PAGE_MARK_UPDATED_RECORD: {
                DataPageMvccMarkUpdatedRecord rmvRec = (DataPageMvccMarkUpdatedRecord)rec;
                buf.putInt(rmvRec.groupId());
                buf.putLong(rmvRec.pageId());
                buf.putInt(rmvRec.itemId());
                buf.putLong(rmvRec.newMvccCrd());
                buf.putLong(rmvRec.newMvccCntr());
                buf.putInt(rmvRec.newMvccOpCntr());
                break;
            }
            case MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD: {
                DataPageMvccUpdateTxStateHintRecord txStRec = (DataPageMvccUpdateTxStateHintRecord)rec;
                buf.putInt(txStRec.groupId());
                buf.putLong(txStRec.pageId());
                buf.putInt(txStRec.itemId());
                buf.put(txStRec.txState());
                break;
            }
            case MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD: {
                DataPageMvccUpdateNewTxStateHintRecord newTxStRec = (DataPageMvccUpdateNewTxStateHintRecord)rec;
                buf.putInt(newTxStRec.groupId());
                buf.putLong(newTxStRec.pageId());
                buf.putInt(newTxStRec.itemId());
                buf.put(newTxStRec.txState());
                break;
            }
            case INIT_NEW_PAGE_RECORD: {
                InitNewPageRecord inpRec = (InitNewPageRecord)rec;
                buf.putInt(inpRec.groupId());
                buf.putLong(inpRec.pageId());
                buf.putShort((short)inpRec.ioType());
                buf.putShort((short)inpRec.ioVersion());
                buf.putLong(inpRec.newPageId());
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT: {
                MetaPageInitRootRecord imRec = (MetaPageInitRootRecord)rec;
                buf.putInt(imRec.groupId());
                buf.putLong(imRec.pageId());
                buf.putLong(imRec.rootId());
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT2: {
                MetaPageInitRootInlineRecord imRec2 = (MetaPageInitRootInlineRecord)rec;
                buf.putInt(imRec2.groupId());
                buf.putLong(imRec2.pageId());
                buf.putLong(imRec2.rootId());
                buf.putShort((short)imRec2.inlineSize());
                break;
            }
            case BTREE_META_PAGE_INIT_ROOT_V3: {
                MetaPageInitRootInlineFlagsCreatedVersionRecord imRec3 = (MetaPageInitRootInlineFlagsCreatedVersionRecord)rec;
                buf.putInt(imRec3.groupId());
                buf.putLong(imRec3.pageId());
                buf.putLong(imRec3.rootId());
                buf.putShort((short)imRec3.inlineSize());
                buf.putLong(imRec3.flags());
                IgniteProductVersion createdVer = imRec3.createdVersion();
                buf.put(createdVer.major());
                buf.put(createdVer.minor());
                buf.put(createdVer.maintenance());
                buf.putLong(createdVer.revisionTimestamp());
                buf.put(createdVer.revisionHash());
                break;
            }
            case BTREE_META_PAGE_ADD_ROOT: {
                MetaPageAddRootRecord arRec = (MetaPageAddRootRecord)rec;
                buf.putInt(arRec.groupId());
                buf.putLong(arRec.pageId());
                buf.putLong(arRec.rootId());
                break;
            }
            case BTREE_META_PAGE_CUT_ROOT: {
                MetaPageCutRootRecord crRec = (MetaPageCutRootRecord)rec;
                buf.putInt(crRec.groupId());
                buf.putLong(crRec.pageId());
                break;
            }
            case BTREE_INIT_NEW_ROOT: {
                NewRootInitRecord riRec = (NewRootInitRecord)rec;
                buf.putInt(riRec.groupId());
                buf.putLong(riRec.pageId());
                buf.putLong(riRec.rootId());
                buf.putShort((short)riRec.io().getType());
                buf.putShort((short)riRec.io().getVersion());
                buf.putLong(riRec.leftId());
                buf.putLong(riRec.rightId());
                RecordDataV1Serializer.putRow(buf, riRec.rowBytes());
                break;
            }
            case BTREE_PAGE_RECYCLE: {
                RecycleRecord recRec = (RecycleRecord)rec;
                buf.putInt(recRec.groupId());
                buf.putLong(recRec.pageId());
                buf.putLong(recRec.newPageId());
                break;
            }
            case BTREE_PAGE_INSERT: {
                InsertRecord inRec = (InsertRecord)rec;
                buf.putInt(inRec.groupId());
                buf.putLong(inRec.pageId());
                buf.putShort((short)inRec.io().getType());
                buf.putShort((short)inRec.io().getVersion());
                buf.putShort((short)inRec.index());
                buf.putLong(inRec.rightId());
                RecordDataV1Serializer.putRow(buf, inRec.rowBytes());
                break;
            }
            case BTREE_FIX_LEFTMOST_CHILD: {
                FixLeftmostChildRecord flRec = (FixLeftmostChildRecord)rec;
                buf.putInt(flRec.groupId());
                buf.putLong(flRec.pageId());
                buf.putLong(flRec.rightId());
                break;
            }
            case BTREE_FIX_COUNT: {
                FixCountRecord fcRec = (FixCountRecord)rec;
                buf.putInt(fcRec.groupId());
                buf.putLong(fcRec.pageId());
                buf.putShort((short)fcRec.count());
                break;
            }
            case BTREE_PAGE_REPLACE: {
                ReplaceRecord rRec = (ReplaceRecord)rec;
                buf.putInt(rRec.groupId());
                buf.putLong(rRec.pageId());
                buf.putShort((short)rRec.io().getType());
                buf.putShort((short)rRec.io().getVersion());
                buf.putShort((short)rRec.index());
                RecordDataV1Serializer.putRow(buf, rRec.rowBytes());
                break;
            }
            case BTREE_PAGE_REMOVE: {
                RemoveRecord rmRec = (RemoveRecord)rec;
                buf.putInt(rmRec.groupId());
                buf.putLong(rmRec.pageId());
                buf.putShort((short)rmRec.index());
                buf.putShort((short)rmRec.count());
                break;
            }
            case BTREE_PAGE_INNER_REPLACE: {
                InnerReplaceRecord irRec = (InnerReplaceRecord)rec;
                buf.putInt(irRec.groupId());
                buf.putLong(irRec.pageId());
                buf.putShort((short)irRec.destinationIndex());
                buf.putLong(irRec.sourcePageId());
                buf.putShort((short)irRec.sourceIndex());
                buf.putLong(irRec.removeId());
                break;
            }
            case BTREE_FORWARD_PAGE_SPLIT: {
                SplitForwardPageRecord sfRec = (SplitForwardPageRecord)rec;
                buf.putInt(sfRec.groupId());
                buf.putLong(sfRec.pageId());
                buf.putLong(sfRec.forwardId());
                buf.putShort((short)sfRec.ioType());
                buf.putShort((short)sfRec.ioVersion());
                buf.putLong(sfRec.sourcePageId());
                buf.putShort((short)sfRec.middleIndex());
                buf.putShort((short)sfRec.count());
                break;
            }
            case BTREE_EXISTING_PAGE_SPLIT: {
                SplitExistingPageRecord seRec = (SplitExistingPageRecord)rec;
                buf.putInt(seRec.groupId());
                buf.putLong(seRec.pageId());
                buf.putShort((short)seRec.middleIndex());
                buf.putLong(seRec.forwardId());
                break;
            }
            case BTREE_PAGE_MERGE: {
                MergeRecord mRec = (MergeRecord)rec;
                buf.putInt(mRec.groupId());
                buf.putLong(mRec.pageId());
                buf.putLong(mRec.parentId());
                buf.putShort((short)mRec.parentIndex());
                buf.putLong(mRec.rightId());
                buf.put((byte)(mRec.isEmptyBranch() ? 1 : 0));
                break;
            }
            case PAGES_LIST_SET_NEXT: {
                PagesListSetNextRecord plNextRec = (PagesListSetNextRecord)rec;
                buf.putInt(plNextRec.groupId());
                buf.putLong(plNextRec.pageId());
                buf.putLong(plNextRec.nextPageId());
                break;
            }
            case PAGES_LIST_SET_PREVIOUS: {
                PagesListSetPreviousRecord plPrevRec = (PagesListSetPreviousRecord)rec;
                buf.putInt(plPrevRec.groupId());
                buf.putLong(plPrevRec.pageId());
                buf.putLong(plPrevRec.previousPageId());
                break;
            }
            case PAGES_LIST_INIT_NEW_PAGE: {
                PagesListInitNewPageRecord plNewRec = (PagesListInitNewPageRecord)rec;
                buf.putInt(plNewRec.groupId());
                buf.putLong(plNewRec.pageId());
                buf.putInt(plNewRec.ioType());
                buf.putInt(plNewRec.ioVersion());
                buf.putLong(plNewRec.newPageId());
                buf.putLong(plNewRec.previousPageId());
                buf.putLong(plNewRec.dataPageId());
                break;
            }
            case PAGES_LIST_ADD_PAGE: {
                PagesListAddPageRecord plAddRec = (PagesListAddPageRecord)rec;
                buf.putInt(plAddRec.groupId());
                buf.putLong(plAddRec.pageId());
                buf.putLong(plAddRec.dataPageId());
                break;
            }
            case PAGES_LIST_REMOVE_PAGE: {
                PagesListRemovePageRecord plRmvRec = (PagesListRemovePageRecord)rec;
                buf.putInt(plRmvRec.groupId());
                buf.putLong(plRmvRec.pageId());
                buf.putLong(plRmvRec.removedPageId());
                break;
            }
            case BTREE_FIX_REMOVE_ID: {
                FixRemoveId frRec = (FixRemoveId)rec;
                buf.putInt(frRec.groupId());
                buf.putLong(frRec.pageId());
                buf.putLong(frRec.removeId());
                break;
            }
            case TRACKING_PAGE_DELTA: {
                TrackingPageDeltaRecord tpDelta = (TrackingPageDeltaRecord)rec;
                buf.putInt(tpDelta.groupId());
                buf.putLong(tpDelta.pageId());
                buf.putLong(tpDelta.pageIdToMark());
                buf.putLong(tpDelta.nextSnapshotTag());
                buf.putLong(tpDelta.lastSuccessfulSnapshotTag());
                break;
            }
            case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: {
                MetaPageUpdateNextSnapshotId mpUpdateNextSnapshotId = (MetaPageUpdateNextSnapshotId)rec;
                buf.putInt(mpUpdateNextSnapshotId.groupId());
                buf.putLong(mpUpdateNextSnapshotId.pageId());
                buf.putLong(mpUpdateNextSnapshotId.nextSnapshotId());
                break;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: {
                MetaPageUpdateLastSuccessfulFullSnapshotId mpUpdateLastSuccFullSnapshotId = (MetaPageUpdateLastSuccessfulFullSnapshotId)rec;
                buf.putInt(mpUpdateLastSuccFullSnapshotId.groupId());
                buf.putLong(mpUpdateLastSuccFullSnapshotId.pageId());
                buf.putLong(mpUpdateLastSuccFullSnapshotId.lastSuccessfulFullSnapshotId());
                break;
            }
            case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: {
                MetaPageUpdateLastSuccessfulSnapshotId mpUpdateLastSuccSnapshotId = (MetaPageUpdateLastSuccessfulSnapshotId)rec;
                buf.putInt(mpUpdateLastSuccSnapshotId.groupId());
                buf.putLong(mpUpdateLastSuccSnapshotId.pageId());
                buf.putLong(mpUpdateLastSuccSnapshotId.lastSuccessfulSnapshotId());
                buf.putLong(mpUpdateLastSuccSnapshotId.lastSuccessfulSnapshotTag());
                break;
            }
            case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                MetaPageUpdateLastAllocatedIndex mpUpdateLastAllocatedIdx = (MetaPageUpdateLastAllocatedIndex)rec;
                buf.putInt(mpUpdateLastAllocatedIdx.groupId());
                buf.putLong(mpUpdateLastAllocatedIdx.pageId());
                buf.putInt(mpUpdateLastAllocatedIdx.lastAllocatedIndex());
                break;
            }
            case PART_META_UPDATE_STATE: {
                PartitionMetaStateRecord partMetaStateRecord = (PartitionMetaStateRecord)rec;
                buf.putInt(partMetaStateRecord.groupId());
                buf.putInt(partMetaStateRecord.partitionId());
                buf.put(partMetaStateRecord.state());
                buf.putLong(0L);
                break;
            }
            case PAGE_LIST_META_RESET_COUNT_RECORD: {
                PageListMetaResetCountRecord pageListMetaResetCntRecord = (PageListMetaResetCountRecord)rec;
                buf.putInt(pageListMetaResetCntRecord.groupId());
                buf.putLong(pageListMetaResetCntRecord.pageId());
                break;
            }
            case ROTATED_ID_PART_RECORD: {
                RotatedIdPartRecord rotatedIdPartRecord = (RotatedIdPartRecord)rec;
                buf.putInt(rotatedIdPartRecord.groupId());
                buf.putLong(rotatedIdPartRecord.pageId());
                buf.put(rotatedIdPartRecord.rotatedIdPart());
                break;
            }
            case TX_RECORD: {
                this.txRecordSerializer.write((TxRecord)rec, buf);
                break;
            }
            case SWITCH_SEGMENT_RECORD: {
                break;
            }
            case MASTER_KEY_CHANGE_RECORD_V2: {
                MasterKeyChangeRecordV2 mkChangeRec = (MasterKeyChangeRecordV2)rec;
                byte[] keyIdBytes = mkChangeRec.getMasterKeyName().getBytes();
                buf.putInt(keyIdBytes.length);
                buf.put(keyIdBytes);
                List<T2<Integer, GroupKeyEncrypted>> grpKeys = mkChangeRec.getGrpKeys();
                buf.putInt(grpKeys.size());
                for (T2<Integer, GroupKeyEncrypted> entry : grpKeys) {
                    GroupKeyEncrypted grpKey = (GroupKeyEncrypted)entry.get2();
                    buf.putInt((Integer)entry.get1());
                    buf.put((byte)grpKey.id());
                    buf.putInt(grpKey.key().length);
                    buf.put(grpKey.key());
                }
                break;
            }
            case REENCRYPTION_START_RECORD: {
                ReencryptionStartRecord statusRecord = (ReencryptionStartRecord)rec;
                Map<Integer, Byte> grps = statusRecord.groups();
                buf.putInt(grps.size());
                for (Map.Entry<Integer, Byte> e : grps.entrySet()) {
                    buf.putInt(e.getKey());
                    buf.put(e.getValue());
                }
                break;
            }
            case INDEX_ROOT_PAGE_RENAME_RECORD: {
                ((IndexRenameRootPageRecord)rec).writeRecord(buf);
                break;
            }
            case PARTITION_CLEARING_START_RECORD: {
                PartitionClearingStartRecord partitionClearingStartRecord = (PartitionClearingStartRecord)rec;
                buf.putInt(partitionClearingStartRecord.partitionId());
                buf.putInt(partitionClearingStartRecord.groupId());
                buf.putLong(partitionClearingStartRecord.clearVersion());
                break;
            }
            case INCREMENTAL_SNAPSHOT_START_RECORD: {
                IncrementalSnapshotStartRecord startRec = (IncrementalSnapshotStartRecord)rec;
                buf.putLong(startRec.id().getMostSignificantBits());
                buf.putLong(startRec.id().getLeastSignificantBits());
                break;
            }
            case INCREMENTAL_SNAPSHOT_FINISH_RECORD: {
                IncrementalSnapshotFinishRecord incSnpFinRec = (IncrementalSnapshotFinishRecord)rec;
                buf.putLong(incSnpFinRec.id().getMostSignificantBits());
                buf.putLong(incSnpFinRec.id().getLeastSignificantBits());
                buf.putInt(incSnpFinRec.included().size());
                for (GridCacheVersion v : incSnpFinRec.included()) {
                    RecordDataV1Serializer.putVersion(buf, v, false);
                }
                buf.putInt(incSnpFinRec.excluded().size());
                for (GridCacheVersion v : incSnpFinRec.excluded()) {
                    RecordDataV1Serializer.putVersion(buf, v, false);
                }
                break;
            }
            case CLUSTER_SNAPSHOT: {
                byte[] snpName = ((ClusterSnapshotRecord)rec).clusterSnapshotName().getBytes();
                buf.putInt(snpName.length);
                buf.put(snpName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Type: " + (Object)((Object)rec.type()));
            }
        }
    }

    public GridCacheSharedContext cctx() {
        return this.cctx;
    }

    void putEncryptedDataEntry(ByteBuffer buf, DataEntry entry) throws IgniteCheckedException {
        DynamicCacheDescriptor desc = this.cctx.cache().cacheDescriptor(entry.cacheId());
        if (desc != null && this.needEncryption(desc.groupId())) {
            int clSz = this.entrySize(entry);
            ByteBuffer clData = ByteBuffer.allocate(clSz);
            this.putPlainDataEntry(clData, entry);
            clData.rewind();
            buf.put((byte)1);
            this.writeEncryptedData(desc.groupId(), null, clData, buf);
        } else {
            buf.put((byte)0);
            this.putPlainDataEntry(buf, entry);
        }
    }

    void putPlainDataEntry(ByteBuffer buf, DataEntry entry) throws IgniteCheckedException {
        buf.putInt(entry.cacheId());
        if (!entry.key().putValue(buf)) {
            throw new AssertionError();
        }
        if (entry.value() == null) {
            buf.putInt(-1);
        } else if (!entry.value().putValue(buf)) {
            throw new AssertionError();
        }
        buf.put((byte)entry.op().ordinal());
        RecordDataV1Serializer.putVersion(buf, entry.nearXidVersion(), true);
        RecordDataV1Serializer.putVersion(buf, entry.writeVersion(), false);
        buf.putInt(entry.partitionId());
        buf.putLong(entry.partitionCounter());
        buf.putLong(entry.expireTime());
        if (!(entry instanceof MvccDataEntry)) {
            buf.put(entry.flags());
        }
    }

    private static void putCacheStates(ByteBuffer buf, Map<Integer, CacheState> states) {
        buf.putShort((short)states.size());
        for (Map.Entry<Integer, CacheState> entry : states.entrySet()) {
            buf.putInt(entry.getKey());
            CacheState state = entry.getValue();
            buf.putShort((short)state.size());
            for (int i = 0; i < state.size(); ++i) {
                buf.putShort((short)state.partitionByIndex(i));
                buf.putLong(state.partitionSizeByIndex(i));
                buf.putLong(state.partitionCounterByIndex(i));
            }
        }
    }

    static void putVersion(ByteBuffer buf, GridCacheVersion ver, boolean allowNull) {
        CacheVersionIO.write(buf, ver, allowNull);
    }

    private static void putRow(ByteBuffer buf, byte[] rowBytes) {
        assert (rowBytes.length > 0);
        buf.put(rowBytes);
    }

    DataEntry readEncryptedDataEntry(ByteBufferBackedDataInput in, WALRecord.RecordType recType) throws IOException, IgniteCheckedException {
        WALRecord.RecordType dataRecordType;
        boolean needDecryption = in.readByte() == 1;
        WALRecord.RecordType recordType = dataRecordType = recType == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V3 || recType == WALRecord.RecordType.ENCRYPTED_OUT_OF_ORDER_UPDATE ? WALRecord.RecordType.DATA_RECORD_V2 : WALRecord.RecordType.DATA_RECORD;
        if (needDecryption) {
            boolean readKeyId = recType == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V2 || recType == WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V3 || recType == WALRecord.RecordType.ENCRYPTED_OUT_OF_ORDER_UPDATE;
            DecryptionResult decryptionResult = this.readEncryptedData(in, false, readKeyId);
            return decryptionResult.isDecryptedSuccessfully() ? this.readPlainDataEntry(decryptionResult.decryptedData(), dataRecordType) : new EncryptedDataEntry();
        }
        return this.readPlainDataEntry(in, dataRecordType);
    }

    DataEntry readPlainDataEntry(ByteBufferBackedDataInput in, WALRecord.RecordType type) throws IOException, IgniteCheckedException {
        int cacheId = in.readInt();
        int keySize = in.readInt();
        byte keyType = in.readByte();
        byte[] keyBytes = new byte[keySize];
        in.readFully(keyBytes);
        int valSize = in.readInt();
        byte valType = 0;
        byte[] valBytes = null;
        if (valSize >= 0) {
            valType = in.readByte();
            valBytes = new byte[valSize];
            in.readFully(valBytes);
        }
        byte ord = in.readByte();
        GridCacheOperation op = GridCacheOperation.fromOrdinal(ord & 0xFF);
        GridCacheVersion nearXidVer = this.readVersion(in, true);
        GridCacheVersion writeVer = this.readVersion(in, false);
        int partId = in.readInt();
        long partCntr = in.readLong();
        long expireTime = in.readLong();
        byte flags = type == WALRecord.RecordType.DATA_RECORD_V2 || type == WALRecord.RecordType.OUT_OF_ORDER_UPDATE || type == WALRecord.RecordType.CDC_DATA_RECORD ? in.readByte() : (byte)0;
        GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
        if (cacheCtx != null) {
            CacheObjectContext coCtx = cacheCtx.cacheObjectContext();
            KeyCacheObject key = this.co.toKeyCacheObject(coCtx, keyType, keyBytes);
            if (key.partition() == -1) {
                key.partition(partId);
            }
            CacheObject val = valBytes != null ? this.co.toCacheObject(coCtx, valType, valBytes) : null;
            return new DataEntry(cacheId, key, val, op, nearXidVer, writeVer, expireTime, partId, partCntr, flags);
        }
        return new LazyDataEntry(this.cctx, cacheId, keyType, keyBytes, valType, valBytes, op, nearXidVer, writeVer, expireTime, partId, partCntr, flags);
    }

    WALRecord.RecordType recordType(WALRecord rec) {
        if (this.encryptionDisabled) {
            return rec.type();
        }
        if (this.needEncryption(rec)) {
            return WALRecord.RecordType.ENCRYPTED_RECORD_V2;
        }
        if (rec.type() != WALRecord.RecordType.DATA_RECORD && rec.type() != WALRecord.RecordType.DATA_RECORD_V2 && rec.type() != WALRecord.RecordType.OUT_OF_ORDER_UPDATE) {
            return rec.type();
        }
        if (this.isDataRecordEncrypted((DataRecord)rec)) {
            return rec.type() == WALRecord.RecordType.OUT_OF_ORDER_UPDATE ? WALRecord.RecordType.ENCRYPTED_OUT_OF_ORDER_UPDATE : WALRecord.RecordType.ENCRYPTED_DATA_RECORD_V3;
        }
        return rec.type();
    }

    boolean isDataRecordEncrypted(DataRecord rec) {
        if (this.encryptionDisabled) {
            return false;
        }
        for (DataEntry e : rec.writeEntries()) {
            if (this.cctx.cacheContext(e.cacheId()) == null || !this.needEncryption(this.cctx.cacheContext(e.cacheId()).groupId())) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, CacheState> readPartitionStates(DataInput buf) throws IOException {
        int caches = buf.readShort() & 0xFFFF;
        if (caches == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, CacheState> states = new HashMap<Integer, CacheState>(caches, 1.0f);
        for (int i = 0; i < caches; ++i) {
            int cacheId = buf.readInt();
            int parts = buf.readShort() & 0xFFFF;
            CacheState state = new CacheState(parts);
            for (int p = 0; p < parts; ++p) {
                int partId = buf.readShort() & 0xFFFF;
                long size = buf.readLong();
                long partCntr = buf.readLong();
                state.addPartitionState(partId, size, partCntr);
            }
            states.put(cacheId, state);
        }
        return states;
    }

    GridCacheVersion readVersion(ByteBufferBackedDataInput in, boolean allowNull) throws IOException {
        in.ensure(1);
        try {
            int size = CacheVersionIO.readSize(in.buffer(), allowNull);
            in.ensure(size);
            return CacheVersionIO.read(in.buffer(), allowNull);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    private Set<GridCacheVersion> readVersions(ByteBufferBackedDataInput in) throws IOException {
        int txsSize = in.readInt();
        HashSet<GridCacheVersion> txs = new HashSet<GridCacheVersion>();
        for (int i = 0; i < txsSize; ++i) {
            GridCacheVersion v = this.readVersion(in, false);
            txs.add(v);
        }
        return txs;
    }

    protected int dataSize(DataRecord dataRec) throws IgniteCheckedException {
        boolean encrypted = this.isDataRecordEncrypted(dataRec);
        int sz = 0;
        for (DataEntry entry : dataRec.writeEntries()) {
            int clSz = this.entrySize(entry);
            if (!this.encryptionDisabled && this.needEncryption(this.cctx.cacheContext(entry.cacheId()).groupId())) {
                sz += this.encSpi.encryptedSize(clSz) + 1 + 4 + 4 + 1;
                continue;
            }
            sz += clSz;
            if (!encrypted) continue;
            ++sz;
        }
        return sz;
    }

    protected int entrySize(DataEntry entry) throws IgniteCheckedException {
        GridCacheContext cctx = this.cctx.cacheContext(entry.cacheId());
        CacheObjectContext coCtx = cctx.cacheObjectContext();
        return 4 + entry.key().valueBytesLength(coCtx) + (entry.value() == null ? 4 : entry.value().valueBytesLength(coCtx)) + 1 + CacheVersionIO.size(entry.nearXidVersion(), true) + CacheVersionIO.size(entry.writeVersion(), false) + 4 + 8 + 8 + (entry instanceof MvccDataEntry ? 0 : 1);
    }

    private int cacheStatesSize(Map<Integer, CacheState> states) {
        int size = 2;
        for (Map.Entry<Integer, CacheState> entry : states.entrySet()) {
            size += 4;
            size += 2;
            CacheState state = entry.getValue();
            size += 18 * state.size();
        }
        return size;
    }

    public static class EncryptedDataEntry
    extends DataEntry {
        EncryptedDataEntry() {
            super(0, null, null, GridCacheOperation.READ, null, null, 0L, 0, 0L, (byte)0);
        }
    }
}

