/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.crc;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public final class FastCrc {
    private static final ThreadLocal<CRC32> CRC = ThreadLocal.withInitial(CRC32::new);
    private final CRC32 crc = new CRC32();
    private int val;

    public FastCrc() {
        this.reset();
    }

    public void reset() {
        this.val = -1;
        this.crc.reset();
    }

    public int getValue() {
        return this.val;
    }

    public void update(ByteBuffer buf, int len) {
        this.val = FastCrc.calcCrc(this.crc, buf, len);
    }

    public static int calcCrc(ByteBuffer buf, int len) {
        CRC32 crcAlgo = CRC.get();
        int res = FastCrc.calcCrc(crcAlgo, buf, len);
        crcAlgo.reset();
        return res;
    }

    private static int calcCrc(CRC32 crcAlgo, ByteBuffer buf, int len) {
        int initLimit = buf.limit();
        buf.limit(buf.position() + len);
        crcAlgo.update(buf);
        buf.limit(initLimit);
        return ~((int)crcAlgo.getValue());
    }
}

