/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public class CheckpointPageReplacement {
    private final Set<FullPageId> pageIds = ConcurrentHashMap.newKeySet();
    private final CompletableFuture<Void> stopBlockingFut = new CompletableFuture();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(FullPageId pageId) {
        boolean enterBusy = this.busyLock.enterBusy();
        assert (enterBusy) : "Method should not be invoked after the fsync phase has started for any page: " + pageId;
        try {
            boolean added = this.pageIds.add(pageId);
            assert (added) : "Page is already in the process of being replaced: " + pageId;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void unblock(FullPageId pageId, @Nullable Throwable error) {
        boolean rmv = this.pageIds.remove(pageId);
        assert (rmv) : "Replacement for the page either did not start or ended: " + pageId;
        if (error != null) {
            this.stopBlockingFut.completeExceptionally(error);
            return;
        }
        if (!this.busyLock.enterBusy()) {
            if (this.pageIds.isEmpty()) {
                this.stopBlockingFut.complete(null);
            }
        } else {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> stopBlocking() {
        if (this.stopGuard.compareAndSet(false, true)) {
            this.busyLock.block();
        }
        if (this.pageIds.isEmpty()) {
            this.stopBlockingFut.complete(null);
        }
        return this.stopBlockingFut;
    }
}

