/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist.io;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagesListMetaIO
extends PageIO {
    private static final int CNT_OFF = 40;
    private static final int NEXT_META_PAGE_OFF = 42;
    private static final int ITEMS_OFF = 50;
    private static final int ITEM_SIZE = 10;
    public static final IOVersions<PagesListMetaIO> VERSIONS = new IOVersions((PageIO[])new PagesListMetaIO[]{new PagesListMetaIO(1)});

    private PagesListMetaIO(int ver) {
        super(12, ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setCount(pageAddr, 0);
        this.setNextMetaPageId(pageAddr, 0L);
    }

    private int getCount(long pageAddr) {
        return PageUtils.getShort(pageAddr, 40);
    }

    private void setCount(long pageAddr, int cnt) {
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, 40, (short)cnt);
    }

    public long getNextMetaPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 42);
    }

    public void setNextMetaPageId(long pageAddr, long metaPageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 42, metaPageId);
    }

    public void resetCount(long pageAddr) {
        this.setCount(pageAddr, 0);
    }

    public int addTails(int pageSize, long pageAddr, int bucket, PagesList.Stripe[] tails, int tailsOff) {
        assert (bucket >= 0 && bucket <= Short.MAX_VALUE) : bucket;
        this.assertPageType(pageAddr);
        int cnt = this.getCount(pageAddr);
        int cap = this.getCapacity(pageSize, pageAddr);
        if (cnt == cap) {
            return 0;
        }
        int off = this.offset(cnt);
        int write = Math.min(cap - cnt, tails.length - tailsOff);
        for (int i = 0; i < write; ++i) {
            PageUtils.putShort(pageAddr, off, (short)bucket);
            PageUtils.putLong(pageAddr, off + 2, tails[tailsOff].tailId);
            ++tailsOff;
            off += 10;
        }
        this.setCount(pageAddr, cnt + write);
        return write;
    }

    public void getBucketsData(long pageAddr, Map<Integer, GridLongList> res) {
        int cnt = this.getCount(pageAddr);
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        if (cnt == 0) {
            return;
        }
        int off = this.offset(0);
        for (int i = 0; i < cnt; ++i) {
            short bucket = PageUtils.getShort(pageAddr, off);
            assert (bucket >= 0 && bucket <= Short.MAX_VALUE) : bucket;
            long tailId = PageUtils.getLong(pageAddr, off + 2);
            assert (tailId != 0L);
            GridLongList list = res.get(bucket);
            if (list == null) {
                list = new GridLongList();
                res.put(Integer.valueOf(bucket), list);
            }
            list.add(tailId);
            off += 10;
        }
    }

    private int getCapacity(int pageSize, long pageAddr) {
        return (pageSize - 50) / 10;
    }

    private int offset(int idx) {
        return 50 + 10 * idx;
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        int cnt = this.getCount(addr);
        sb.a("PagesListMeta [\n\tnextMetaPageId=").appendHex(this.getNextMetaPageId(addr)).a(",\n\tcount=").a(cnt).a(",\n\tbucketData={");
        HashMap<Integer, GridLongList> bucketsData = new HashMap<Integer, GridLongList>(cnt);
        this.getBucketsData(addr, bucketsData);
        for (Map.Entry e : bucketsData.entrySet()) {
            sb.a("\n\t\tbucket=").a(e.getKey()).a(", list=").a(e.getValue());
        }
        sb.a("\n\t}\n]");
    }
}

