/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockThreadState;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerMXBean;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.SharedPageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.SharedPageLockTrackerDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToFileDumpProcessor;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpHelper;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.jetbrains.annotations.NotNull;

public class PageLockTrackerManager
implements LifecycleAware {
    public static final PageLockListener NOOP_LSNR = new PageLockListener(){

        @Override
        public void onBeforeWriteLock(int cacheId, long pageId, long page) {
        }

        @Override
        public void onWriteLock(int cacheId, long pageId, long page, long pageAddr) {
        }

        @Override
        public void onWriteUnlock(int cacheId, long pageId, long page, long pageAddr) {
        }

        @Override
        public void onBeforeReadLock(int cacheId, long pageId, long page) {
        }

        @Override
        public void onReadLock(int cacheId, long pageId, long page, long pageAddr) {
        }

        @Override
        public void onReadUnlock(int cacheId, long pageId, long page, long pageAddr) {
        }

        @Override
        public void close() {
        }
    };
    private static final long OVERHEAD_SIZE = 48L;
    private final MemoryCalculator memoryCalculator = new MemoryCalculator();
    private final PageLockTrackerMXBean mxBean;
    private final SharedPageLockTracker sharedPageLockTracker;
    private final IgniteLogger log;
    private Set<PageLockThreadState> threads;
    private final String managerNameId;
    private final boolean trackingEnabled = IgniteSystemProperties.getInteger("IGNITE_PAGE_LOCK_TRACKER_TYPE", -1) != -1;

    public PageLockTrackerManager(IgniteLogger log) {
        this(log, "mgr_" + UUID.randomUUID());
    }

    public PageLockTrackerManager(IgniteLogger log, String managerNameId) {
        this.managerNameId = managerNameId;
        this.mxBean = new PageLockTrackerMXBeanImpl(this, this.memoryCalculator);
        this.sharedPageLockTracker = new SharedPageLockTracker(this::onHangThreads, this.memoryCalculator);
        this.log = log;
        this.memoryCalculator.onHeapAllocated(48L);
    }

    private void onHangThreads(@NotNull Set<PageLockThreadState> threads) {
        assert (threads != null);
        if (!threads.equals(this.threads)) {
            this.threads = threads;
            SharedPageLockTrackerDump dump = this.sharedPageLockTracker.dump();
            StringBuilder sb = new StringBuilder();
            threads.forEach(s -> {
                Thread th = s.thread;
                sb.append("(").append(th.getName()).append("-").append(th.getId()).append(", ").append((Object)th.getState()).append(")");
            });
            this.log.warning("Threads hanged: [" + sb + "]");
            this.log.warning(ToStringDumpHelper.toStringDump(dump));
            try {
                Path path = Paths.get(U.defaultWorkDirectory(), "diagnostic");
                ToFileDumpProcessor.toFileDump(dump, path, this.managerNameId);
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to save locks dump file.", e);
            }
        }
    }

    public PageLockListener createPageLockTracker(String name) {
        return this.trackingEnabled ? this.sharedPageLockTracker.registerStructure(name) : NOOP_LSNR;
    }

    public SharedPageLockTrackerDump dumpLocks() {
        return this.sharedPageLockTracker.dump();
    }

    public String dumpLocksToString() {
        return ToStringDumpHelper.toStringDump(this.dumpLocks());
    }

    public void dumpLocksToLog() {
        this.log.warning(this.dumpLocksToString());
    }

    public String dumpLocksToFile() {
        try {
            Path path = Paths.get(U.defaultWorkDirectory(), "diagnostic");
            return ToFileDumpProcessor.toFileDump(this.dumpLocks(), path, this.managerNameId);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public String dumpLocksToFile(String path) {
        try {
            return ToFileDumpProcessor.toFileDump(this.dumpLocks(), Paths.get(path, new String[0]), this.managerNameId);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public PageLockTrackerMXBean mxBean() {
        return this.mxBean;
    }

    public long getHeapOverhead() {
        return this.memoryCalculator.getHeapUsed();
    }

    public long getOffHeapOverhead() {
        return this.memoryCalculator.getOffHeapUsed();
    }

    public long getTotalOverhead() {
        return this.getHeapOverhead() + this.getOffHeapOverhead();
    }

    @Override
    public void start() throws IgniteException {
        this.sharedPageLockTracker.start();
    }

    @Override
    public void stop() throws IgniteException {
        this.sharedPageLockTracker.stop();
    }
}

