/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SupplierRebalanceStatistics {
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong end = new AtomicLong();
    private final Map<Integer, Boolean> parts = new ConcurrentHashMap<Integer, Boolean>();
    private final LongAdder fullParts = new LongAdder();
    private final LongAdder histParts = new LongAdder();
    private final LongAdder fullEntries = new LongAdder();
    private final LongAdder histEntries = new LongAdder();
    private final LongAdder fullBytes = new LongAdder();
    private final LongAdder histBytes = new LongAdder();

    public void merge(SupplierRebalanceStatistics other) {
        this.start.getAndUpdate(prev -> prev == 0L ? other.start() : Math.min(other.start(), prev));
        this.end.getAndUpdate(prev -> Math.max(other.end(), prev));
        this.fullParts.add(other.fullParts());
        this.histParts.add(other.histParts());
        this.fullEntries.add(other.fullEntries());
        this.histEntries.add(other.histEntries());
        this.fullBytes.add(other.fullBytes());
        this.histBytes.add(other.histBytes());
    }

    public void update(boolean hist, int p, long e, long b) {
        Boolean prev = this.parts.put(p, !hist);
        if (Objects.isNull(prev)) {
            (hist ? this.histParts : this.fullParts).add(1L);
        }
        (hist ? this.histEntries : this.fullEntries).add(e);
        (hist ? this.histBytes : this.fullBytes).add(b);
        this.end(U.currentTimeMillis());
    }

    public void start(long start) {
        this.start.set(start);
        this.end(start);
    }

    public void end(long end) {
        this.end.set(end);
    }

    public long start() {
        return this.start.get();
    }

    public long end() {
        return this.end.get();
    }

    public Map<Integer, Boolean> partitions() {
        return this.parts;
    }

    public long fullParts() {
        return this.fullParts.sum();
    }

    public long histParts() {
        return this.histParts.sum();
    }

    public long fullEntries() {
        return this.fullEntries.sum();
    }

    public long histEntries() {
        return this.histEntries.sum();
    }

    public long fullBytes() {
        return this.fullBytes.sum();
    }

    public long histBytes() {
        return this.histBytes.sum();
    }
}

