/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.tasks;

import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.diagnostic.ReconciliationExecutionContext;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.JobContextResource;
import org.apache.ignite.resources.LoggerResource;

public abstract class ReconciliationResourceLimitedJob
extends ComputeJobAdapter {
    @IgniteInstanceResource
    protected IgniteEx ignite;
    @LoggerResource
    protected IgniteLogger log;
    @JobContextResource
    protected ComputeJobContext jobCtx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() throws IgniteException {
        ReconciliationExecutionContext execCtx = this.ignite.context().diagnostic().reconciliationExecutionContext();
        boolean freeThreadsAvailable = execCtx.acquireJobPermitOrHold(this.sessionId(), this.jobCtx);
        if (!freeThreadsAvailable) {
            return null;
        }
        try {
            Object object = this.execute0();
            return object;
        }
        finally {
            execCtx.releaseJobPermit(this.sessionId());
        }
    }

    protected abstract long sessionId();

    protected abstract Object execute0();
}

