/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.checker.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.processors.cache.checker.objects.ReconciliationAffectedEntries;

public class ReconciliationAffectedEntriesExtended
extends ReconciliationAffectedEntries {
    private static final long serialVersionUID = 0L;
    private int inconsistentKeysCnt;
    private int skippedCachesCnt;
    private int skippedEntriesCnt;

    public ReconciliationAffectedEntriesExtended() {
    }

    public ReconciliationAffectedEntriesExtended(Map<UUID, String> nodesIdsToConsistentIdsMap, int inconsistentKeysCnt, int skippedCachesCnt, int skippedEntriesCnt) {
        super(nodesIdsToConsistentIdsMap, null, null);
        this.inconsistentKeysCnt = inconsistentKeysCnt;
        this.skippedCachesCnt = skippedCachesCnt;
        this.skippedEntriesCnt = skippedEntriesCnt;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.inconsistentKeysCnt);
        out.writeInt(this.skippedCachesCnt);
        out.writeInt(this.skippedEntriesCnt);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.inconsistentKeysCnt = in.readInt();
        this.skippedCachesCnt = in.readInt();
        this.skippedEntriesCnt = in.readInt();
    }

    @Override
    public int inconsistentKeysCount() {
        return this.inconsistentKeysCnt;
    }

    @Override
    public int skippedCachesCount() {
        return this.skippedCachesCnt;
    }

    @Override
    public int skippedEntriesCount() {
        return this.skippedEntriesCnt;
    }

    @Override
    public void merge(ReconciliationAffectedEntries outer) {
        assert (outer instanceof ReconciliationAffectedEntriesExtended);
        this.nodesIdsToConsistentIdsMap.putAll(outer.nodesIdsToConsistentIdsMap);
        this.inconsistentKeysCnt += outer.inconsistentKeysCount();
        this.skippedCachesCnt += outer.skippedCachesCount();
        this.skippedEntriesCnt += outer.skippedEntriesCount();
    }

    @Override
    public void print(Consumer<String> printer, boolean includeSensitive) {
        if (this.inconsistentKeysCnt != 0) {
            printer.accept("\nINCONSISTENT KEYS: " + this.inconsistentKeysCount() + "\n\n");
        }
        if (this.skippedCachesCnt != 0) {
            printer.accept("\nSKIPPED CACHES: " + this.skippedCachesCount() + "\n\n");
        }
        if (this.skippedEntriesCnt != 0) {
            printer.accept("\nSKIPPED ENTRIES: " + this.skippedEntriesCount() + "\n\n");
        }
    }
}

