/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePartialUpdateException;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheServerNotFoundException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.LocalAffinityFunction;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.CacheEntrySerializablePredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStoreFactory;
import org.apache.ignite.internal.processors.cache.GridCacheLockTimeoutException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategySupplier;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.warmup.LoadAllWarmUpStrategy;
import org.apache.ignite.internal.processors.cache.warmup.NoOpWarmUpStrategy;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpStrategy;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpStrategySupplier;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheUtils {
    public static final int cheatCacheId;
    public static final int UNDEFINED_CACHE_ID = 0;
    public static final int ENCRYPTION_CRC_AND_METADATA_SIZE = 5;
    public static final String UTILITY_CACHE_NAME = "ignite-sys-cache";
    public static final int UTILITY_CACHE_GROUP_ID;
    public static final String[] RESERVED_NAMES;
    public static final String CONTINUOUS_QRY_LOG_CATEGORY = "org.apache.ignite.continuous.query";
    public static final String CACHE_MSG_LOG_CATEGORY = "org.apache.ignite.cache.msg";
    public static final String ATOMIC_MSG_LOG_CATEGORY = "org.apache.ignite.cache.msg.atomic";
    public static final String TX_MSG_LOG_CATEGORY = "org.apache.ignite.cache.msg.tx";
    public static final String TX_MSG_PREPARE_LOG_CATEGORY = "org.apache.ignite.cache.msg.tx.prepare";
    public static final String TX_MSG_FINISH_LOG_CATEGORY = "org.apache.ignite.cache.msg.tx.finish";
    public static final String TX_MSG_LOCK_LOG_CATEGORY = "org.apache.ignite.cache.msg.tx.lock";
    public static final String TX_MSG_RECOVERY_LOG_CATEGORY = "org.apache.ignite.cache.msg.tx.recovery";
    private static final String DEFAULT_MASK_NAME = "<default>";
    public static final long TTL_MINIMUM = 1L;
    public static final long TTL_ETERNAL = 0L;
    public static final long TTL_NOT_CHANGED = -1L;
    public static final long TTL_ZERO = -2L;
    public static final long EXPIRE_TIME_ETERNAL = 0L;
    public static final long EXPIRE_TIME_CALCULATE = -1L;
    private static final IgnitePredicate[] EMPTY;
    private static final TransactionConfiguration DEFAULT_TX_CFG;
    private static final IgnitePredicate[] EMPTY_FILTER;
    private static final CacheEntryPredicate[] EMPTY_FILTER0;
    private static final CacheEntryPredicate ALWAYS_FALSE0;
    private static final CacheEntryPredicate[] ALWAYS_FALSE0_ARR;
    public static final IgnitePredicate READ_FILTER;
    public static final IgnitePredicate READ_FILTER_NEAR;
    public static final IgnitePredicate READ_FILTER_COLOCATED;
    public static final IgnitePredicate WRITE_FILTER;
    public static final IgnitePredicate WRITE_FILTER_NEAR;
    public static final IgnitePredicate WRITE_FILTER_COLOCATED;
    public static final IgnitePredicate FILTER_NEAR_CACHE_ENTRY;
    private static final IgniteClosure tx2key;
    private static final IgniteClosure txCol2key;
    private static final IgniteClosure tx2xidVer;
    private static final IgniteClosure tx2entry;
    private static final IgniteClosure entry2key;
    private static final IgniteClosure info2key;

    @Deprecated
    public static boolean cheatCache(int id) {
        return cheatCacheId != 0 && id == cheatCacheId;
    }

    protected GridCacheUtils() {
    }

    @Nullable
    public static CacheObject failed(boolean err) throws GridCacheFilterFailedException {
        return GridCacheUtils.failed(err, null);
    }

    @Nullable
    public static CacheObject failed(boolean err, CacheObject val) throws GridCacheFilterFailedException {
        if (err) {
            throw new GridCacheFilterFailedException(val);
        }
        return null;
    }

    public static CacheEntryPredicate[] filterArray(@Nullable CacheEntryPredicate filter) {
        CacheEntryPredicate[] cacheEntryPredicateArray;
        if (filter != null) {
            CacheEntryPredicate[] cacheEntryPredicateArray2 = new CacheEntryPredicate[1];
            cacheEntryPredicateArray = cacheEntryPredicateArray2;
            cacheEntryPredicateArray2[0] = filter;
        } else {
            cacheEntryPredicateArray = CU.empty0();
        }
        return cacheEntryPredicateArray;
    }

    public static <K, V> IgniteClosure<Integer, IgnitePredicate<Cache.Entry<K, V>>[]> factory() {
        return new IgniteClosure<Integer, IgnitePredicate<Cache.Entry<K, V>>[]>(){

            @Override
            public IgnitePredicate<Cache.Entry<K, V>>[] apply(Integer len) {
                return len == 0 ? EMPTY : new IgnitePredicate[len.intValue()];
            }
        };
    }

    public static void checkStore(GridCacheContext<?, ?> ctx) throws IgniteCheckedException {
        if (!ctx.store().configured()) {
            throw new IgniteCheckedException("Failed to find cache store for method 'reload(..)' (is GridCacheStore configured?)");
        }
    }

    public static Collection<ClusterNode> affinityNodes(GridCacheContext ctx, AffinityTopologyVersion topVer) {
        return ctx.discovery().cacheGroupAffinityNodes(ctx.groupId(), topVer);
    }

    public static boolean isNearEnabled(GridCacheContext ctx) {
        return GridCacheUtils.isNearEnabled(ctx.config());
    }

    public static boolean isNearEnabled(CacheConfiguration cfg) {
        if (cfg.getCacheMode() == CacheMode.LOCAL) {
            return false;
        }
        return cfg.getNearConfiguration() != null;
    }

    @Nullable
    public static ClusterNode oldest(Collection<ClusterNode> nodes) {
        ClusterNode oldest = null;
        for (ClusterNode n : nodes) {
            if (oldest != null && n.order() >= oldest.order()) continue;
            oldest = n;
        }
        return oldest;
    }

    public static <K, V> IgnitePredicate<Cache.Entry<K, V>>[] empty() {
        return EMPTY_FILTER;
    }

    public static CacheEntryPredicate[] empty0() {
        return EMPTY_FILTER0;
    }

    public static CacheEntryPredicate[] alwaysFalse0Arr() {
        return ALWAYS_FALSE0_ARR;
    }

    public static IgniteClosure<IgniteInternalTx, GridCacheVersion> tx2xidVersion() {
        return tx2xidVer;
    }

    public static IgniteClosure<GridCacheEntryEx, KeyCacheObject> entry2Key() {
        return entry2key;
    }

    public static <K, V> IgniteClosure<GridCacheEntryInfo, K> info2Key() {
        return info2key;
    }

    public static IgnitePredicate<IgniteTxEntry> reads() {
        return READ_FILTER;
    }

    public static IgnitePredicate<IgniteTxEntry> writes() {
        return WRITE_FILTER;
    }

    public static IgniteReducer<Boolean, Boolean> boolReducer() {
        return new IgniteReducer<Boolean, Boolean>(){
            private final AtomicBoolean bool = new AtomicBoolean(true);

            @Override
            public boolean collect(Boolean b) {
                this.bool.compareAndSet(true, b);
                return this.bool.get();
            }

            @Override
            public Boolean reduce() {
                return this.bool.get();
            }

            public String toString() {
                return "Bool reducer: " + this.bool;
            }
        };
    }

    public static IgniteReducer<Long, Long> longReducer() {
        return new IgniteReducer<Long, Long>(){
            private final LongAdder res = new LongAdder();

            @Override
            public boolean collect(Long l) {
                if (l != null) {
                    this.res.add(l);
                }
                return true;
            }

            @Override
            public Long reduce() {
                return this.res.sum();
            }

            public String toString() {
                return "Long reducer: " + this.res;
            }
        };
    }

    public static <K, V> IgniteReducer<Map<K, V>, Map<K, V>> mapsReducer(final int size) {
        return new IgniteReducer<Map<K, V>, Map<K, V>>(){
            private final Map<K, V> ret;
            {
                this.ret = new ConcurrentHashMap(size);
            }

            @Override
            public boolean collect(Map<K, V> map) {
                if (map != null) {
                    this.ret.putAll(map);
                }
                return true;
            }

            @Override
            public Map<K, V> reduce() {
                return this.ret;
            }

            public String toString() {
                return "Map reducer: " + this.ret;
            }
        };
    }

    public static <T> IgniteReducer<Collection<T>, Collection<T>> collectionsReducer(final int size) {
        return new IgniteReducer<Collection<T>, Collection<T>>(){
            private List<T> ret;

            @Override
            public synchronized boolean collect(Collection<T> c) {
                if (c == null) {
                    return true;
                }
                if (this.ret == null) {
                    this.ret = new ArrayList(size);
                }
                this.ret.addAll(c);
                return true;
            }

            @Override
            public synchronized Collection<T> reduce() {
                return this.ret == null ? Collections.emptyList() : this.ret;
            }

            public synchronized String toString() {
                return "Collection reducer: " + this.ret;
            }
        };
    }

    public static <T> IgniteReducer<T, Collection<T>> objectsReducer() {
        return new IgniteReducer<T, Collection<T>>(){
            private final Collection<T> ret = new ConcurrentLinkedQueue();

            @Override
            public boolean collect(T item) {
                if (item != null) {
                    this.ret.add(item);
                }
                return true;
            }

            @Override
            public Collection<T> reduce() {
                return this.ret;
            }
        };
    }

    public static ClusterNode primary(Iterable<? extends ClusterNode> nodes) {
        ClusterNode n = F.first(nodes);
        assert (n != null);
        return n;
    }

    public static Collection<ClusterNode> backups(Collection<ClusterNode> nodes) {
        if (nodes == null || nodes.size() <= 1) {
            return Collections.emptyList();
        }
        return F.view(nodes, F.notEqualTo(F.first(nodes)));
    }

    public static IgniteInClosure<IgniteInternalFuture<?>> errorLogger(final IgniteLogger log, final Class<? extends Exception> ... excl) {
        return new CI1<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> f) {
                try {
                    f.get();
                }
                catch (IgniteCheckedException e) {
                    if (!F.isEmpty(excl)) {
                        for (Class cls : excl) {
                            if (!e.hasCause(cls)) continue;
                            return;
                        }
                    }
                    U.error(log, "Future execution resulted in error: " + f, e);
                }
            }

            public String toString() {
                return "Error logger [excludes=" + Arrays.toString(excl) + ']';
            }
        };
    }

    public static boolean isLockTimeoutOrCancelled(Throwable t) {
        if (t == null) {
            return false;
        }
        while (t instanceof IgniteCheckedException || t instanceof IgniteException) {
            t = t.getCause();
        }
        return t instanceof GridCacheLockTimeoutException || t instanceof GridDistributedLockCancelledException;
    }

    public static byte[] marshal(GridCacheContext ctx, Object obj) throws IgniteCheckedException {
        assert (ctx != null);
        return GridCacheUtils.marshal(ctx.shared(), ctx.deploymentEnabled(), obj);
    }

    public static byte[] marshal(GridCacheSharedContext ctx, boolean depEnabled, Object obj) throws IgniteCheckedException {
        assert (ctx != null);
        if (depEnabled && obj != null) {
            if (obj instanceof Iterable) {
                ctx.deploy().registerClasses((Iterable)obj);
            } else if (obj.getClass().isArray()) {
                if (!U.isPrimitiveArray(obj)) {
                    ctx.deploy().registerClasses((Object[])obj);
                }
            } else {
                ctx.deploy().registerClass(obj);
            }
        }
        return U.marshal(ctx, obj);
    }

    public static Object skipValue(Object val, boolean skip) {
        if (skip) {
            return val != null ? Boolean.valueOf(true) : null;
        }
        return val;
    }

    public static GridNearTxLocal txStartInternal(GridCacheContext ctx, IgniteInternalCache prj, TransactionConcurrency concurrency, TransactionIsolation isolation) {
        assert (ctx != null);
        assert (prj != null);
        ctx.tm().resetContext();
        return prj.txStartEx(concurrency, isolation);
    }

    public static boolean txOnPrimary(IgniteInternalTx tx) {
        if (tx.near() && tx.local() && ((GridNearTxLocal)tx).colocatedLocallyMapped()) {
            return true;
        }
        return tx.dht() && tx.local();
    }

    public static String txDump(@Nullable IgniteInternalTx tx) {
        return GridCacheUtils.txString(tx);
    }

    public static String txString(@Nullable IgniteInternalTx tx) {
        if (tx == null) {
            return "null";
        }
        return tx.getClass().getSimpleName() + "[xid=" + tx.xid() + ", xidVersion=" + tx.xidVersion() + ", nearXidVersion=" + tx.nearXidVersion() + ", concurrency=" + (Object)((Object)tx.concurrency()) + ", isolation=" + (Object)((Object)tx.isolation()) + ", state=" + (Object)((Object)tx.state()) + ", topVer=" + tx.topologyVersionSnapshot() + ", invalidate=" + tx.isInvalidate() + ", rollbackOnly=" + tx.isRollbackOnly() + ", nodeId=" + tx.nodeId() + ", timeout=" + tx.timeout() + ", startTime=" + tx.startTime() + ", duration=" + (U.currentTimeMillis() - tx.startTime()) + (tx instanceof GridNearTxLocal ? ", label=" + tx.label() : "") + ']';
    }

    public static void unwindEvicts(GridCacheContext ctx) {
        assert (ctx != null);
        if (ctx.started()) {
            ctx.ttl().expire();
        }
    }

    public static <K, V> void unwindEvicts(GridCacheSharedContext<K, V> ctx) {
        assert (ctx != null);
        for (GridCacheContext cacheCtx : ctx.cacheContexts()) {
            GridCacheUtils.unwindEvicts(cacheCtx);
        }
    }

    public static Comparator<ClusterNode> nodeComparator(final boolean asc) {
        return new Comparator<ClusterNode>(){

            @Override
            public int compare(ClusterNode n1, ClusterNode n2) {
                long o1 = n1.order();
                long o2 = n2.order();
                return asc ? (o1 < o2 ? -1 : (o1 == o2 ? 0 : 1)) : (o1 < o2 ? 1 : (o1 == o2 ? 0 : -1));
            }

            public String toString() {
                return "Node comparator [asc=" + asc + ']';
            }
        };
    }

    public static String mask(String cacheName) {
        return cacheName != null ? cacheName : DEFAULT_MASK_NAME;
    }

    @Nullable
    public static String unmask(String cacheName) {
        return DEFAULT_MASK_NAME.equals(cacheName) ? null : cacheName;
    }

    public static String replicationTopicSend() {
        return GridTopic.TOPIC_REPLICATION.toString();
    }

    public static String replicationTopicReceive(String cacheName) {
        return (Object)((Object)GridTopic.TOPIC_REPLICATION) + "-" + GridCacheUtils.mask(cacheName);
    }

    public static void checkAttributeMismatch(IgniteLogger log, CacheConfiguration locCfg, CacheConfiguration rmtCfg, UUID rmtNodeId, T2<String, String> attr, boolean fail) throws IgniteCheckedException {
        assert (rmtNodeId != null);
        assert (attr != null);
        assert (attr.get1() != null);
        assert (attr.get2() != null);
        Object locVal = U.property(locCfg, (String)attr.get1());
        Object rmtVal = U.property(rmtCfg, (String)attr.get1());
        GridCacheUtils.checkAttributeMismatch(log, rmtCfg.getName(), rmtNodeId, (String)attr.get1(), (String)attr.get2(), locVal, rmtVal, fail);
    }

    public static void checkAttributeMismatch(IgniteLogger log, String cfgName, UUID rmtNodeId, String attrName, String attrMsg, @Nullable Object locVal, @Nullable Object rmtVal, boolean fail) throws IgniteCheckedException {
        assert (rmtNodeId != null);
        assert (attrName != null);
        assert (attrMsg != null);
        if (!F.eq(locVal, rmtVal)) {
            GridCacheUtils.throwIgniteCheckedException(log, fail, attrMsg + " mismatch [cacheName=" + cfgName + ", local" + GridCacheUtils.capitalize(attrName) + "=" + locVal + ", remote" + GridCacheUtils.capitalize(attrName) + "=" + rmtVal + ", rmtNodeId=" + rmtNodeId + ']');
        }
    }

    public static void validateCacheGroupsAttributesMismatch(IgniteLogger log, CacheConfiguration cfg1, CacheConfiguration cfg2, String attrName, String attrMsg, Object val1, Object val2, boolean fail) throws IgniteCheckedException {
        if (F.eq(val1, val2)) {
            return;
        }
        if (fail) {
            throw new IgniteCheckedException(attrMsg + " mismatch for caches related to the same group [groupName=" + cfg1.getGroupName() + ", existingCache=" + cfg1.getName() + ", existing" + GridCacheUtils.capitalize(attrName) + "=" + val1 + ", startingCache=" + cfg2.getName() + ", starting" + GridCacheUtils.capitalize(attrName) + "=" + val2 + ']');
        }
        U.warn(log, attrMsg + " mismatch for caches related to the same group [groupName=" + cfg1.getGroupName() + ", existingCache=" + cfg1.getName() + ", existing" + GridCacheUtils.capitalize(attrName) + "=" + val1 + ", startingCache=" + cfg2.getName() + ", starting" + GridCacheUtils.capitalize(attrName) + "=" + val2 + ']');
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static boolean isUtilityCache(String cacheName) {
        return UTILITY_CACHE_NAME.equals(cacheName);
    }

    public static boolean isSystemCache(String cacheName) {
        return GridCacheUtils.isUtilityCache(cacheName);
    }

    public static int cacheId(String cacheName) {
        if (cacheName != null) {
            int hash = cacheName.hashCode();
            if (hash == 0) {
                hash = 1;
            }
            return hash;
        }
        return 1;
    }

    public static int cacheGroupId(String cacheName, @Nullable String grpName) {
        assert (cacheName != null);
        return grpName != null ? CU.cacheId(grpName) : CU.cacheId(cacheName);
    }

    public static long toExpireTime(long ttl) {
        long expireTime;
        assert (ttl != -2L && ttl != -1L && ttl >= 0L) : "Invalid TTL: " + ttl;
        long l = expireTime = ttl == 0L ? 0L : U.currentTimeMillis() + ttl;
        if (expireTime < 0L) {
            expireTime = 0L;
        }
        return expireTime;
    }

    public static <K, V> void inTx(IgniteInternalCache<K, V> cache, TransactionConcurrency concurrency, TransactionIsolation isolation, IgniteInClosureX<IgniteInternalCache<K, V>> clo) throws IgniteCheckedException {
        try (GridNearTxLocal tx = cache.txStartEx(concurrency, isolation);){
            clo.applyx(cache);
            tx.commit();
        }
    }

    public static <K, V> void inTx(Ignite ignite, IgniteCache<K, V> cache, TransactionConcurrency concurrency, TransactionIsolation isolation, IgniteInClosureX<IgniteCache<K, V>> clo) throws IgniteCheckedException {
        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
            clo.applyx(cache);
            tx.commit();
        }
    }

    public static <K, V> UUID subjectId(IgniteInternalTx tx, GridCacheSharedContext<K, V> ctx) {
        if (tx == null) {
            return ctx.localNodeId();
        }
        UUID subjId = tx.subjectId();
        return subjId != null ? subjId : tx.originatingNodeId();
    }

    public static <K, V> void invalidate(IgniteCache<K, V> cache, K key) {
        cache.localClear(key);
    }

    public static long toTtl(Duration duration) {
        if (duration == null) {
            return -1L;
        }
        if (duration.getDurationAmount() == 0L) {
            if (duration.isEternal()) {
                return 0L;
            }
            assert (duration.isZero());
            return -2L;
        }
        assert (duration.getTimeUnit() != null) : duration;
        return duration.getTimeUnit().toMillis(duration.getDurationAmount());
    }

    public static long ttlForLoad(ExpiryPolicy plc) {
        if (plc != null) {
            long ttl = GridCacheUtils.toTtl(plc.getExpiryForCreation());
            if (ttl == -1L) {
                ttl = 0L;
            }
            return ttl;
        }
        return 0L;
    }

    public static long expireTimeInPast() {
        return U.currentTimeMillis() - 1L;
    }

    @NotNull
    public static RuntimeException convertToCacheException(IgniteCheckedException e) {
        IgniteClientDisconnectedCheckedException disconnectedErr = e.getCause(IgniteClientDisconnectedCheckedException.class);
        if (disconnectedErr != null) {
            assert (disconnectedErr.reconnectFuture() != null) : disconnectedErr;
            e = disconnectedErr;
        }
        if (e.hasCause(CacheWriterException.class)) {
            return new CacheWriterException(U.convertExceptionNoWrap(e));
        }
        if (e instanceof CachePartialUpdateCheckedException) {
            return new CachePartialUpdateException((CachePartialUpdateCheckedException)e);
        }
        if (e.hasCause(ClusterTopologyServerNotFoundException.class)) {
            return new CacheServerNotFoundException(e.getMessage(), e);
        }
        if (e instanceof SchemaOperationException) {
            return new CacheException(e.getMessage(), e);
        }
        CacheException ce = X.cause(e, CacheException.class);
        if (ce != null) {
            return ce;
        }
        if (e.getCause() instanceof NullPointerException) {
            return (NullPointerException)e.getCause();
        }
        if (e.getCause() instanceof SecurityException) {
            return (SecurityException)e.getCause();
        }
        C1<IgniteCheckedException, IgniteException> converter = U.getExceptionConverter(e.getClass());
        return converter != null ? new CacheException((Throwable)converter.apply(e)) : new CacheException(e);
    }

    @Nullable
    public static <T> T value(@Nullable CacheObject cacheObj, GridCacheContext ctx, boolean cpy) {
        return cacheObj != null ? (T)cacheObj.value(ctx.cacheObjectContext(), cpy) : null;
    }

    public static <C extends CachePluginConfiguration> C cachePluginConfiguration(CacheConfiguration cfg, Class<C> cl) {
        if (cfg.getPluginConfigurations() != null) {
            for (CachePluginConfiguration pluginCfg : cfg.getPluginConfigurations()) {
                if (pluginCfg.getClass() != cl) continue;
                return (C)pluginCfg;
            }
        }
        return null;
    }

    public static <T extends CachePluginConfiguration> List<T> cachePluginConfigurations(IgniteConfiguration cfg, Class<T> cls) {
        ArrayList<CachePluginConfiguration> res = new ArrayList<CachePluginConfiguration>();
        if (cfg.getCacheConfiguration() != null) {
            for (CacheConfiguration ccfg : cfg.getCacheConfiguration()) {
                for (CachePluginConfiguration pluginCcfg : ccfg.getPluginConfigurations()) {
                    if (cls != pluginCcfg.getClass()) continue;
                    res.add(pluginCcfg);
                }
            }
        }
        return res;
    }

    public static boolean affinityNode(ClusterNode node, IgnitePredicate<ClusterNode> filter) {
        return !node.isDaemon() && !node.isClient() && filter.apply(node);
    }

    public static boolean baselineNode(ClusterNode node, DiscoveryDataClusterState discoveryDataClusterState) {
        return discoveryDataClusterState.baselineTopology().consistentIds().contains(node.consistentId());
    }

    public static Collection<CacheStoreSessionListener> startStoreSessionListeners(GridKernalContext ctx, Factory<CacheStoreSessionListener>[] factories) throws IgniteCheckedException {
        if (factories == null) {
            return null;
        }
        ArrayList<CacheStoreSessionListener> lsnrs = new ArrayList<CacheStoreSessionListener>(factories.length);
        for (Factory<CacheStoreSessionListener> factory : factories) {
            CacheStoreSessionListener lsnr = factory.create();
            if (lsnr == null) continue;
            ctx.resource().injectGeneric(lsnr);
            if (lsnr instanceof LifecycleAware) {
                ((LifecycleAware)((Object)lsnr)).start();
            }
            lsnrs.add(lsnr);
        }
        return lsnrs;
    }

    public static Map<Integer, int[]> convertInvalidPartitions(Map<Integer, Set<Integer>> partsMap) {
        HashMap<Integer, int[]> res = new HashMap<Integer, int[]>(partsMap.size());
        for (Map.Entry<Integer, Set<Integer>> entry : partsMap.entrySet()) {
            Set<Integer> parts = entry.getValue();
            int[] partsArr = new int[parts.size()];
            int idx = 0;
            for (Integer part : parts) {
                partsArr[idx++] = part;
            }
            res.put(entry.getKey(), partsArr);
        }
        return res;
    }

    public static void stopStoreSessionListeners(GridKernalContext ctx, Collection<CacheStoreSessionListener> sesLsnrs) throws IgniteCheckedException {
        if (sesLsnrs == null) {
            return;
        }
        for (CacheStoreSessionListener lsnr : sesLsnrs) {
            if (lsnr instanceof LifecycleAware) {
                ((LifecycleAware)((Object)lsnr)).stop();
            }
            ctx.resource().cleanupGeneric(lsnr);
        }
    }

    public static <S> S retryTopologySafe(Callable<S> c) throws IgniteCheckedException {
        Object err = null;
        for (int i = 0; i < GridCacheAdapter.MAX_RETRIES; ++i) {
            try {
                return c.call();
            }
            catch (ClusterGroupEmptyCheckedException | ClusterTopologyServerNotFoundException e) {
                throw e;
            }
            catch (TransactionRollbackException e) {
                if (i + 1 == GridCacheAdapter.MAX_RETRIES) {
                    throw e;
                }
                U.sleep(1L);
                continue;
            }
            catch (IgniteCheckedException e) {
                if (i + 1 == GridCacheAdapter.MAX_RETRIES) {
                    throw e;
                }
                if (X.hasCause((Throwable)e, ClusterTopologyCheckedException.class)) {
                    ClusterTopologyCheckedException topErr = e.getCause(ClusterTopologyCheckedException.class);
                    if (topErr instanceof ClusterGroupEmptyCheckedException || topErr instanceof ClusterTopologyServerNotFoundException) {
                        throw e;
                    }
                    if (topErr.retryReadyFuture() != null) {
                        topErr.retryReadyFuture().get();
                        continue;
                    }
                    U.sleep(1L);
                    continue;
                }
                if (X.hasCause((Throwable)e, IgniteTxRollbackCheckedException.class, CachePartialUpdateCheckedException.class)) {
                    U.sleep(1L);
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IgniteCheckedException(e);
            }
        }
        throw err;
    }

    public static Map<UUID, Collection<ClusterNode>> neighbors(Collection<ClusterNode> topSnapshot) {
        HashMap<String, HashSet<ClusterNode>> macMap = new HashMap<String, HashSet<ClusterNode>>(topSnapshot.size(), 1.0f);
        for (ClusterNode node : topSnapshot) {
            String macs = (String)node.attribute("org.apache.ignite.macs");
            HashSet<ClusterNode> nodes = (HashSet<ClusterNode>)macMap.get(macs);
            if (nodes == null) {
                nodes = new HashSet<ClusterNode>();
                macMap.put(macs, nodes);
            }
            nodes.add(node);
        }
        HashMap<UUID, Collection<ClusterNode>> neighbors = new HashMap<UUID, Collection<ClusterNode>>(topSnapshot.size(), 1.0f);
        for (Collection group : macMap.values()) {
            for (ClusterNode node : group) {
                neighbors.put(node.id(), group);
            }
        }
        return neighbors;
    }

    public static Collection<ClusterNode> neighborsForNodes(Map<UUID, Collection<ClusterNode>> neighborhood, Iterable<ClusterNode> nodes) {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>();
        for (ClusterNode node : nodes) {
            if (res.contains(node)) continue;
            res.addAll(neighborhood.get(node.id()));
        }
        return res;
    }

    public static TransactionConfiguration transactionConfiguration(@Nullable GridCacheContext sysCacheCtx, IgniteConfiguration cfg) {
        return sysCacheCtx != null && sysCacheCtx.systemTx() ? DEFAULT_TX_CFG : cfg.getTransactionConfiguration();
    }

    public static void validateCacheName(String name) throws IllegalArgumentException {
        A.ensure(name != null && !name.isEmpty(), "Cache name must not be null or empty.");
    }

    public static void validateNewCacheName(String name) throws IllegalArgumentException {
        GridCacheUtils.validateCacheName(name);
        A.ensure(!GridCacheUtils.isReservedCacheName(name), "Cache name cannot be \"" + name + "\" because it is reserved for internal purposes.");
        if (IgniteSystemProperties.getBoolean("IGNITE_VALIDATE_CACHE_NAMES", true)) {
            boolean hasIllegalCharacters = name.contains("/") || name.contains("\\") || name.contains("\u0000") || name.contains("\n");
            A.ensure(!hasIllegalCharacters, "Cache name cannot contain slashes (/), backslashes (\\), line separators (\\n), or null characters (\\0). [cacheName=" + name + "]");
        }
    }

    public static void validateNewCacheName(CacheConfiguration ccfg, DataStorageConfiguration dsCfg) throws IllegalArgumentException {
        GridCacheUtils.validateNewCacheName(ccfg.getName());
        if (ccfg != null && !CU.isCacheTemplateName(ccfg.getName()) && CU.containsInvalidFileNameChars(ccfg, dsCfg)) {
            throw new IllegalArgumentException("Cache start failed. Cache or group name contains the characters that are not allowed in file names [cache=" + ccfg.getName() + (ccfg.getGroupName() == null ? "" : ", group=" + ccfg.getGroupName()) + ']');
        }
    }

    public static void validateCacheNames(Collection<String> cacheNames) throws IllegalArgumentException {
        A.notNull(cacheNames, "cacheNames");
        for (String name : cacheNames) {
            GridCacheUtils.validateCacheName(name);
        }
    }

    public static void validateConfigurationCacheNames(Collection<CacheConfiguration> ccfgs, DataStorageConfiguration dsCfg) throws IllegalArgumentException {
        for (CacheConfiguration ccfg : ccfgs) {
            GridCacheUtils.validateNewCacheName(ccfg, dsCfg);
        }
    }

    public static boolean isReservedCacheName(String name) {
        for (String reserved : RESERVED_NAMES) {
            if (!reserved.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> validateKeyConfigiration(String groupName, String cacheName, CacheKeyConfiguration[] cacheKeyCfgs, IgniteLogger log, boolean fail) throws IgniteCheckedException {
        HashMap<String, String> keyConfigurations = new HashMap<String, String>();
        if (cacheKeyCfgs != null) {
            for (CacheKeyConfiguration cacheKeyCfg : cacheKeyCfgs) {
                String typeName = cacheKeyCfg.getTypeName();
                A.notNullOrEmpty(typeName, "typeName");
                String fieldName = cacheKeyCfg.getAffinityKeyFieldName();
                A.notNullOrEmpty(fieldName, "affKeyFieldName");
                String oldFieldName = keyConfigurations.put(typeName, fieldName);
                if (oldFieldName == null || oldFieldName.equals(fieldName)) continue;
                String msg = "Cache key configuration contains conflicting definitions: [" + (groupName != null ? "cacheGroup=" + groupName + ", " : "") + "cacheName=" + cacheName + ", typeName=" + typeName + ", affKeyFieldName1=" + oldFieldName + ", affKeyFieldName2=" + fieldName + "].";
                GridCacheUtils.throwIgniteCheckedException(log, fail, msg);
            }
        }
        return keyConfigurations;
    }

    private static void throwIgniteCheckedException(IgniteLogger log, boolean fail, String msg) throws IgniteCheckedException {
        if (fail) {
            throw new IgniteCheckedException(msg + " Fix cache configuration or set system property -D" + "IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK" + "=true.");
        }
        assert (log != null);
        U.warn(log, msg);
    }

    public static void validateKeyConfigiration(String groupName, String cacheName, UUID rmtNodeId, CacheKeyConfiguration[] rmtCacheKeyCfgs, CacheKeyConfiguration[] locCacheKeyCfgs, IgniteLogger log, boolean fail) throws IgniteCheckedException {
        Map<String, String> rmtAffinityKeys = CU.validateKeyConfigiration(groupName, cacheName, rmtCacheKeyCfgs, log, fail);
        Map<String, String> locAffinityKey = CU.validateKeyConfigiration(groupName, cacheName, locCacheKeyCfgs, log, fail);
        if (rmtAffinityKeys.size() != locAffinityKey.size()) {
            GridCacheUtils.throwIgniteCheckedException(log, fail, "Affinity key configuration mismatch[" + (groupName != null ? "cacheGroup=" + groupName + ", " : "") + "cacheName=" + cacheName + ", remote keyConfiguration.length=" + rmtAffinityKeys.size() + ", local keyConfiguration.length=" + locAffinityKey.size() + (rmtNodeId != null ? ", rmtNodeId=" + rmtNodeId : "") + ']');
        }
        for (Map.Entry<String, String> rmtAffinityKey : rmtAffinityKeys.entrySet()) {
            String locFieldName;
            String rmtTypeName = rmtAffinityKey.getKey();
            String rmtFieldName = rmtAffinityKey.getValue();
            if (rmtFieldName.equals(locFieldName = locAffinityKey.get(rmtTypeName))) continue;
            GridCacheUtils.throwIgniteCheckedException(log, fail, "Affinity key configuration mismatch [" + (groupName != null ? "cacheGroup=" + groupName + ", " : "") + "cacheName=" + cacheName + ", typeName=" + rmtTypeName + ", remote affinityKeyFieldName=" + rmtFieldName + ", local affinityKeyFieldName=" + locFieldName + (rmtNodeId != null ? ", rmtNodeId=" + rmtNodeId : "") + ']');
        }
    }

    public static void initializeConfigDefaults(IgniteLogger log, CacheConfiguration cfg, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        if (cfg.getCacheMode() == null) {
            cfg.setCacheMode(CacheConfiguration.DFLT_CACHE_MODE);
        }
        if (cfg.getNodeFilter() == null) {
            cfg.setNodeFilter(CacheConfiguration.ALL_NODES);
        }
        if (cfg.getAffinity() == null) {
            RendezvousAffinityFunction aff;
            if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
                aff = new RendezvousAffinityFunction();
                cfg.setAffinity(aff);
            } else if (cfg.getCacheMode() == CacheMode.REPLICATED) {
                aff = new RendezvousAffinityFunction(false, 512);
                cfg.setAffinity(aff);
                cfg.setBackups(Integer.MAX_VALUE);
            } else {
                cfg.setAffinity(new LocalAffinityFunction());
            }
        } else if (cfg.getCacheMode() == CacheMode.LOCAL && !(cfg.getAffinity() instanceof LocalAffinityFunction)) {
            cfg.setAffinity(new LocalAffinityFunction());
            U.warn(log, "AffinityFunction configuration parameter will be ignored for local cache [cacheName=" + U.maskName(cfg.getName()) + ']');
        }
        GridCacheUtils.validateKeyConfigiration(cfg.getGroupName(), cfg.getName(), cfg.getKeyConfiguration(), log, true);
        if (cfg.getCacheMode() == CacheMode.REPLICATED) {
            cfg.setBackups(Integer.MAX_VALUE);
        }
        if (cfg.getQueryParallelism() > 1 && cfg.getCacheMode() != CacheMode.PARTITIONED) {
            throw new IgniteCheckedException("Segmented indices are supported for PARTITIONED mode only.");
        }
        if (cfg.getAffinityMapper() == null) {
            cfg.setAffinityMapper(cacheObjCtx.defaultAffMapper());
        }
        if (cfg.getRebalanceMode() == null) {
            cfg.setRebalanceMode(CacheRebalanceMode.ASYNC);
        }
        if (cfg.getAtomicityMode() == null) {
            cfg.setAtomicityMode(CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE);
        }
        if (cfg.getWriteSynchronizationMode() == null) {
            cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        }
        assert (cfg.getWriteSynchronizationMode() != null);
        if (cfg.getCacheStoreFactory() == null) {
            Factory writerFactory;
            Factory ldrFactory = cfg.getCacheLoaderFactory();
            Factory factory = writerFactory = cfg.isWriteThrough() ? cfg.getCacheWriterFactory() : null;
            if (ldrFactory != null || writerFactory != null) {
                cfg.setCacheStoreFactory(new GridCacheLoaderWriterStoreFactory(ldrFactory, writerFactory));
            }
        } else {
            if (cfg.getCacheLoaderFactory() != null) {
                throw new IgniteCheckedException("Cannot set both cache loaded factory and cache store factory for cache: " + U.maskName(cfg.getName()));
            }
            if (cfg.getCacheWriterFactory() != null) {
                throw new IgniteCheckedException("Cannot set both cache writer factory and cache store factory for cache: " + U.maskName(cfg.getName()));
            }
        }
        Collection<QueryEntity> entities = cfg.getQueryEntities();
        if (!F.isEmpty(entities)) {
            cfg.clearQueryEntities().setQueryEntities(QueryUtils.normalizeQueryEntities(cacheObjCtx.kernalContext(), entities, cfg));
        }
    }

    @Nullable
    public static BackupPostProcessingClosure createBackupPostProcessingClosure(final AffinityTopologyVersion topVer, final IgniteLogger log, final GridCacheContext cctx, final @Nullable KeyCacheObject key, final @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean readThrough, boolean skipVals) {
        if (cctx.mvccEnabled() || !readThrough || skipVals || key != null && !cctx.affinity().backupsByKey(key, topVer).contains(cctx.localNode())) {
            return null;
        }
        return new BackupPostProcessingClosure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void process(KeyCacheObject key2, CacheObject val, GridCacheVersion ver, GridDhtCacheAdapter colocated) {
                while (true) {
                    GridCacheEntryEx entry = null;
                    cctx.shared().database().checkpointReadLock();
                    try {
                        entry = colocated.entryEx(key2, topVer);
                        entry.initialValue(val, ver, expiryPlc == null ? 0L : expiryPlc.forCreate(), expiryPlc == null ? 0L : GridCacheUtils.toExpireTime(expiryPlc.forCreate()), true, topVer, GridDrType.DR_BACKUP, true, false);
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Got removed entry during postprocessing (will retry): " + entry);
                        continue;
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log, "Error saving backup value: " + entry, e);
                        throw new GridClosureException(e);
                    }
                    catch (GridDhtInvalidPartitionException ignored) {
                    }
                    finally {
                        if (entry != null) {
                            entry.touch();
                        }
                        cctx.shared().database().checkpointReadUnlock();
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void apply(CacheObject val, GridCacheVersion ver) {
                this.process(key, val, ver, cctx.dht());
            }

            @Override
            public void apply(Collection<GridCacheEntryInfo> infos) {
                if (!F.isEmpty(infos)) {
                    GridCacheAffinityManager aff = cctx.affinity();
                    ClusterNode locNode = cctx.localNode();
                    GridDhtCacheAdapter colocated = cctx.cache().isNear() ? ((GridNearCacheAdapter)cctx.cache()).dht() : cctx.dht();
                    for (GridCacheEntryInfo info : infos) {
                        if (!aff.backupsByKey(info.key(), topVer).contains(locNode)) continue;
                        this.process(info.key(), info.value(), info.version(), colocated);
                    }
                }
            }
        };
    }

    public static boolean isPersistentCache(CacheConfiguration ccfg, DataStorageConfiguration dsCfg) {
        if (dsCfg == null) {
            return false;
        }
        if (GridCacheUtils.isSystemCache(ccfg.getName())) {
            if (dsCfg.getDefaultDataRegionConfiguration().isPersistenceEnabled()) {
                return true;
            }
            if (dsCfg.getDataRegionConfigurations() != null) {
                for (DataRegionConfiguration drConf : dsCfg.getDataRegionConfigurations()) {
                    if (!drConf.isPersistenceEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        String regName = ccfg.getDataRegionName();
        if (regName == null || regName.equals(dsCfg.getDefaultDataRegionConfiguration().getName())) {
            return dsCfg.getDefaultDataRegionConfiguration().isPersistenceEnabled();
        }
        if (dsCfg.getDataRegionConfigurations() != null) {
            for (DataRegionConfiguration drConf : dsCfg.getDataRegionConfigurations()) {
                if (!regName.equals(drConf.getName())) continue;
                return drConf.isPersistenceEnabled();
            }
        }
        return false;
    }

    public static boolean isInMemoryCluster(Collection<ClusterNode> nodes, JdkMarshaller marshaller, ClassLoader clsLdr) {
        return nodes.stream().allMatch(serNode -> !CU.isPersistenceEnabled(GridCacheUtils.extractDataStorage(serNode, marshaller, clsLdr)));
    }

    public static Stream<DataRegionConfiguration> dataRegions(Collection<ClusterNode> nodes, JdkMarshaller marshaller, ClassLoader clsLdr) {
        return nodes.stream().map(node -> GridCacheUtils.extractDataStorage(node, marshaller, clsLdr)).flatMap(configuration -> configuration == null ? Stream.empty() : Stream.concat(Stream.of(configuration.getDefaultDataRegionConfiguration()), configuration.getDataRegionConfigurations() == null ? Stream.empty() : Stream.of(configuration.getDataRegionConfigurations())));
    }

    @Nullable
    public static DataStorageConfiguration extractDataStorage(ClusterNode node, JdkMarshaller marshaller, ClassLoader clsLdr) {
        Object dsCfgBytes = node.attribute("org.apache.ignite.data.storage.config");
        if (dsCfgBytes instanceof byte[]) {
            try {
                return (DataStorageConfiguration)marshaller.unmarshal((byte[])dsCfgBytes, clsLdr);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        return null;
    }

    @Nullable
    public static DataRegionConfiguration findDataRegionConfiguration(@Nullable DataStorageConfiguration dsCfg, @Nullable String name) {
        if (dsCfg == null) {
            return null;
        }
        if (name == null || dsCfg.getDefaultDataRegionConfiguration().getName().equals(name)) {
            return dsCfg.getDefaultDataRegionConfiguration();
        }
        DataRegionConfiguration[] regions = dsCfg.getDataRegionConfigurations();
        if (regions == null) {
            return null;
        }
        for (int i = 0; i < regions.length; ++i) {
            if (!regions[i].getName().equals(name)) continue;
            return regions[i];
        }
        return null;
    }

    @Nullable
    public static DataRegionConfiguration findRemoteDataRegionConfiguration(ClusterNode node, JdkMarshaller marshaller, ClassLoader clsLdr, @Nullable String name) {
        return GridCacheUtils.findDataRegionConfiguration(GridCacheUtils.extractDataStorage(node, marshaller, clsLdr), name);
    }

    public static boolean isDefaultDataRegionPersistent(DataStorageConfiguration cfg) {
        if (cfg == null) {
            return false;
        }
        DataRegionConfiguration dfltRegionCfg = cfg.getDefaultDataRegionConfiguration();
        if (dfltRegionCfg == null) {
            return false;
        }
        return dfltRegionCfg.isPersistenceEnabled();
    }

    public static boolean isPersistenceEnabled(IgniteConfiguration cfg) {
        return GridCacheUtils.isPersistenceEnabled(cfg.getDataStorageConfiguration());
    }

    public static boolean isPersistenceEnabled(DataStorageConfiguration cfg) {
        if (cfg == null) {
            return false;
        }
        DataRegionConfiguration dfltReg = cfg.getDefaultDataRegionConfiguration();
        if (dfltReg == null) {
            return false;
        }
        if (dfltReg.isPersistenceEnabled()) {
            return true;
        }
        DataRegionConfiguration[] regCfgs = cfg.getDataRegionConfigurations();
        if (regCfgs == null) {
            return false;
        }
        for (DataRegionConfiguration regCfg : regCfgs) {
            if (!regCfg.isPersistenceEnabled()) continue;
            return true;
        }
        return false;
    }

    public static int encryptedPageSize(int pageSize, EncryptionSpi encSpi) {
        assert (encSpi.blockSize() >= 9 || encSpi.blockSize() == 0) : encSpi.blockSize();
        return pageSize - (encSpi.encryptedSizeNoPadding(pageSize) - pageSize) - encSpi.blockSize();
    }

    public static GridCacheContext<?, ?> firstPartitioned(GridCacheSharedContext<?, ?> sctx, int[] cacheIds) {
        for (int i = 0; i < cacheIds.length; ++i) {
            GridCacheContext<?, ?> cctx = sctx.cacheContext(cacheIds[i]);
            if (cctx == null) {
                throw new CacheException("Failed to find cache.");
            }
            if (cctx.isLocal() || cctx.isReplicated()) continue;
            return cctx;
        }
        return null;
    }

    public static GridCacheContext<?, ?> firstPartitioned(GridCacheSharedContext<?, ?> sctx, Iterable<Integer> cacheIds) {
        for (Integer i : cacheIds) {
            GridCacheContext<?, ?> cctx = sctx.cacheContext(i);
            if (cctx == null) {
                throw new CacheException("Failed to find cache.");
            }
            if (cctx.isLocal() || cctx.isReplicated()) continue;
            return cctx;
        }
        return null;
    }

    public static boolean isCacheTemplateName(String cacheName) {
        return cacheName.endsWith("*");
    }

    public static Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrategies(GridKernalContext kernalCtx) {
        WarmUpStrategy[] defStrats;
        HashMap<Class<? extends WarmUpConfiguration>, WarmUpStrategy> strategies = new HashMap<Class<? extends WarmUpConfiguration>, WarmUpStrategy>();
        for (WarmUpStrategy strategy : defStrats = new WarmUpStrategy[]{new NoOpWarmUpStrategy(), new LoadAllWarmUpStrategy(kernalCtx.log(LoadAllWarmUpStrategy.class), () -> kernalCtx.cache().cacheGroups())}) {
            strategies.putIfAbsent(strategy.configClass(), strategy);
        }
        WarmUpStrategySupplier[] suppliers = (WarmUpStrategySupplier[])kernalCtx.plugins().extensions(WarmUpStrategySupplier.class);
        if (Objects.nonNull(suppliers)) {
            for (WarmUpStrategySupplier supplier : suppliers) {
                for (WarmUpStrategy<?> strategy : supplier.strategies()) {
                    strategies.putIfAbsent(strategy.configClass(), strategy);
                }
            }
        }
        return strategies;
    }

    public static Map<Class<? extends EntryCompressionConfiguration>, IgniteClosure<EntryCompressionConfiguration, EntryCompressionStrategy>> entryCompressionStrategies(GridKernalContext kernalCtx) {
        HashMap<Class<? extends EntryCompressionConfiguration>, IgniteClosure<EntryCompressionConfiguration, EntryCompressionStrategy>> strategies = new HashMap<Class<? extends EntryCompressionConfiguration>, IgniteClosure<EntryCompressionConfiguration, EntryCompressionStrategy>>();
        EntryCompressionStrategySupplier[] suppliers = (EntryCompressionStrategySupplier[])kernalCtx.plugins().extensions(EntryCompressionStrategySupplier.class);
        if (suppliers != null) {
            for (EntryCompressionStrategySupplier supplier : suppliers) {
                strategies.putAll(supplier.strategies());
            }
        }
        return strategies;
    }

    public static <K, V> CacheConfiguration<K, V> patchCacheConfiguration(CacheConfiguration<K, V> oldCfg, SchemaAddQueryEntityOperation op) {
        return GridCacheUtils.patchCacheConfiguration(oldCfg, op.entities(), op.schemaName(), op.isSqlEscape(), op.queryParallelism());
    }

    public static <K, V> CacheConfiguration<K, V> patchCacheConfiguration(CacheConfiguration<K, V> oldCfg, Collection<QueryEntity> entities, String sqlSchema, boolean isSqlEscape, int qryParallelism) {
        return new CacheConfiguration<K, V>(oldCfg).setQueryEntities(entities).setSqlSchema(sqlSchema).setSqlEscapeAll(isSqlEscape).setQueryParallelism(qryParallelism);
    }

    public static boolean containsInvalidFileNameChars(CacheConfiguration<?, ?> ccfg, DataStorageConfiguration dsCfg) {
        if (!CU.isPersistentCache(ccfg, dsCfg)) {
            return false;
        }
        String expDir = FilePageStoreManager.cacheDirName(ccfg);
        try {
            return !expDir.equals(Paths.get(expDir, new String[0]).toFile().getName());
        }
        catch (InvalidPathException ignored) {
            return true;
        }
    }

    static {
        String cheatCache = System.getProperty("CHEAT_CACHE");
        if (cheatCache != null) {
            cheatCacheId = cheatCache.hashCode();
            if (cheatCacheId == 0) {
                throw new RuntimeException();
            }
            System.out.println(">>> Cheat cache ID [id=" + cheatCacheId + ", name=" + cheatCache + ']');
        } else {
            cheatCacheId = 0;
        }
        UTILITY_CACHE_GROUP_ID = GridCacheUtils.cacheGroupId(UTILITY_CACHE_NAME, null);
        RESERVED_NAMES = new String[]{UTILITY_CACHE_NAME, "MetaStorage", "TxLog"};
        EMPTY = new IgnitePredicate[0];
        DEFAULT_TX_CFG = new TransactionConfiguration();
        EMPTY_FILTER = new IgnitePredicate[0];
        EMPTY_FILTER0 = new CacheEntryPredicate[0];
        ALWAYS_FALSE0 = new CacheEntrySerializablePredicate(new CacheEntryPredicateAdapter(){

            @Override
            public boolean apply(GridCacheEntryEx e) {
                return false;
            }
        });
        ALWAYS_FALSE0_ARR = new CacheEntryPredicate[]{ALWAYS_FALSE0};
        READ_FILTER = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() == GridCacheOperation.READ;
            }

            public String toString() {
                return "READ_FILTER";
            }
        };
        READ_FILTER_NEAR = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() == GridCacheOperation.READ && e.context().isNear();
            }

            public String toString() {
                return "READ_FILTER_NEAR";
            }
        };
        READ_FILTER_COLOCATED = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() == GridCacheOperation.READ && !e.context().isNear();
            }

            public String toString() {
                return "READ_FILTER_COLOCATED";
            }
        };
        WRITE_FILTER = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() != GridCacheOperation.READ;
            }

            public String toString() {
                return "WRITE_FILTER";
            }
        };
        WRITE_FILTER_NEAR = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() != GridCacheOperation.READ && e.context().isNear();
            }

            public String toString() {
                return "WRITE_FILTER_NEAR";
            }
        };
        WRITE_FILTER_COLOCATED = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.op() != GridCacheOperation.READ && !e.context().isNear();
            }

            public String toString() {
                return "WRITE_FILTER_COLOCATED";
            }
        };
        FILTER_NEAR_CACHE_ENTRY = new P1<IgniteTxEntry>(){

            @Override
            public boolean apply(IgniteTxEntry e) {
                return e.context().isNear();
            }

            public String toString() {
                return "FILTER_NEAR_CACHE_ENTRY";
            }
        };
        tx2key = new C1<IgniteTxEntry, Object>(){

            @Override
            public Object apply(IgniteTxEntry e) {
                return e.key();
            }

            public String toString() {
                return "Cache transaction entry to key converter.";
            }
        };
        txCol2key = new C1<Collection<IgniteTxEntry>, Collection<Object>>(){

            @Override
            public Collection<Object> apply(Collection<IgniteTxEntry> e) {
                return F.viewReadOnly(e, tx2key, new IgnitePredicate[0]);
            }

            public String toString() {
                return "Cache transaction entry collection to key collection converter.";
            }
        };
        tx2xidVer = new C1<IgniteInternalTx, GridCacheVersion>(){

            @Override
            public GridCacheVersion apply(IgniteInternalTx tx) {
                return tx.xidVersion();
            }

            public String toString() {
                return "Transaction to XID version converter.";
            }
        };
        tx2entry = new C1<IgniteTxEntry, GridCacheEntryEx>(){

            @Override
            public GridCacheEntryEx apply(IgniteTxEntry e) {
                return e.cached();
            }
        };
        entry2key = new C1<GridCacheEntryEx, KeyCacheObject>(){

            @Override
            public KeyCacheObject apply(GridCacheEntryEx e) {
                return e.key();
            }

            public String toString() {
                return "Cache extended entry to key converter.";
            }
        };
        info2key = new C1<GridCacheEntryInfo, Object>(){

            @Override
            public Object apply(GridCacheEntryInfo e) {
                return e.key();
            }

            public String toString() {
                return "Cache extended entry to key converter.";
            }
        };
    }

    public static interface BackupPostProcessingClosure
    extends IgniteInClosure<Collection<GridCacheEntryInfo>>,
    IgniteBiInClosure<CacheObject, GridCacheVersion> {
    }
}

