/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;
import org.apache.ignite.internal.util.lang.IgniteClosure2X;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridCacheTtlManager
extends GridCacheManagerAdapter {
    public static final int DFLT_TTL_EXPIRE_BATCH_SIZE = 5;
    private final int ttlBatchSize = IgniteSystemProperties.getInteger("IGNITE_TTL_EXPIRE_BATCH_SIZE", 5);
    private GridConcurrentSkipListSetEx pendingEntries;
    private GridCacheContext dhtCtx;
    private final ReentrantReadWriteLock topChangeGuard = new ReentrantReadWriteLock();
    private volatile boolean hasRowsToEvict;
    private volatile boolean hasTombstonesToEvict;
    private final IgniteClosure2X<GridCacheEntryEx, Long, Boolean> expireC = new IgniteClosure2X<GridCacheEntryEx, Long, Boolean>(){

        @Override
        public Boolean applyx(GridCacheEntryEx entry, Long expireTime) {
            boolean touch = !entry.isNear();
            while (true) {
                try {
                    if (GridCacheTtlManager.this.log.isTraceEnabled()) {
                        GridCacheTtlManager.this.log.trace("Trying to remove expired entry from cache: " + entry);
                    }
                    if (entry.onTtlExpired(expireTime)) {
                        return true;
                    }
                }
                catch (GridCacheEntryRemovedException ignore) {
                    entry = entry.context().cache().entryEx(entry.key());
                    touch = true;
                    continue;
                }
                break;
            }
            if (touch) {
                entry.touch();
            }
            return false;
        }
    };

    @Override
    protected void start0() throws IgniteCheckedException {
        GridCacheContext gridCacheContext = this.dhtCtx = this.cctx.isNear() ? this.cctx.near().dht().context() : this.cctx;
        if (this.cctx.kernalContext().isDaemon() || this.cctx.kernalContext().clientNode() && this.cctx.config().getNearConfiguration() == null) {
            return;
        }
        this.cctx.shared().ttl().register(this);
        this.pendingEntries = !this.cctx.isLocal() && this.cctx.config().getNearConfiguration() != null ? new GridConcurrentSkipListSetEx() : null;
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        if (this.pendingEntries != null) {
            this.pendingEntries.clear();
        }
    }

    public void unregister() {
        if (!this.starting.get()) {
            return;
        }
        this.cctx.shared().ttl().unregister(this);
    }

    void addTrackedEntry(GridNearCacheEntry entry) {
        assert (entry.lockedByCurrentThread());
        EntryWrapper e = new EntryWrapper(entry);
        this.pendingEntries.add(e);
    }

    void removeTrackedEntry(GridNearCacheEntry entry) {
        assert (entry.lockedByCurrentThread());
        this.pendingEntries.remove(new EntryWrapper(entry));
    }

    public long pendingSize() throws IgniteCheckedException {
        return (long)(this.pendingEntries != null ? this.pendingEntries.sizex() : 0) + this.cctx.offheap().expiredSize();
    }

    public boolean hasPendingEntries(boolean tombstone) {
        return tombstone ? this.hasTombstonesToEvict : this.hasRowsToEvict;
    }

    public void setHasPendingEntries(boolean tombstone) {
        if (tombstone) {
            this.hasTombstonesToEvict = true;
        } else {
            this.hasRowsToEvict = true;
        }
    }

    @Override
    public void printMemoryStats() {
        try {
            X.println(">>>", new Object[0]);
            X.println(">>> TTL processor memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
            X.println(">>>   pendingEntriesSize: " + this.pendingSize(), new Object[0]);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to print statistics: " + e, e);
        }
    }

    public boolean expire() {
        return this.expire(this.ttlBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(int amount) {
        block21: {
            assert (this.cctx != null);
            if (amount == 0) {
                return false;
            }
            long now = U.currentTimeMillis();
            if (!this.topChangeGuard.readLock().tryLock()) {
                return false;
            }
            try {
                if (this.pendingEntries != null) {
                    int limit;
                    EntryWrapper e;
                    GridNearCacheAdapter nearCache = this.cctx.near();
                    for (int cnt = limit = -1 != amount ? amount : this.pendingEntries.sizex(); cnt > 0 && (e = (EntryWrapper)this.pendingEntries.firstx()) != null && e.expireTime <= now; --cnt) {
                        GridNearCacheEntry nearEntry;
                        if (!this.pendingEntries.remove(e) || (nearEntry = nearCache.peekExx(e.key)) == null) continue;
                        this.expireC.apply(nearEntry, now);
                    }
                }
                if (!this.cctx.affinityNode()) {
                    boolean nearCache = false;
                    return nearCache;
                }
                boolean hasRows = false;
                boolean hasTombstones = false;
                if (this.cctx.config().isEagerTtl() && !this.cctx.shared().evict().evictQueue(false).isEmpty()) {
                    hasRows = this.cctx.offheap().expireRows(this.expireC, amount, now);
                }
                if (!this.cctx.shared().evict().evictQueue(true).isEmpty()) {
                    hasTombstones = this.cctx.offheap().expireTombstones(this.expireC, amount, now);
                }
                if (amount != -1 && this.pendingEntries != null) {
                    EntryWrapper e = (EntryWrapper)this.pendingEntries.firstx();
                    boolean bl = e != null && e.expireTime <= now;
                    return bl;
                }
                boolean bl = hasRows || hasTombstones;
                return bl;
            }
            catch (GridDhtInvalidPartitionException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition became invalid during rebalancing (will ignore): " + e.partition());
                }
                boolean bl = false;
                return bl;
            }
            catch (IgniteException e) {
                if (e.hasCause(NodeStoppingException.class)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to expire because node is stopped: " + e);
                    }
                    break block21;
                }
                throw e;
            }
            finally {
                this.topChangeGuard.readLock().unlock();
            }
        }
        return false;
    }

    private static int compareKeys(GridCacheContext cctx1, CacheObject key1, GridCacheContext cctx2, CacheObject key2) {
        int key2Hash;
        int key1Hash = key1.hashCode();
        int res = Integer.compare(key1Hash, key2Hash = key2.hashCode());
        if (res == 0) {
            key1 = (CacheObject)cctx1.unwrapTemporary(key1);
            key2 = (CacheObject)cctx2.unwrapTemporary(key2);
            try {
                byte[] key1ValBytes = key1.valueBytes(cctx1.cacheObjectContext());
                byte[] key2ValBytes = key2.valueBytes(cctx2.cacheObjectContext());
                res = Integer.compare(key1ValBytes.length, key2ValBytes.length);
                if (res == 0) {
                    for (int i = 0; i < key1ValBytes.length && (res = Byte.compare(key1ValBytes[i], key2ValBytes[i])) == 0; ++i) {
                    }
                }
                if (res == 0) {
                    res = Boolean.compare(cctx1.isNear(), cctx2.isNear());
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        return res;
    }

    public void blockExpire(GridDhtPartitionsExchangeFuture fut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Block expiration [initVer=" + fut.initialVersion() + ", ctx=" + this.dhtCtx + ']');
        }
        this.topChangeGuard.writeLock().lock();
    }

    public void unblockExpire(GridDhtPartitionsExchangeFuture fut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unblock expiration [initVer=" + fut.initialVersion() + ", ctx=" + this.dhtCtx + ']');
        }
        this.topChangeGuard.writeLock().unlock();
    }

    private static class GridConcurrentSkipListSetEx
    extends GridConcurrentSkipListSet<EntryWrapper> {
        private static final long serialVersionUID = 0L;
        private final LongAdder size = new LongAdder();

        private GridConcurrentSkipListSetEx() {
        }

        public int sizex() {
            return this.size.intValue();
        }

        @Override
        public boolean add(EntryWrapper e) {
            boolean res = super.add(e);
            if (res) {
                this.size.increment();
            }
            return res;
        }

        @Override
        public boolean remove(Object o) {
            boolean res = super.remove(o);
            if (res) {
                this.size.decrement();
            }
            return res;
        }

        @Override
        @Nullable
        public EntryWrapper pollFirst() {
            EntryWrapper e = (EntryWrapper)super.pollFirst();
            if (e != null) {
                this.size.decrement();
            }
            return e;
        }
    }

    private static class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final long expireTime;
        private final GridCacheContext ctx;
        private final KeyCacheObject key;

        private EntryWrapper(GridCacheMapEntry entry) {
            this.expireTime = entry.expireTimeUnlocked();
            assert (this.expireTime != 0L);
            this.ctx = entry.context();
            this.key = entry.key();
        }

        @Override
        public int compareTo(EntryWrapper o) {
            int res = Long.compare(this.expireTime, o.expireTime);
            if (res == 0) {
                res = GridCacheTtlManager.compareKeys(this.ctx, this.key, o.ctx, o.key);
            }
            return res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntryWrapper)) {
                return false;
            }
            EntryWrapper that = (EntryWrapper)o;
            return this.expireTime == that.expireTime && GridCacheTtlManager.compareKeys(this.ctx, this.key, that.ctx, that.key) == 0;
        }

        public int hashCode() {
            int res = (int)(this.expireTime ^ this.expireTime >>> 32);
            res = 31 * res + this.key.hashCode();
            return res;
        }

        public String toString() {
            return S.toString(EntryWrapper.class, this);
        }
    }
}

