/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.spi.ExponentialBackoffTimeoutStrategy;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.thread.IgniteThread;

public class GridCacheSharedTtlCleanupManager
extends GridCacheSharedManagerAdapter
implements PartitionsExchangeAware {
    private final long cleanupWorkerSleepInterval = IgniteSystemProperties.getLong("CLEANUP_WORKER_SLEEP_INTERVAL", 500L);
    private static final int CLEANUP_WORKER_ENTRIES_PROCESS_LIMIT = 1000;
    public static final long DEFAULT_TOMBSTONE_LIMIT = Long.MAX_VALUE;
    public static final long DEFAULT_MIN_TOMBSTONE_TTL = 30000L;
    public static final String TS_LIMIT = "tombstones.limit";
    public static final String TS_TTL = "tombstones.ttl";
    public static final String TS_CLEANUP = "tombstones.suspended.cleanup";
    public static final String DEFAULT_TOMBSTONE_TTL_PROP = "DEFAULT_TOMBSTONE_TTL";
    private CleanupWorker cleanupWorker;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Integer, GridCacheTtlManager> mgrs = new ConcurrentHashMap<Integer, GridCacheTtlManager>();
    private DistributedLongProperty tsLimit = DistributedLongProperty.detachedLongProperty("tombstones.limit");
    private DistributedLongProperty tsTtl = DistributedLongProperty.detachedLongProperty("tombstones.ttl");
    private DistributedBooleanProperty tsSuspendedCleanup = DistributedBooleanProperty.detachedBooleanProperty("tombstones.suspended.cleanup");
    private long dfltTombstoneTtl;

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.dfltTombstoneTtl = IgniteSystemProperties.getLong(DEFAULT_TOMBSTONE_TTL_PROP, GridCacheSharedTtlCleanupManager.calcDfltTombstoneTTL(this.cctx.kernalContext().config()));
        this.cctx.kernalContext().internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.tsLimit.addListener((name, oldVal, newVal) -> {
                if (oldVal == null && newVal == null) {
                    return;
                }
                U.log(this.log, "Tombstones limit has been updated [oldVal=" + oldVal + ", newVal=" + newVal + ']');
            });
            dispatcher.registerProperty(this.tsLimit);
        });
        this.cctx.kernalContext().internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.tsTtl.addListener((name, oldVal, newVal) -> {
                if (oldVal == null && newVal == null) {
                    return;
                }
                U.log(this.log, "Tombstones time to live has been updated [oldVal=" + oldVal + ", newVal=" + newVal + ']');
            });
            dispatcher.registerProperty(this.tsTtl);
        });
        this.cctx.kernalContext().internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.tsSuspendedCleanup.addListener((name, oldVal, newVal) -> {
                if (oldVal == null && newVal == null) {
                    return;
                }
                if (oldVal == null) {
                    oldVal = false;
                }
                if (!oldVal.booleanValue() && newVal.booleanValue()) {
                    U.log(this.log, "Tombstones cleanup has been disabled");
                } else if (oldVal.booleanValue() && !newVal.booleanValue()) {
                    U.log(this.log, "Tombstones cleanup has been enabled");
                }
            });
            dispatcher.registerProperty(this.tsSuspendedCleanup);
        });
        this.cctx.exchange().registerExchangeAwareComponent(this);
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.stopCleanupWorker();
    }

    public void register(GridCacheTtlManager mgr) {
        if (this.mgrs.isEmpty()) {
            this.startCleanupWorker();
        }
        this.mgrs.put(mgr.context().cacheId(), mgr);
    }

    public void unregister(GridCacheTtlManager mgr) {
        this.mgrs.remove(mgr.context().cacheId());
        if (this.mgrs.isEmpty()) {
            this.stopCleanupWorker();
        }
    }

    public boolean eagerTtlEnabled() {
        assert (this.cctx != null) : "Manager is not started";
        this.lock.lock();
        try {
            boolean bl = this.cleanupWorker != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final long tombstonesLimit() {
        return this.tsLimit.getOrDefault(Long.MAX_VALUE);
    }

    public final long tombstoneExpireTime() {
        return U.currentTimeMillis() + this.tombstoneTTL();
    }

    public final long tombstoneTTL() {
        return this.tsTtl.getOrDefault(this.dfltTombstoneTtl);
    }

    public final boolean tombstoneCleanupSuspended() {
        return this.tsSuspendedCleanup.getOrDefault(false);
    }

    public DistributedLongProperty tombstoneTtlProperty() {
        return this.tsTtl;
    }

    private static long calcDfltTombstoneTTL(IgniteConfiguration cfg) {
        CommunicationSpi commSpi = cfg.getCommunicationSpi();
        long totalTimeout = 0L;
        if (commSpi instanceof TcpCommunicationSpi) {
            TcpCommunicationSpi cfg0 = (TcpCommunicationSpi)commSpi;
            totalTimeout = cfg0.failureDetectionTimeoutEnabled() ? cfg0.failureDetectionTimeout() : ExponentialBackoffTimeoutStrategy.totalBackoffTimeout(cfg0.getConnectTimeout(), cfg0.getMaxConnectTimeout(), cfg0.getReconnectCount());
        }
        return Math.max((long)((double)totalTimeout * 1.5), 30000L);
    }

    private void startCleanupWorker() {
        this.lock.lock();
        try {
            if (this.cleanupWorker != null) {
                return;
            }
            this.cleanupWorker = new CleanupWorker();
            new IgniteThread(this.cleanupWorker).start();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopCleanupWorker() {
        this.lock.lock();
        try {
            if (null != this.cleanupWorker) {
                U.cancel(this.cleanupWorker);
                U.join(this.cleanupWorker, this.log);
                this.cleanupWorker = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onInitBeforeTopologyLock(GridDhtPartitionsExchangeFuture fut) {
        for (GridCacheTtlManager mgr : this.mgrs.values()) {
            mgr.blockExpire(fut);
        }
    }

    @Override
    public void onInitAfterTopologyLock(GridDhtPartitionsExchangeFuture fut) {
        for (GridCacheTtlManager mgr : this.mgrs.values()) {
            mgr.unblockExpire(fut);
        }
    }

    static /* synthetic */ Map access$000(GridCacheSharedTtlCleanupManager x0) {
        return x0.mgrs;
    }

    static /* synthetic */ long access$100(GridCacheSharedTtlCleanupManager x0) {
        return x0.cleanupWorkerSleepInterval;
    }

    private class CleanupWorker
    extends GridWorker {
        CleanupWorker() {
            super(GridCacheSharedTtlCleanupManager.this.cctx.igniteInstanceName(), "ttl-cleanup-worker", GridCacheSharedTtlCleanupManager.this.cctx.logger(GridCacheSharedTtlCleanupManager.class), GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().workersRegistry());
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ GridCacheTtlManager lambda$body$0(AtomicBoolean expiredRemains, Integer id, GridCacheTtlManager m) {
            if (m.expire(1000)) {
                expiredRemains.set(true);
            }
            return m;
        }
    }
}

